/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.redchujelly.cluttered.setup.BlockRegistration;
import net.redchujelly.cluttered.setup.ItemRegistration;

public class ClutteredItemModels
extends ItemModelProvider {
    public ClutteredItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "cluttered", existingFileHelper);
    }

    protected void registerModels() {
        this.fenceItem(BlockRegistration.WILLOW_FENCE, BlockRegistration.WILLOW_PLANKS);
        this.buttonItem(BlockRegistration.WILLOW_BUTTON, BlockRegistration.WILLOW_PLANKS);
        this.simplePaneBlockItem(BlockRegistration.WILLOW_WINDOW_PANE).renderType("cutout");
        this.simpleBlockItem(BlockRegistration.WILLOW_DOOR);
        this.simpleBlockItem(BlockRegistration.WILLOW_LOG_DOOR);
        this.simpleBlockItem(BlockRegistration.WILLOW_GARDEN_DOOR).renderType("cutout");
        this.simplePaneBlockItem(BlockRegistration.WILLOW_SAPLING).renderType("cutout");
        this.simplePaneBlockItem(BlockRegistration.WILLOW_VINES, "_1").renderType("cutout");
        this.fenceItem(BlockRegistration.FLOWERING_WILLOW_FENCE, BlockRegistration.FLOWERING_WILLOW_PLANKS);
        this.buttonItem(BlockRegistration.FLOWERING_WILLOW_BUTTON, BlockRegistration.FLOWERING_WILLOW_PLANKS);
        this.simplePaneBlockItem(BlockRegistration.FLOWERING_WILLOW_WINDOW_PANE).renderType("cutout");
        this.simpleBlockItem(BlockRegistration.FLOWERING_WILLOW_DOOR);
        this.fenceItem(BlockRegistration.POPLAR_FENCE, BlockRegistration.POPLAR_PLANKS);
        this.buttonItem(BlockRegistration.POPLAR_BUTTON, BlockRegistration.POPLAR_PLANKS);
        this.simpleBlockItem(BlockRegistration.POPLAR_DOOR).renderType("translucent");
        this.simplePaneBlockItem(BlockRegistration.POPLAR_WINDOW_PANE).renderType("translucent");
        this.simplePaneBlockItem(BlockRegistration.POPLAR_SAPLING).renderType("cutout");
        this.fenceItem(BlockRegistration.FLOWERING_POPLAR_FENCE, BlockRegistration.FLOWERING_POPLAR_PLANKS);
        this.buttonItem(BlockRegistration.FLOWERING_POPLAR_BUTTON, BlockRegistration.FLOWERING_POPLAR_PLANKS);
        this.simpleBlockItem(BlockRegistration.FLOWERING_POPLAR_DOOR).renderType("translucent");
        this.simplePaneBlockItem(BlockRegistration.FLOWERING_POPLAR_WINDOW_PANE).renderType("translucent");
        this.fenceItem(BlockRegistration.CRABAPPLE_FENCE, BlockRegistration.CRABAPPLE_PLANKS);
        this.buttonItem(BlockRegistration.CRABAPPLE_BUTTON, BlockRegistration.CRABAPPLE_PLANKS);
        this.simpleBlockItem(BlockRegistration.CRABAPPLE_DOOR).renderType("cutout");
        this.simplePaneBlockItem(BlockRegistration.CRABAPPLE_WINDOW_PANE).renderType("cutout");
        this.simplePaneBlockItem(BlockRegistration.CRABAPPLE_SAPLING).renderType("cutout");
        this.fenceItem(BlockRegistration.FLOWERING_CRABAPPLE_FENCE, BlockRegistration.FLOWERING_CRABAPPLE_PLANKS);
        this.buttonItem(BlockRegistration.FLOWERING_CRABAPPLE_BUTTON, BlockRegistration.FLOWERING_CRABAPPLE_PLANKS);
        this.simpleBlockItem(BlockRegistration.FLOWERING_CRABAPPLE_DOOR).renderType("cutout");
        this.simplePaneBlockItem(BlockRegistration.FLOWERING_CRABAPPLE_WINDOW_PANE).renderType("cutout");
        this.standardCubeItem(BlockRegistration.FLOWERING_CRABAPPLE_LEAVES, "flowering_crabapple_leaves_2");
        this.fenceItem(BlockRegistration.SYCAMORE_FENCE, BlockRegistration.SYCAMORE_PLANKS);
        this.buttonItem(BlockRegistration.SYCAMORE_BUTTON, BlockRegistration.SYCAMORE_PLANKS);
        this.simpleBlockItem(BlockRegistration.SYCAMORE_DOOR);
        this.simplePaneBlockItem(BlockRegistration.SYCAMORE_WINDOW_PANE).renderType("cutout");
        this.simplePaneBlockItem(BlockRegistration.SYCAMORE_SAPLING).renderType("cutout");
        this.fenceItem(BlockRegistration.MAPLE_FENCE, BlockRegistration.MAPLE_PLANKS);
        this.buttonItem(BlockRegistration.MAPLE_BUTTON, BlockRegistration.MAPLE_PLANKS);
        this.simpleBlockItem(BlockRegistration.MAPLE_DOOR).renderType("cutout");
        this.simplePaneBlockItem(BlockRegistration.MAPLE_WINDOW_PANE).renderType("cutout");
        this.simplePaneBlockItem(BlockRegistration.MAPLE_SAPLING).renderType("cutout");
        this.standardCubeItem(BlockRegistration.BLUE_MUSHROOM_CAP, "blue_mushroom_cap_4");
        this.fenceItem(BlockRegistration.BLUE_MUSHROOM_FENCE, BlockRegistration.BLUE_MUSHROOM_PLANKS);
        this.buttonItem(BlockRegistration.BLUE_MUSHROOM_BUTTON, BlockRegistration.BLUE_MUSHROOM_PLANKS);
        this.simpleBlockItem(BlockRegistration.BLUE_MUSHROOM_DOOR);
        this.simplePaneBlockItem(BlockRegistration.BLUE_MUSHROOM_WINDOW_PANE);
        this.simplePaneBlockItem(BlockRegistration.BLUE_MUSHROOM_SAPLING).renderType("cutout");
        this.standardCubeItem(BlockRegistration.RED_MUSHROOM_CAP, "red_mushroom_cap_4");
        this.fenceItem(BlockRegistration.RED_MUSHROOM_FENCE, BlockRegistration.RED_MUSHROOM_PLANKS);
        this.buttonItem(BlockRegistration.RED_MUSHROOM_BUTTON, BlockRegistration.RED_MUSHROOM_PLANKS);
        this.simpleBlockItem(BlockRegistration.RED_MUSHROOM_DOOR);
        this.simplePaneBlockItem(BlockRegistration.RED_MUSHROOM_WINDOW_PANE);
        this.simplePaneBlockItem(BlockRegistration.RED_MUSHROOM_SAPLING).renderType("cutout");
        this.standardCubeItem(BlockRegistration.EYE_BLOCK, "eye_block_left_0");
        this.basicItem((Item)ItemRegistration.HAND_DRILL.get());
        this.simplePaneBlockItem(BlockRegistration.CHALCEDONY_WINDOW_PANE).renderType("cutout");
        this.simplePaneBlockItem(BlockRegistration.DEEP_CHALCEDONY_WINDOW_PANE).renderType("cutout");
        this.simplePaneBlockItem(BlockRegistration.ALABASTER_WINDOW_PANE, "_divided").renderType("cutout");
        this.simplePaneBlockItem(BlockRegistration.WOOD_WINDOW_PANE, "_divided").renderType("cutout");
        this.simplePaneBlockItem(BlockRegistration.BLACK_CAT_WINDOW_PANE).renderType("cutout");
        this.simpleBlockItem(BlockRegistration.DYNASTY_DOOR);
        this.simpleBlockItem(BlockRegistration.ALABASTER_FRENCH_DOOR).renderType("cutout");
        this.simpleBlockItem(BlockRegistration.ALABASTER_SCREEN_DOOR).renderType("cutout");
        this.simpleBlockItem(BlockRegistration.WOOD_FRENCH_DOOR).renderType("cutout");
        this.simpleBlockItem(BlockRegistration.WOOD_SCREEN_DOOR).renderType("cutout");
        this.simpleBlockItem(BlockRegistration.ART_NOUVEAU_DOOR);
        this.simpleBlockItem(BlockRegistration.ART_NOUVEAU_DOOR_DARK);
        this.balustradeItem(BlockRegistration.MARBLE_BALUSTRADE);
        this.balustradeItem(BlockRegistration.CHALCEDONY_BALUSTRADE);
        this.balustradeItem(BlockRegistration.DEEP_CHALCEDONY_BALUSTRADE);
        this.picketFenceItem(BlockRegistration.MARBLE_PICKET_FENCE);
        this.picketFenceGateItem(BlockRegistration.MARBLE_PICKET_FENCE_GATE);
        this.picketFenceItem(BlockRegistration.CHALCEDONY_PICKET_FENCE);
        this.picketFenceGateItem(BlockRegistration.CHALCEDONY_PICKET_FENCE_GATE);
        this.picketFenceItem(BlockRegistration.DEEP_CHALCEDONY_PICKET_FENCE);
        this.picketFenceGateItem(BlockRegistration.DEEP_CHALCEDONY_PICKET_FENCE_GATE);
        this.picketFenceItem(BlockRegistration.WOODEN_PICKET_FENCE);
        this.picketFenceGateItem(BlockRegistration.WOODEN_PICKET_FENCE_GATE);
        this.bracketItem(BlockRegistration.DEEP_CHALCEDONY_BRACKET_BOW_SCROLL);
        this.bracketItem(BlockRegistration.DEEP_CHALCEDONY_BRACKET_BOW);
        this.bracketItem(BlockRegistration.DEEP_CHALCEDONY_BRACKET_SCROLL);
        this.bracketItem(BlockRegistration.DEEP_CHALCEDONY_BRACKET_STAR);
        this.bracketItem(BlockRegistration.DEEP_CHALCEDONY_BRACKET_VICTORIAN);
        this.bracketItem(BlockRegistration.DEEP_CHALCEDONY_BRACKET_STAR_SCROLL);
        this.bracketItem(BlockRegistration.DEEP_CHALCEDONY_BRACKET_SCROLL_SHELF);
        this.bracketItem(BlockRegistration.CHALCEDONY_BRACKET_BOW_SCROLL);
        this.bracketItem(BlockRegistration.CHALCEDONY_BRACKET_BOW);
        this.bracketItem(BlockRegistration.CHALCEDONY_BRACKET_SCROLL);
        this.bracketItem(BlockRegistration.CHALCEDONY_BRACKET_STAR);
        this.bracketItem(BlockRegistration.CHALCEDONY_BRACKET_VICTORIAN);
        this.bracketItem(BlockRegistration.CHALCEDONY_BRACKET_STAR_SCROLL);
        this.bracketItem(BlockRegistration.CHALCEDONY_BRACKET_SCROLL_SHELF);
        this.bracketItem(BlockRegistration.MARBLE_BRACKET_BOW_SCROLL);
        this.bracketItem(BlockRegistration.MARBLE_BRACKET_BOW);
        this.bracketItem(BlockRegistration.MARBLE_BRACKET_SCROLL);
        this.bracketItem(BlockRegistration.MARBLE_BRACKET_STAR);
        this.bracketItem(BlockRegistration.MARBLE_BRACKET_VICTORIAN);
        this.bracketItem(BlockRegistration.MARBLE_BRACKET_STAR_SCROLL);
        this.bracketItem(BlockRegistration.MARBLE_BRACKET_SCROLL_SHELF);
        this.bracketItem(BlockRegistration.WOODEN_BRACKET_BOW_SCROLL);
        this.bracketItem(BlockRegistration.WOODEN_BRACKET_BOW);
        this.bracketItem(BlockRegistration.WOODEN_BRACKET_SCROLL);
        this.bracketItem(BlockRegistration.WOODEN_BRACKET_STAR);
        this.bracketItem(BlockRegistration.WOODEN_BRACKET_VICTORIAN);
        this.bracketItem(BlockRegistration.WOODEN_BRACKET_STAR_SCROLL);
        this.bracketItem(BlockRegistration.WOODEN_BRACKET_SCROLL_SHELF);
        this.standardCubeItem(BlockRegistration.FISH_WALLPAPER, "fish_wallpaper_1");
        this.standardCubeItem(BlockRegistration.VARYING_BRICKS, "bricks_varying_1");
        this.standardCubeItem(BlockRegistration.VARYING_BRICKS_BORDER, "bricks_varying_bordered_1");
        this.basicItem((Item)ItemRegistration.WILLOW_SIGN.get());
        this.basicItem((Item)ItemRegistration.FLOWERING_WILLOW_SIGN.get());
        this.basicItem((Item)ItemRegistration.POPLAR_SIGN.get());
        this.basicItem((Item)ItemRegistration.FLOWERING_POPLAR_SIGN.get());
        this.basicItem((Item)ItemRegistration.CRABAPPLE_SIGN.get());
        this.basicItem((Item)ItemRegistration.FLOWERING_CRABAPPLE_SIGN.get());
        this.basicItem((Item)ItemRegistration.SYCAMORE_SIGN.get());
        this.basicItem((Item)ItemRegistration.MAPLE_SIGN.get());
        this.basicItem((Item)ItemRegistration.BLUE_MUSHROOM_SIGN.get());
        this.basicItem((Item)ItemRegistration.RED_MUSHROOM_SIGN.get());
        this.basicItem((Item)ItemRegistration.WILLOW_HANGING_SIGN.get());
        this.basicItem((Item)ItemRegistration.FLOWERING_WILLOW_HANGING_SIGN.get());
        this.basicItem((Item)ItemRegistration.POPLAR_HANGING_SIGN.get());
        this.basicItem((Item)ItemRegistration.FLOWERING_POPLAR_HANGING_SIGN.get());
        this.basicItem((Item)ItemRegistration.CRABAPPLE_HANGING_SIGN.get());
        this.basicItem((Item)ItemRegistration.FLOWERING_CRABAPPLE_HANGING_SIGN.get());
        this.basicItem((Item)ItemRegistration.SYCAMORE_HANGING_SIGN.get());
        this.basicItem((Item)ItemRegistration.MAPLE_HANGING_SIGN.get());
        this.basicItem((Item)ItemRegistration.BLUE_MUSHROOM_HANGING_SIGN.get());
        this.basicItem((Item)ItemRegistration.RED_MUSHROOM_HANGING_SIGN.get());
        this.blockitemFromModel(BlockRegistration.APPLE_CHAIR);
        this.blockitemFromModel(BlockRegistration.BIRDHOUSE_UNPAINTED);
        this.blockitemFromModel(BlockRegistration.BIRDHOUSE_RED);
        this.blockitemFromModel(BlockRegistration.BIRDHOUSE_BLUE);
        this.blockitemFromModel(BlockRegistration.BIRDHOUSE_PASTEL);
        this.blockitemFromModel(BlockRegistration.BRIEFCASE_BLANK);
        this.blockitemFromModel(BlockRegistration.BRIEFCASE_ROVER);
        this.blockitemFromModel(BlockRegistration.BOX_OF_PAINTS);
        this.blockitemFromModel(BlockRegistration.BUNNY_BOOK_ENDS);
        this.blockitemFromModel(BlockRegistration.BUTTON_STOOL);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SCALE);
        this.blockitemFromModel(BlockRegistration.ANTIQUE_MAP);
        this.blockitemFromModel(BlockRegistration.ANTIQUE_MINI_TABLE);
        this.blockitemFromModel(BlockRegistration.ANCIENT_CODEX);
        this.blockitemFromModel(BlockRegistration.ANTIQUE_BOOK_STAND);
        this.blockitemFromModel(BlockRegistration.ANTIQUE_LIBRARY_BOOKS);
        this.blockitemFromModel(BlockRegistration.BEE_LAMP);
        this.blockitemFromModel(BlockRegistration.BEE_LAMP_ANGRY);
        this.blockitemFromModel(BlockRegistration.RECORD_PLAYER_WHITE);
        this.blockitemFromModel(BlockRegistration.RECORD_PLAYER_YELLOW);
        this.blockitemFromModel(BlockRegistration.RECORD_PLAYER_RED);
        this.blockitemFromModel(BlockRegistration.RECORD_PLAYER_BROWN);
        this.blockitemFromModel(BlockRegistration.RECORD_PLAYER_PURPLE);
        this.blockitemFromModel(BlockRegistration.RECORD_PLAYER_PINK);
        this.blockitemFromModel(BlockRegistration.RECORD_PLAYER_BLUE);
        this.blockitemFromModel(BlockRegistration.CARDBOARD_BOX);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_BROWN_CABINET);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_BROWN_CABINET_MINI);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_BROWN_CABINET_GLASS);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_BROWN_CABINET_OPEN);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_BROWN_CABINET_INNER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_BROWN_CABINET_OUTER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_BROWN_COUNTER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_BROWN_COUNTER_INNER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_BROWN_COUNTER_OUTER_CORNER_RIGHT);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_BROWN_COUNTER_OUTER_CORNER_LEFT);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_BROWN_COUNTER_SINK);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_LIGHT_GREEN_CABINET);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_LIGHT_GREEN_CABINET_MINI);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_LIGHT_GREEN_CABINET_GLASS);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_LIGHT_GREEN_CABINET_OPEN);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_LIGHT_GREEN_CABINET_INNER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_LIGHT_GREEN_CABINET_OUTER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_LIGHT_GREEN_COUNTER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_LIGHT_GREEN_COUNTER_INNER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_LIGHT_GREEN_COUNTER_OUTER_CORNER_RIGHT);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_LIGHT_GREEN_COUNTER_OUTER_CORNER_LEFT);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_LIGHT_GREEN_COUNTER_SINK);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PINK_CABINET);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PINK_CABINET_MINI);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PINK_CABINET_GLASS);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PINK_CABINET_OPEN);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PINK_CABINET_INNER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PINK_CABINET_OUTER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PINK_COUNTER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PINK_COUNTER_INNER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PINK_COUNTER_OUTER_CORNER_RIGHT);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PINK_COUNTER_OUTER_CORNER_LEFT);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PINK_COUNTER_SINK);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PURPLE_CABINET);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PURPLE_CABINET_MINI);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PURPLE_CABINET_GLASS);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PURPLE_CABINET_OPEN);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PURPLE_CABINET_INNER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PURPLE_CABINET_OUTER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PURPLE_COUNTER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PURPLE_COUNTER_INNER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PURPLE_COUNTER_OUTER_CORNER_RIGHT);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PURPLE_COUNTER_OUTER_CORNER_LEFT);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_PURPLE_COUNTER_SINK);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_WHITE_CABINET);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_WHITE_CABINET_MINI);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_WHITE_CABINET_GLASS);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_WHITE_CABINET_OPEN);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_WHITE_CABINET_INNER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_WHITE_CABINET_OUTER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_WHITE_COUNTER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_WHITE_COUNTER_INNER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_WHITE_COUNTER_OUTER_CORNER_RIGHT);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_WHITE_COUNTER_OUTER_CORNER_LEFT);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_WHITE_COUNTER_SINK);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_YELLOW_CABINET);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_YELLOW_CABINET_MINI);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_YELLOW_CABINET_GLASS);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_YELLOW_CABINET_OPEN);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_YELLOW_CABINET_INNER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_YELLOW_CABINET_OUTER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_YELLOW_COUNTER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_YELLOW_COUNTER_INNER_CORNER);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_YELLOW_COUNTER_OUTER_CORNER_RIGHT);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_YELLOW_COUNTER_OUTER_CORNER_LEFT);
        this.blockitemFromModel(BlockRegistration.KITCHEN_SET_YELLOW_COUNTER_SINK);
        this.blockitemFromModel(BlockRegistration.BIKE_YELLOW);
        this.blockitemFromModel(BlockRegistration.BIKE_YELLOW_FLOWERS);
        this.blockitemFromModel(BlockRegistration.BIKE_BLUE);
        this.blockitemFromModel(BlockRegistration.BIKE_BLUE_FLOWERS);
        this.blockitemFromModel(BlockRegistration.BIKE_PURPLE);
        this.blockitemFromModel(BlockRegistration.BIKE_PURPLE_FLOWERS);
        this.blockitemFromModel(BlockRegistration.BIKE_PINK);
        this.blockitemFromModel(BlockRegistration.BIKE_PINK_FLOWERS);
        this.blockitemFromModel(BlockRegistration.CAT_MUGS_CLUTTERED);
        this.blockitemFromModel(BlockRegistration.CAT_PLANT_POT_BLACK);
        this.blockitemFromModel(BlockRegistration.CAT_PLANT_POT_ORANGE);
        this.blockitemFromModel(BlockRegistration.COFFEE_GRINDER);
        this.simplePaneBlockItem(BlockRegistration.CAULDRON_POSTER);
        this.blockitemFromModel(BlockRegistration.COTTAGE_SIDE_TABLE);
        this.blockitemFromModel(BlockRegistration.ENDTABLE_AMETHYST);
        this.blockitemFromModel(BlockRegistration.ENDTABLE_BUBBLEGUM);
        this.blockitemFromModel(BlockRegistration.ENDTABLE_CHARCOAL);
        this.blockitemFromModel(BlockRegistration.ENDTABLE_MEADOW);
        this.blockitemFromModel(BlockRegistration.ENDTABLE_PERIWINKLE);
        this.blockitemFromModel(BlockRegistration.ENDTABLE_SUNSHINE);
        this.blockitemFromModel(BlockRegistration.ENDTABLE_WOOD);
        this.blockitemFromModel(BlockRegistration.NIGHTSTAND_GREEN);
        this.blockitemFromModel(BlockRegistration.ENDTABLE_DECOR);
        this.blockitemFromModel(BlockRegistration.RED_MUSHROOM_TABLE);
        this.blockitemFromModel(BlockRegistration.RED_MUSHROOM_LAMP);
        this.blockitemFromModel(BlockRegistration.RED_MUSHROOM_WARDROBE);
        this.blockitemFromModel(BlockRegistration.RED_MUSHROOM_BED);
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)BlockRegistration.RED_MUSHROOM_TV.get())).m_135815_(), new ResourceLocation("cluttered", "block/red_mushroom_tv_0"));
        this.blockitemFromModel(BlockRegistration.BLUE_MUSHROOM_TABLE);
        this.blockitemFromModel(BlockRegistration.BLUE_MUSHROOM_LAMP);
        this.blockitemFromModel(BlockRegistration.BLUE_MUSHROOM_WARDROBE);
        this.blockitemFromModel(BlockRegistration.BLUE_MUSHROOM_BED);
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)BlockRegistration.BLUE_MUSHROOM_TV.get())).m_135815_(), new ResourceLocation("cluttered", "block/blue_mushroom_tv_0"));
        this.blockitemFromModel(BlockRegistration.COTTAGE_CHAIR);
        this.blockitemFromModel(BlockRegistration.COTTAGE_ARMCHAIR);
        this.blockitemFromModel(BlockRegistration.COTTAGE_CHAIR_CUSHIONED);
        this.blockitemFromModel(BlockRegistration.COTTAGE_OTTOMAN);
        this.blockitemFromModel(BlockRegistration.MADONNA_OTTOMAN);
        this.blockitemFromModel(BlockRegistration.GLOWSHROOM_TERRARIUM_YELLOW);
        this.blockitemFromModel(BlockRegistration.GLOWSHROOM_TERRARIUM_GREEN);
        this.blockitemFromModel(BlockRegistration.GLOWSHROOM_TERRARIUM_BLUE);
        this.blockitemFromModel(BlockRegistration.GLOWSHROOM_TERRARIUM_PURPLE);
        this.blockitemFromModel(BlockRegistration.GLOWSHROOM_TERRARIUM_PINK);
        this.blockitemFromModel(BlockRegistration.MUSHROOM_TERRARIUM_RED);
        this.blockitemFromModel(BlockRegistration.MUSHROOM_TERRARIUM_BROWN);
        this.blockitemFromModel(BlockRegistration.GUMBALL_MACHINE_RED);
        this.blockitemFromModel(BlockRegistration.GUMBALL_MACHINE_BLUE);
        this.blockitemFromModel(BlockRegistration.GUMBALL_MACHINE_PURPLE);
        this.blockitemFromModel(BlockRegistration.MINI_CACTUS_SET);
        this.blockitemFromModel(BlockRegistration.MUSHROOM_JARS);
        this.blockitemFromModel(BlockRegistration.NEWSPAPER_PILE_SHORT);
        this.blockitemFromModel(BlockRegistration.NEWSPAPER_PILE_TALL);
        this.blockitemFromModel(BlockRegistration.PAPER_PILE);
        this.blockitemFromModel(BlockRegistration.FENCE_SHELF);
        this.blockitemFromModel(BlockRegistration.HANGING_PLANT_POT_FLOWERS);
        this.blockitemFromModel(BlockRegistration.HANGING_PLANT_POT_GRASS);
        this.blockitemFromModel(BlockRegistration.PEDESTAL_HK);
        this.blockitemFromModel(BlockRegistration.PICNIC_BASKET);
        this.blockitemFromModel(BlockRegistration.PICNIC_BASKET_PREPARED);
        this.blockitemFromModel(BlockRegistration.BASKET_OF_PRODUCE);
        this.blockitemFromModel(BlockRegistration.BASKET_OF_FLOWERS);
        this.blockitemFromModel(BlockRegistration.ROVER_STOOL);
        this.blockitemFromModel(BlockRegistration.RUBIKS_CUBE);
        this.blockitemFromModel(BlockRegistration.RUBIKS_CUBE_PASTEL);
        this.blockitemFromModel(BlockRegistration.ROW_OF_SMALL_BOOKS);
        this.blockitemFromModel(BlockRegistration.ROW_OF_SMALL_BOOKS_PASTEL);
        this.blockitemFromModel(BlockRegistration.SCATTERED_PAPERS);
        this.blockitemFromModel(BlockRegistration.SEWING_MACHINE_ANTIQUE);
        this.blockitemFromModel(BlockRegistration.ROW_OF_SMALL_BOOKS_SHELVED);
        this.blockitemFromModel(BlockRegistration.ROW_OF_SMALL_BOOKS_PASTEL_SHELVED);
        this.blockitemFromModel(BlockRegistration.STAINED_GLASS_LAMP);
        this.blockitemFromModel(BlockRegistration.SMALL_BUSH);
        this.blockitemFromModel(BlockRegistration.TEDDY_BEAR);
        this.blockitemFromModel(BlockRegistration.SMALL_SHELF);
        this.blockitemFromModel(BlockRegistration.SMALL_SHELF_PINK);
        this.blockitemFromModel(BlockRegistration.TWO_FLOWER_POTS);
        this.blockitemFromModel(BlockRegistration.TRADITIONAL_RADIO);
        this.blockitemFromModel(BlockRegistration.SEWING_MANNEQUIN);
        this.blockitemFromModel(BlockRegistration.OSSON_PENDANT_BLACK);
        this.blockitemFromModel(BlockRegistration.OSSON_PENDANT_BROWN);
        this.blockitemFromModel(BlockRegistration.OSSON_PENDANT_ORANGE);
        this.blockitemFromModel(BlockRegistration.OSSON_PENDANT_RACING_GREEN);
        this.blockitemFromModel(BlockRegistration.OSSON_PENDANT_SAGE_GREEN);
        this.blockitemFromModel(BlockRegistration.OSSON_PENDANT_RED);
        this.blockitemFromModel(BlockRegistration.OSSON_PENDANT_YELLOW);
        this.blockitemFromModel(BlockRegistration.OSSON_PENDANT_WHITE);
        this.simplePaneBlockItem(BlockRegistration.STARS_PENDANT);
        this.simplePaneBlockItem(BlockRegistration.MOON_PENDANT);
        this.simplePaneBlockItem(BlockRegistration.MOON_DECORATION);
        this.blockitemFromModel(BlockRegistration.POLAROIDS_A);
        this.blockitemFromModel(BlockRegistration.CAGED_BULB);
        this.blockitemFromModel(BlockRegistration.COLOSSEO_WALL_LANTERN);
        this.blockitemFromModel(BlockRegistration.MINI_FLAG_BI);
        this.blockitemFromModel(BlockRegistration.MINI_FLAG_LESBIAN);
        this.blockitemFromModel(BlockRegistration.MINI_FLAG_TRANS);
        this.blockitemFromModel(BlockRegistration.MINI_FLAG_NONBINARY);
        this.blockitemFromModel(BlockRegistration.MINI_FLAG_PAN);
        this.blockitemFromModel(BlockRegistration.MINI_FLAG_RAINBOW);
        this.blockitemFromModel(BlockRegistration.MINI_FLAG_ACE);
        this.blockitemFromModel(BlockRegistration.COTTAGE_BOOKCASE);
        this.blockitemFromModel(BlockRegistration.COTTAGE_STANDING_LAMP);
        this.blockitemFromModel(BlockRegistration.DRYING_HERBS);
        this.blockitemFromModel(BlockRegistration.HANGING_CLOTH);
        this.blockitemFromModel(BlockRegistration.HEART_CAKE);
        this.blockitemFromModel(BlockRegistration.BERRY_CAKE);
        this.garlandItem(BlockRegistration.BLACK_CAT_GARLAND);
        this.garlandItem(BlockRegistration.BLOSSOM_GARLAND);
        this.garlandItem(BlockRegistration.BUNNY_GARLAND);
        this.garlandItem(BlockRegistration.POLAROID_A_GARLAND);
        this.garlandItem(BlockRegistration.POLAROID_B_GARLAND);
        this.garlandItem(BlockRegistration.SUNFLOWER_GARLAND);
        this.garlandItem(BlockRegistration.STARRY_GARLAND);
        this.blockitemFromModel(BlockRegistration.BLACK_CAT_COUNTER_DRAWERS);
        this.blockitemFromModel(BlockRegistration.BLACK_CAT_COUNTER_LEFT_DOOR);
        this.blockitemFromModel(BlockRegistration.BLACK_CAT_COUNTER_RIGHT_DOOR);
        this.blockitemFromModel(BlockRegistration.SWEETHEART_COUNTER_DRAWERS);
        this.blockitemFromModel(BlockRegistration.SWEETHEART_COUNTER_LEFT_DOOR);
        this.blockitemFromModel(BlockRegistration.SWEETHEART_COUNTER_RIGHT_DOOR);
        this.blockitemFromModel(BlockRegistration.BOOK_OPEN);
        this.blockitemFromModel(BlockRegistration.BRASS_KEY);
        this.blockitemFromModel(BlockRegistration.ENVELOPE_STACK);
        this.blockitemFromModel(BlockRegistration.FLOWER_DESK_LAMP);
        this.blockitemFromModel(BlockRegistration.FLOWER_SHELF_BLUE);
        this.blockitemFromModel(BlockRegistration.FLOWER_SHELF_GREEN);
        this.blockitemFromModel(BlockRegistration.FLOWER_SHELF_PINK);
        this.blockitemFromModel(BlockRegistration.FLOWER_SHELF_PURPLE);
        this.blockitemFromModel(BlockRegistration.FLOWER_SHELF_PASTEL_YELLOW);
        this.blockitemFromModel(BlockRegistration.FLOWER_SHELF_YELLOW);
        this.blockitemFromModel(BlockRegistration.FLOWER_SHELF_CANDLE_BLUE);
        this.blockitemFromModel(BlockRegistration.FLOWER_SHELF_CANDLE_GREEN);
        this.blockitemFromModel(BlockRegistration.FLOWER_SHELF_CANDLE_PINK);
        this.blockitemFromModel(BlockRegistration.FLOWER_SHELF_CANDLE_PURPLE);
        this.blockitemFromModel(BlockRegistration.FLOWER_SHELF_CANDLE_PASTEL_YELLOW);
        this.blockitemFromModel(BlockRegistration.FLOWER_SHELF_CANDLE_YELLOW);
        this.blockitemFromModel(BlockRegistration.FLOWER_SHELF_PLANT);
        this.blockitemFromModel(BlockRegistration.FLOWER_TEA_KETTLE);
        this.blockitemFromModel(BlockRegistration.FWISH_ARMCHAIR);
        this.blockitemFromModel(BlockRegistration.FWISH_OTTOMAN);
        this.blockitemFromModel(BlockRegistration.HEAVENLY_ORNAMENTAL_ARRAY);
        this.blockitemFromModel(BlockRegistration.PLANT_LADDER);
        this.blockitemFromModel(BlockRegistration.POLAROID_CAMERA);
        this.blockitemFromModel(BlockRegistration.POLAROIDS_B);
        this.blockitemFromModel(BlockRegistration.POLAROIDS_C);
        this.blockitemFromModel(BlockRegistration.PUZZLE_PIECE_TABLE_BLUE);
        this.blockitemFromModel(BlockRegistration.PUZZLE_PIECE_TABLE_GREEN);
        this.blockitemFromModel(BlockRegistration.PUZZLE_PIECE_TABLE_RED);
        this.blockitemFromModel(BlockRegistration.PUZZLE_PIECE_TABLE_YELLOW);
        this.blockitemFromModel(BlockRegistration.PUZZLE_PIECE_TABLE_PASTEL_BLUE);
        this.blockitemFromModel(BlockRegistration.PUZZLE_PIECE_TABLE_PASTEL_PINK);
        this.blockitemFromModel(BlockRegistration.PUZZLE_PIECE_TABLE_PASTEL_PURPLE);
        this.blockitemFromModel(BlockRegistration.PUZZLE_PIECE_TABLE_PASTEL_YELLOW);
        this.blockitemFromModel(BlockRegistration.SALT_PEPPER_SHAKERS);
        this.blockitemFromModel(BlockRegistration.SAND_SEAL_PLUSH_BLUE);
        this.blockitemFromModel(BlockRegistration.SAND_SEAL_PLUSH_GREEN);
        this.blockitemFromModel(BlockRegistration.SAND_SEAL_PLUSH_RED);
        this.blockitemFromModel(BlockRegistration.SKETCHBOOK_SINGLE);
        this.blockitemFromModel(BlockRegistration.STACK_OF_BOOKS);
        this.blockitemFromModel(BlockRegistration.STACK_OF_BOOKS_TALL);
        this.blockitemFromModel(BlockRegistration.STEAMPUNK_GLOBE);
        this.blockitemFromModel(BlockRegistration.WINE_BOTTLE_RACK);
        this.blockitemFromModel(BlockRegistration.WINE_BOTTLES);
        this.blockitemFromModel(BlockRegistration.YELLOW_NOTEPAD);
        this.blockitemFromModel(BlockRegistration.SWEETHEART_BAKING_SET_BOWL);
        this.blockitemFromModel(BlockRegistration.SWEETHEART_BAKING_SET_INGREDIENTS);
        this.blockitemFromModel(BlockRegistration.SWEETHEART_SINK);
        this.blockitemFromModel(BlockRegistration.SWEETHEART_TABLE);
        this.blockitemFromModel(BlockRegistration.BLACK_CAT_SINK);
        this.blockitemFromModel(BlockRegistration.BLACK_CAT_TABLE);
        this.blockitemFromModel(BlockRegistration.CARD_INDEX);
        this.blockitemFromModel(BlockRegistration.CHINA_CABINET);
        this.blockitemFromModel(BlockRegistration.CUPID_BENCH);
        this.blockitemFromModel(BlockRegistration.GENERAL_STORE_CABINET);
        this.blockitemFromModel(BlockRegistration.RETRO_FRIDGE_BLACK);
        this.blockitemFromModel(BlockRegistration.RETRO_FRIDGE_BLUE);
        this.blockitemFromModel(BlockRegistration.RETRO_FRIDGE_PINK);
        this.blockitemFromModel(BlockRegistration.RETRO_FRIDGE_PURPLE);
        this.blockitemFromModel(BlockRegistration.RETRO_FRIDGE_RED);
        this.blockitemFromModel(BlockRegistration.RETRO_FRIDGE_TURQUOISE);
        this.blockitemFromModel(BlockRegistration.RETRO_FRIDGE_WHITE);
        this.blockitemFromModel(BlockRegistration.RETRO_FRIDGE_YELLOW);
        this.blockitemFromModel(BlockRegistration.FABRIC_BOLTS);
        this.blockitemFromModel(BlockRegistration.SCISSORS_AND_THREAD);
        this.blockitemFromModel(BlockRegistration.SLICED_BREAD);
        this.blockitemFromModel(BlockRegistration.ROSE_END_TABLE);
        this.blockitemFromModel(BlockRegistration.ROSE_END_TABLE_BLACK);
        this.blockitemFromModel(BlockRegistration.VIAL_STAND);
        this.blockitemFromModel(BlockRegistration.PINEAPPLE);
        this.blockitemFromModel(BlockRegistration.MUSHROOM_FLAT);
        this.blockitemFromModel(BlockRegistration.HONEYCOMB_LAMP);
        this.blockitemFromModel(BlockRegistration.UNLIVING_CHAIR);
        this.blockitemFromModel(BlockRegistration.CONFECTIONERY_TABLE_BLUE);
        this.blockitemFromModel(BlockRegistration.CONFECTIONERY_TABLE_PINK);
        this.blockitemFromModel(BlockRegistration.SAFE_NOVAKID);
        this.blockitemFromModel(BlockRegistration.VIOLET_SCREEN);
        this.blockitemFromModel(BlockRegistration.HOPPIN_PARK_LANTERN);
        this.blockitemFromModel(BlockRegistration.SEA_GEM_LANTERN);
        this.blockitemFromModel(BlockRegistration.HANGING_SHELVES_PLANTS);
        this.blockitemFromModel(BlockRegistration.HANGING_SHELVES_POTTERY);
        this.blockitemFromModel(BlockRegistration.POK_TA_POK_HOOP);
        this.blockitemFromModel(BlockRegistration.POK_TA_POK_HOOP_SNAKES);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_BED_GEOMETRIC);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_BED_QUILTED);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_BED_SOUTHERN_FLAIR);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_CHAIR_GEOMETRIC);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_CHAIR_QUILTED);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_CHAIR_SOUTHERN_FLAIR);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_SOFA_GEOMETRIC);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_SOFA_QUILTED);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_SOFA_SOUTHERN_FLAIR);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_DECORATIVE_SHELVES_GEOMETRIC);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_DECORATIVE_SHELVES_QUILTED);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_DECORATIVE_SHELVES_SOUTHERN_FLAIR);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_CABINET);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_TABLE);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_STOOL);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_CLOCK);
        this.blockitemFromModel(BlockRegistration.DARKWOOD_ENDTABLE);
        this.blockitemFromModel(BlockRegistration.WATERING_CAN);
        this.blockitemFromModel(BlockRegistration.WATERING_CAN_COPPER);
        this.blockitemFromModel(BlockRegistration.RETRO_TOASTER_BLACK);
        this.blockitemFromModel(BlockRegistration.RETRO_TOASTER_BLUE);
        this.blockitemFromModel(BlockRegistration.RETRO_TOASTER_PINK);
        this.blockitemFromModel(BlockRegistration.RETRO_TOASTER_PURPLE);
        this.blockitemFromModel(BlockRegistration.RETRO_TOASTER_TURQUOISE);
        this.blockitemFromModel(BlockRegistration.RETRO_TOASTER_RED);
        this.blockitemFromModel(BlockRegistration.RETRO_TOASTER_WHITE);
        this.blockitemFromModel(BlockRegistration.RETRO_TOASTER_YELLOW);
        this.blockitemFromModel(BlockRegistration.POTION_SHELF);
        this.blockitemFromModel(BlockRegistration.DORADO_CABINET);
        this.blockitemFromModel(BlockRegistration.DORADO_CABINET_CLUTTERED);
        this.blockitemFromModel(BlockRegistration.HAVANA_CABINET);
        this.blockitemFromModel(BlockRegistration.HAVANA_CABINET_CLUTTERED);
        this.blockitemFromModel(BlockRegistration.MUREX_CABINET);
        this.blockitemFromModel(BlockRegistration.MUREX_CABINET_CLUTTERED);
        this.blockitemFromModel(BlockRegistration.ANIMATED_FLAG_ASEXUAL);
        this.blockitemFromModel(BlockRegistration.ANIMATED_FLAG_BISEXUAL);
        this.blockitemFromModel(BlockRegistration.ANIMATED_FLAG_PANSEXUAL);
        this.blockitemFromModel(BlockRegistration.ANIMATED_FLAG_LESBIAN);
        this.blockitemFromModel(BlockRegistration.ANIMATED_FLAG_TRANSGENDER);
        this.blockitemFromModel(BlockRegistration.ANIMATED_FLAG_NONBINARY);
        this.blockitemFromModel(BlockRegistration.ANIMATED_FLAG_RAINBOW);
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)BlockRegistration.JAM_JARS.get())).m_135815_(), new ResourceLocation("cluttered", "block/jam_jar_pyramid_assorted_a"));
        this.blockitemFromModel(BlockRegistration.DESK_BROWN);
        this.blockitemFromModel(BlockRegistration.DESK_BROWN_CLUTTERED);
        this.blockitemFromModel(BlockRegistration.DESK_GREEN);
        this.blockitemFromModel(BlockRegistration.DESK_GREEN_CLUTTERED);
        this.blockitemFromModel(BlockRegistration.ANTIQUE_STANDING_LAMP);
        this.blockitemFromModel(BlockRegistration.LOVELY_LOVE_SEAT);
        this.blockitemFromModel(BlockRegistration.LOVELY_LOVE_SEAT_BLACK);
        this.blockitemFromModel(BlockRegistration.BULLETIN_BOARD);
        this.blockitemFromModel(BlockRegistration.BULLETIN_BOARD_CLUTTERED);
        this.blockitemFromModel(BlockRegistration.BAMBOO_BOOKSHELF);
        this.blockitemFromModel(BlockRegistration.FWISH_BOOKCASE);
        this.blockitemFromModel(BlockRegistration.RETRO_CAFE_SHELF);
        this.blockitemFromModel(BlockRegistration.RETRO_CAFE_SHELF_WINDOW);
        this.blockitemFromModel(BlockRegistration.CHINA_CABINET);
        this.blockitemFromModel(BlockRegistration.CUPID_BENCH);
        this.blockitemFromModel(BlockRegistration.TABLE_PLAIN);
        this.blockitemFromModel(BlockRegistration.TABLE_TABLECLOTH);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_WHITE);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_LIGHT_GRAY);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_GRAY);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_BLACK);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_BROWN);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_RED);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_ORANGE);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_YELLOW);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_LIME);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_GREEN);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_CYAN);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_LIGHT_BLUE);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_BLUE);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_PURPLE);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_MAGENTA);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_PINK);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_FUCHSIA);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_IVORY);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_FLOWER);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_STRAWBERRY);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_HEART);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_WATERMELON);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_LEMON);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_STARRY);
        this.blockitemFromModel(BlockRegistration.ARMCHAIR_BLACK_CAT);
        this.blockitemFromModel(BlockRegistration.SEWING_TABLE);
        this.blockitemFromModel(BlockRegistration.IMPERIAL_TABLE);
        this.blockitemFromModel(BlockRegistration.LUNAR_OBSERVATORY_TABLE);
        this.blockitemFromModel(BlockRegistration.SEWING_CLUTTER);
        this.blockitemFromModel(BlockRegistration.IMPERIAL_CHAIR);
        this.blockitemFromModel(BlockRegistration.PASTRY_DISPLAY_CASE);
        this.blockitemFromModel(BlockRegistration.GLASS_FLOWER_VASE);
        this.blockitemFromModel(BlockRegistration.LUNAR_OBSERVATORY_PAPER_BASKET);
        this.blockitemFromModel(BlockRegistration.LUNAR_OBSERVATORY_BOOKS);
        this.blockitemFromModel(BlockRegistration.LUNAR_OBSERVATORY_GLOBE);
        this.blockitemFromModel(BlockRegistration.LUNAR_OBSERVATORY_PEDESTAL);
        this.blockitemFromModel(BlockRegistration.MERMAID_PEARL);
        this.blockitemFromModel(BlockRegistration.PAINT_WATER_JAR);
        this.blockitemFromModel(BlockRegistration.PASTRY_PLATE);
        this.blockitemFromModel(BlockRegistration.CHOCOLATE_CROISSANT);
        this.blockitemFromModel(BlockRegistration.BLUEBERRY_MUFFIN);
        this.blockitemFromModel(BlockRegistration.CINNAMON_BUN);
        this.blockitemFromModel(BlockRegistration.CROISSANT);
        this.blockitemFromModel(BlockRegistration.HAM_SANDWICH);
        this.blockitemFromModel(BlockRegistration.PANCAKE_STACK);
        this.blockitemFromModel(BlockRegistration.ASSORTED_GLASS_JARS);
        this.blockitemFromModel(BlockRegistration.SMALL_GLASS_JARS);
        this.blockitemFromModel(BlockRegistration.ASSORTED_SPICE_JARS);
        this.blockitemFromModel(BlockRegistration.FILING_BOX);
        this.blockitemFromModel(BlockRegistration.LEMON_TABLE);
        this.blockitemFromModel(BlockRegistration.MERMAID_DRESSER);
        this.blockitemFromModel(BlockRegistration.PASTEL_CABINET);
        this.blockitemFromModel(BlockRegistration.WOODEN_BLOCK_BOOKSHELF_PASTEL);
        this.blockitemFromModel(BlockRegistration.PASTEL_CHAIR);
        this.blockitemFromModel(BlockRegistration.PASTEL_STOOL);
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)BlockRegistration.PASTEL_LIGHT.get())).m_135815_(), new ResourceLocation("cluttered", "block/pastel_light_wall"));
        this.blockitemFromModel(BlockRegistration.PASTEL_BED);
        this.blockitemFromModel(BlockRegistration.PASTEL_TABLE);
        this.blockitemFromModel(BlockRegistration.PASTEL_WARDROBE);
        this.blockitemFromModel(BlockRegistration.PASTEL_PLUSH);
        this.blockitemFromModel(BlockRegistration.MINI_HANGING_TERRARIUMS);
        this.blockitemFromModel(BlockRegistration.OFFICE_SUPPLIES_A);
        this.blockitemFromModel(BlockRegistration.OFFICE_SUPPLIES_B);
        this.blockitemFromModel(BlockRegistration.RITO_BOOKS);
        this.blockitemFromModel(BlockRegistration.ROVER_MUG);
        this.blockitemFromModel(BlockRegistration.SELTZER_CANS);
        this.blockitemFromModel(BlockRegistration.SMALL_BOOKCASE);
        this.blockitemFromModel(BlockRegistration.SMALL_CAULDRON);
        this.blockitemFromModel(BlockRegistration.STEAMPUNK_LAMP);
        this.blockitemFromModel(BlockRegistration.TARRY_TOWN_STOVE);
        this.blockitemFromModel(BlockRegistration.WEDDING_ARCH);
        this.blockitemFromModel(BlockRegistration.SEAWEED_PLANTER);
        this.simplePaneBlockItem(BlockRegistration.FLOWERING_CARPET_WILLOW);
        this.simplePaneBlockItem(BlockRegistration.FLOWERING_CARPET_CRABAPPLE);
        this.simplePaneBlockItem(BlockRegistration.FLOWERING_CARPET_POPLAR);
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)BlockRegistration.LUNAR_OBSERVATORY_JARS.get())).m_135815_(), new ResourceLocation("cluttered", "block/lunar_observatory_jars_1"));
    }

    public void fenceItem(RegistryObject<Block> block, RegistryObject<Block> base) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/fence_inventory"))).texture("texture", new ResourceLocation("cluttered", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)base.get())).m_135815_()));
    }

    public void balustradeItem(RegistryObject<Block> block) {
        String id = block.getId().toString().replace("cluttered:", "");
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/balustrade"))).texture("2", this.modLoc("block/" + id));
    }

    public void bracketItem(RegistryObject<Block> block) {
        String id = block.getId().toString().replace("cluttered:", "");
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/bracket_base"))).texture("missing", this.modLoc("block/" + id));
    }

    public void picketFenceItem(RegistryObject<Block> block) {
        String id = block.getId().toString().replace("cluttered:", "");
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/picket_fence"))).texture("2", this.modLoc("block/" + id));
    }

    public void picketFenceGateItem(RegistryObject<Block> block) {
        String id = block.getId().toString().replace("cluttered:", "");
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/picket_fence_gate_closed"))).texture("1", this.modLoc("block/" + id));
    }

    public void standardCubeItem(RegistryObject<Block> block, String texture) {
        this.cubeAll(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + texture));
    }

    public void buttonItem(RegistryObject<Block> block, RegistryObject<Block> base) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/button_inventory"))).texture("texture", new ResourceLocation("cluttered", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)base.get())).m_135815_()));
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("cluttered", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder simplePaneBlockItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("cluttered", "block/" + item.getId().m_135815_().replace("_pane", "")));
    }

    private ItemModelBuilder simplePaneBlockItem(RegistryObject<Block> item, String end) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("cluttered", "block/" + item.getId().m_135815_().replace("_pane", "") + end));
    }

    private ItemModelBuilder blockitemFromModel(RegistryObject<Block> item) {
        String model = item.getId().toString().replace("cluttered:", "");
        return (ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)item.get())).m_135815_(), new ResourceLocation("cluttered", "block/" + model));
    }

    private ItemModelBuilder garlandItem(RegistryObject<Block> item) {
        String model = item.getId().toString().replace("cluttered:", "");
        return (ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)item.get())).m_135815_(), new ResourceLocation("cluttered", "block/" + model + "_right"));
    }
}

