/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.entity.crab;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.world.item.DyeColor;

public enum CrabVariant {
    BLACK(0),
    BLUE(1),
    BROWN(2),
    CYAN(3),
    GRAY(4),
    GREEN(5),
    LIGHT_BLUE(6),
    LIGHT_GRAY(7),
    LIME(8),
    MAGENTA(9),
    ORANGE(10),
    PINK(11),
    PURPLE(12),
    RED(13),
    WHITE(14),
    YELLOW(15);

    private static final CrabVariant[] BY_ID;
    private final int id;

    private CrabVariant(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static CrabVariant byId(int id) {
        return BY_ID[id % BY_ID.length];
    }

    public static CrabVariant fromDyeColor(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.BLACK -> BLACK;
            case DyeColor.BLUE -> BLUE;
            case DyeColor.BROWN -> BROWN;
            case DyeColor.CYAN -> CYAN;
            case DyeColor.GRAY -> GRAY;
            case DyeColor.GREEN -> GREEN;
            case DyeColor.LIGHT_BLUE -> LIGHT_BLUE;
            case DyeColor.LIGHT_GRAY -> LIGHT_GRAY;
            case DyeColor.LIME -> LIME;
            case DyeColor.MAGENTA -> MAGENTA;
            case DyeColor.ORANGE -> ORANGE;
            case DyeColor.PINK -> PINK;
            case DyeColor.PURPLE -> PURPLE;
            case DyeColor.RED -> RED;
            case DyeColor.WHITE -> WHITE;
            case DyeColor.YELLOW -> YELLOW;
        };
    }

    public DyeColor getDyeColor() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case BLACK -> DyeColor.BLACK;
            case BLUE -> DyeColor.BLUE;
            case BROWN -> DyeColor.BROWN;
            case CYAN -> DyeColor.CYAN;
            case GRAY -> DyeColor.GRAY;
            case GREEN -> DyeColor.GREEN;
            case LIGHT_BLUE -> DyeColor.LIGHT_BLUE;
            case LIGHT_GRAY -> DyeColor.LIGHT_GRAY;
            case LIME -> DyeColor.LIME;
            case MAGENTA -> DyeColor.MAGENTA;
            case ORANGE -> DyeColor.ORANGE;
            case PINK -> DyeColor.PINK;
            case PURPLE -> DyeColor.PURPLE;
            case RED -> DyeColor.RED;
            case WHITE -> DyeColor.WHITE;
            case YELLOW -> DyeColor.YELLOW;
        };
    }

    static {
        BY_ID = (CrabVariant[])Arrays.stream(CrabVariant.values()).sorted(Comparator.comparingInt(CrabVariant::getId)).toArray(CrabVariant[]::new);
    }
}

