/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.item;

import alabaster.crabbersdelight.common.registry.CDModItems;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CoconutHelmetItem
extends Item {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("1e6e6f80-bdf7-4d57-b010-22a9cb3b4f2c");
    private static final ResourceLocation ARMOR_MODIFIER_ID = new ResourceLocation("crabbersdelight", "coconut_helmet_armor");
    private static final double ARMOR_VALUE = 3.0;
    private static final int DAMAGE_INTERVAL_TICKS = 600;
    private static final int EFFECT_DURATION = 10;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public CoconutHelmetItem(Item.Properties properties) {
        super(properties.m_41503_(64));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_MODIFIER_UUID, "Coconut armor", 3.0, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        if (head.m_41619_()) {
            player.m_8061_(EquipmentSlot.HEAD, stack.m_41777_());
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11680_, player.m_5720_(), 1.0f, 1.0f);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repairCandidate) {
        return repairCandidate.m_150930_(CDModItems.COCONUT_HALVE.get());
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.HEAD ? this.defaultModifiers : super.getAttributeModifiers(slot, stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (level.f_46443_) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_6844_(EquipmentSlot.HEAD) != stack) {
            return;
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 10, 0, false, false, true));
        if (level.m_46467_() % 600L == 0L) {
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.HEAD));
        }
    }
}

