/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.api.contraption.dispenser.DefaultMountedDispenseBehavior;
import com.simibubi.create.api.contraption.dispenser.MountedDispenseBehavior;
import com.simibubi.create.api.contraption.dispenser.MountedProjectileDispenseBehavior;
import com.simibubi.create.api.contraption.dispenser.OptionalMountedDispenseBehavior;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AllMountedDispenseItemBehaviors {
    private static final MountedDispenseBehavior SPAWN_EGG = new DefaultMountedDispenseBehavior(){

        @Override
        protected ItemStack execute(ItemStack stack, MovementContext context, BlockPos pos, Vec3 facing) {
            Item item = stack.m_41720_();
            if (!(item instanceof SpawnEggItem)) {
                return super.execute(stack, context, pos, facing);
            }
            SpawnEggItem egg = (SpawnEggItem)item;
            Level level = context.world;
            if (level instanceof ServerLevel) {
                BlockPos offset;
                ServerLevel serverLevel = (ServerLevel)level;
                EntityType type = egg.m_43228_(stack.m_41783_());
                Entity entity = type.m_20592_(serverLevel, stack, null, pos.m_121955_((Vec3i)(offset = BlockPos.m_274561_((double)(facing.f_82479_ + 0.7), (double)(facing.f_82480_ + 0.7), (double)(facing.f_82481_ + 0.7)))), MobSpawnType.DISPENSER, facing.f_82480_ < 0.5, false);
                if (entity != null) {
                    entity.m_20256_(context.motion.m_82490_(2.0));
                }
            }
            stack.m_41774_(1);
            return stack;
        }
    };
    private static final MountedDispenseBehavior TNT = new DefaultMountedDispenseBehavior(){

        @Override
        protected ItemStack execute(ItemStack stack, MovementContext context, BlockPos pos, Vec3 facing) {
            double x = (double)pos.m_123341_() + facing.f_82479_ * 0.7 + 0.5;
            double y = (double)pos.m_123342_() + facing.f_82480_ * 0.7 + 0.5;
            double z = (double)pos.m_123343_() + facing.f_82481_ * 0.7 + 0.5;
            PrimedTnt tnt = new PrimedTnt(context.world, x, y, z, null);
            tnt.m_5997_(context.motion.f_82479_, context.motion.f_82480_, context.motion.f_82481_);
            context.world.m_7967_((Entity)tnt);
            context.world.m_6263_(null, tnt.m_20185_(), tnt.m_20186_(), tnt.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
            stack.m_41774_(1);
            return stack;
        }
    };
    private static final MountedDispenseBehavior FIREWORK = new DefaultMountedDispenseBehavior(){

        @Override
        protected ItemStack execute(ItemStack stack, MovementContext context, BlockPos pos, Vec3 facing) {
            double x = (double)pos.m_123341_() + facing.f_82479_ * 0.7 + 0.5;
            double y = (double)pos.m_123342_() + facing.f_82480_ * 0.7 + 0.5;
            double z = (double)pos.m_123343_() + facing.f_82481_ * 0.7 + 0.5;
            FireworkRocketEntity firework = new FireworkRocketEntity(context.world, stack, x, y, z, true);
            firework.m_6686_(facing.f_82479_, facing.f_82480_, facing.f_82481_, 0.5f, 1.0f);
            context.world.m_7967_((Entity)firework);
            stack.m_41774_(1);
            return stack;
        }

        @Override
        protected void playSound(LevelAccessor level, BlockPos pos) {
            level.m_46796_(1004, pos, 0);
        }
    };
    private static final MountedDispenseBehavior FIRE_CHARGE = new DefaultMountedDispenseBehavior(){

        @Override
        protected ItemStack execute(ItemStack stack, MovementContext context, BlockPos pos, Vec3 facing) {
            RandomSource random = context.world.f_46441_;
            double x = (double)pos.m_123341_() + facing.f_82479_ * 0.7 + 0.5;
            double y = (double)pos.m_123342_() + facing.f_82480_ * 0.7 + 0.5;
            double z = (double)pos.m_123343_() + facing.f_82481_ * 0.7 + 0.5;
            SmallFireball fireball = new SmallFireball(context.world, x, y, z, random.m_188583_() * 0.05 + facing.f_82479_ + context.motion.f_82479_, random.m_188583_() * 0.05 + facing.f_82480_ + context.motion.f_82480_, random.m_188583_() * 0.05 + facing.f_82481_ + context.motion.f_82481_);
            fireball.m_37010_(stack);
            context.world.m_7967_((Entity)fireball);
            stack.m_41774_(1);
            return stack;
        }

        @Override
        protected void playSound(LevelAccessor level, BlockPos pos) {
            level.m_46796_(1018, pos, 0);
        }
    };
    private static final MountedDispenseBehavior BUCKET = new DefaultMountedDispenseBehavior(){

        @Override
        protected ItemStack execute(ItemStack stack, MovementContext context, BlockPos pos, Vec3 facing) {
            BlockPos interactionPos = pos.m_121945_(MountedDispenseBehavior.getClosestFacingDirection(facing));
            BlockState state = context.world.m_8055_(interactionPos);
            Block block = state.m_60734_();
            if (!(block instanceof BucketPickup)) {
                return super.execute(stack, context, pos, facing);
            }
            BucketPickup bucketPickup = (BucketPickup)block;
            ItemStack bucket = bucketPickup.m_142598_((LevelAccessor)context.world, interactionPos, state);
            MountedDispenseBehavior.placeItemInInventory(bucket, context, pos);
            stack.m_41774_(1);
            return stack;
        }
    };
    private static final MountedDispenseBehavior POTIONS = new MountedProjectileDispenseBehavior(){

        @Override
        protected Projectile getProjectile(Level level, double x, double y, double z, ItemStack stack) {
            ThrownPotion potion = new ThrownPotion(level, x, y, z);
            potion.m_37446_(stack);
            return potion;
        }

        @Override
        protected float getUncertainty() {
            return super.getUncertainty() * 0.5f;
        }

        @Override
        protected float getPower() {
            return super.getPower() * 1.25f;
        }
    };
    private static final MountedDispenseBehavior BOTTLE = new OptionalMountedDispenseBehavior(){

        @Override
        @Nullable
        protected ItemStack doExecute(ItemStack stack, MovementContext context, BlockPos pos, Vec3 facing) {
            BlockPos interactionPos = pos.m_121945_(MountedDispenseBehavior.getClosestFacingDirection(facing));
            BlockState state = context.world.m_8055_(interactionPos);
            Block block = state.m_60734_();
            if (block instanceof BeehiveBlock) {
                BeehiveBlock hive = (BeehiveBlock)block;
                if (state.m_204336_(BlockTags.f_13072_) && (Integer)state.m_61143_((Property)BeehiveBlock.f_49564_) >= 5) {
                    hive.m_49594_(context.world, state, interactionPos, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
                    MountedDispenseBehavior.placeItemInInventory(new ItemStack((ItemLike)Items.f_42787_), context, pos);
                    stack.m_41774_(1);
                    return stack;
                }
            }
            if (context.world.m_6425_(interactionPos).m_205070_(FluidTags.f_13131_)) {
                ItemStack waterBottle = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
                MountedDispenseBehavior.placeItemInInventory(waterBottle, context, pos);
                stack.m_41774_(1);
                return stack;
            }
            return null;
        }
    };

    public static void registerDefaults() {
        for (SpawnEggItem egg : SpawnEggItem.m_43233_()) {
            MountedDispenseBehavior.REGISTRY.register((Item)egg, SPAWN_EGG);
        }
        MountedDispenseBehavior.REGISTRY.register(Items.f_41996_, TNT);
        MountedDispenseBehavior.REGISTRY.register(Items.f_42688_, FIREWORK);
        MountedDispenseBehavior.REGISTRY.register(Items.f_42613_, FIRE_CHARGE);
        MountedDispenseBehavior.REGISTRY.register(Items.f_42446_, BUCKET);
        MountedDispenseBehavior.REGISTRY.register(Items.f_42590_, BOTTLE);
        MountedDispenseBehavior.REGISTRY.register(Items.f_42736_, POTIONS);
        MountedDispenseBehavior.REGISTRY.register(Items.f_42739_, POTIONS);
    }
}

