/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.sandPaper;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.sandPaper.SandPaperItemRenderer;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.simibubi.create.foundation.item.CustomUseEffectsItem;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.mixin.accessor.LivingEntityAccessor;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.TriState;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.FakePlayer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SandPaperItem
extends Item
implements CustomUseEffectsItem {
    public SandPaperItem(Item.Properties properties) {
        super(properties.m_41499_(8));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        InteractionResultHolder FAIL = new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        if (itemstack.m_41784_().m_128441_("Polishing")) {
            playerIn.m_6672_(handIn);
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        InteractionHand otherHand = handIn == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack itemInOtherHand = playerIn.m_21120_(otherHand);
        if (SandPaperPolishingRecipe.canPolish(worldIn, itemInOtherHand)) {
            ItemStack item = itemInOtherHand.m_41777_();
            ItemStack toPolish = item.m_41620_(1);
            playerIn.m_6672_(handIn);
            itemstack.m_41784_().m_128365_("Polishing", (Tag)toPolish.serializeNBT());
            playerIn.m_21008_(otherHand, item);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        BlockHitResult raytraceresult = SandPaperItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (!(raytraceresult instanceof BlockHitResult)) {
            return FAIL;
        }
        BlockHitResult ray = raytraceresult;
        Vec3 hitVec = ray.m_82450_();
        AABB bb = new AABB(hitVec, hitVec).m_82400_(1.0);
        ItemEntity pickUp = null;
        for (ItemEntity itemEntity : worldIn.m_45976_(ItemEntity.class, bb)) {
            ItemStack stack;
            if (!itemEntity.m_6084_() || itemEntity.m_20182_().m_82554_(playerIn.m_20182_()) > 3.0 || !SandPaperPolishingRecipe.canPolish(worldIn, stack = itemEntity.m_32055_())) continue;
            pickUp = itemEntity;
            break;
        }
        if (pickUp == null) {
            return FAIL;
        }
        ItemStack item = pickUp.m_32055_().m_41777_();
        ItemStack toPolish = item.m_41620_(1);
        playerIn.m_6672_(handIn);
        if (!worldIn.f_46443_) {
            itemstack.m_41784_().m_128365_("Polishing", (Tag)toPolish.serializeNBT());
            if (item.m_41619_()) {
                pickUp.m_146870_();
            } else {
                pickUp.m_32045_(item);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        if (!(entityLiving instanceof Player)) {
            return stack;
        }
        Player player = (Player)entityLiving;
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Polishing")) {
            ItemStack toPolish = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Polishing"));
            ItemStack polished = SandPaperPolishingRecipe.applyPolish(worldIn, entityLiving.m_20182_(), toPolish, stack);
            if (worldIn.f_46443_) {
                SandPaperItem.spawnParticles(entityLiving.m_20299_(1.0f).m_82549_(entityLiving.m_20154_().m_82490_(0.5)), toPolish, worldIn);
                return stack;
            }
            if (!polished.m_41619_()) {
                if (player instanceof FakePlayer) {
                    player.m_7197_(polished, false, false);
                } else {
                    player.m_150109_().m_150079_(polished);
                }
            }
            tag.m_128473_("Polishing");
            stack.m_41622_(1, entityLiving, p -> p.m_21190_(p.m_7655_()));
        }
        return stack;
    }

    public static void spawnParticles(Vec3 location, ItemStack polishedStack, Level world) {
        for (int i = 0; i < 20; ++i) {
            Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)world.f_46441_, (float)0.125f);
            world.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, polishedStack), location.f_82479_, location.f_82480_, location.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof Player)) {
            return;
        }
        Player player = (Player)entityLiving;
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Polishing")) {
            ItemStack toPolish = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Polishing"));
            player.m_150109_().m_150079_(toPolish);
            tag.m_128473_("Polishing");
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        BlockState newState = state.getToolModifiedState(context, ToolActions.AXE_SCRAPE, false);
        if (newState != null) {
            AllSoundEvents.SANDING_LONG.play(level, player, (Vec3i)pos, 1.0f, 1.0f + (level.f_46441_.m_188501_() * 0.5f - 1.0f) / 5.0f);
            level.m_5898_(player, 3005, pos, 0);
        } else {
            newState = state.getToolModifiedState(context, ToolActions.AXE_WAX_OFF, false);
            if (newState != null) {
                AllSoundEvents.SANDING_LONG.play(level, player, (Vec3i)pos, 1.0f, 1.0f + (level.f_46441_.m_188501_() * 0.5f - 1.0f) / 5.0f);
                level.m_5898_(player, 3004, pos, 0);
            }
        }
        if (newState != null) {
            level.m_46597_(pos, newState);
            if (player != null) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction == ToolActions.AXE_SCRAPE || toolAction == ToolActions.AXE_WAX_OFF;
    }

    @Override
    public TriState shouldTriggerUseEffects(ItemStack stack, LivingEntity entity) {
        return TriState.TRUE;
    }

    @Override
    public boolean triggerUseEffects(ItemStack stack, LivingEntity entity, int count, RandomSource random) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Polishing")) {
            ItemStack polishing = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Polishing"));
            ((LivingEntityAccessor)entity).create$callSpawnItemParticles(polishing, 1);
        }
        if ((entity.m_21252_() - 6) % 7 == 0) {
            entity.m_5496_(entity.m_7866_(stack), 0.9f + 0.2f * random.m_188501_(), random.m_188501_() * 0.2f + 0.9f);
        }
        return true;
    }

    public SoundEvent m_6061_() {
        return AllSoundEvents.SANDING_SHORT.getMainEvent();
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.EAT;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public int m_6473_() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(SimpleCustomRenderer.create(this, new SandPaperItemRenderer()));
    }
}

