/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone;

import com.simibubi.create.api.contraption.transformable.TransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class DirectedDirectionalBlock
extends HorizontalDirectionalBlock
implements IWrenchable,
TransformableBlock {
    public static final EnumProperty<AttachFace> TARGET = EnumProperty.m_61587_((String)"target", AttachFace.class);

    public DirectedDirectionalBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(TARGET, (Comparable)AttachFace.WALL));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{TARGET, f_54117_}));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        int n = 0;
        Direction[] directionArray = pContext.m_6232_();
        int n2 = directionArray.length;
        if (n < n2) {
            Direction direction = directionArray[n];
            BlockState blockstate = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_(TARGET, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_()) : (BlockState)((BlockState)this.m_49966_().m_61124_(TARGET, (Comparable)AttachFace.WALL)).m_61124_((Property)f_54117_, (Comparable)direction.m_122424_());
            return blockstate;
        }
        return null;
    }

    public static Direction getTargetDirection(BlockState pState) {
        switch ((AttachFace)pState.m_61143_(TARGET)) {
            case CEILING: {
                return Direction.UP;
            }
            case FLOOR: {
                return Direction.DOWN;
            }
        }
        return (Direction)pState.m_61143_((Property)f_54117_);
    }

    @Override
    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (targetedFace.m_122434_() == Direction.Axis.Y) {
            return IWrenchable.super.getRotatedBlockState(originalState, targetedFace);
        }
        Direction targetDirection = DirectedDirectionalBlock.getTargetDirection(originalState);
        Direction newFacing = targetDirection.m_175362_(targetedFace.m_122434_());
        if (targetedFace.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            newFacing = newFacing.m_122424_();
        }
        if (newFacing.m_122434_() == Direction.Axis.Y) {
            return (BlockState)originalState.m_61124_(TARGET, (Comparable)(newFacing == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR));
        }
        return (BlockState)((BlockState)originalState.m_61124_(TARGET, (Comparable)AttachFace.WALL)).m_61124_((Property)f_54117_, (Comparable)newFacing);
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        if (transform.mirror != null) {
            state = this.m_6943_(state, transform.mirror);
        }
        if (transform.rotationAxis == Direction.Axis.Y) {
            return this.m_6843_(state, transform.rotation);
        }
        Direction targetDirection = DirectedDirectionalBlock.getTargetDirection(state);
        Direction newFacing = transform.rotateFacing(targetDirection);
        if (newFacing.m_122434_() == Direction.Axis.Y) {
            return (BlockState)state.m_61124_(TARGET, (Comparable)(newFacing == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR));
        }
        return (BlockState)((BlockState)state.m_61124_(TARGET, (Comparable)AttachFace.WALL)).m_61124_((Property)f_54117_, (Comparable)newFacing);
    }
}

