/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.render.ContraptionVisual;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.render.SpecialModels;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visual.SectionTrackedVisual;
import dev.engine_room.flywheel.api.visual.ShaderLightVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrackVisual
extends AbstractBlockEntityVisual<TrackBlockEntity>
implements ShaderLightVisual {
    private final List<BezierTrackVisual> visuals = new ArrayList<BezierTrackVisual>();

    public TrackVisual(VisualizationContext context, TrackBlockEntity track, float partialTick) {
        super(context, (BlockEntity)track, partialTick);
        this.collectConnections();
    }

    public void setSectionCollector(SectionTrackedVisual.SectionCollector sectionCollector) {
        super.setSectionCollector(sectionCollector);
        this.lightSections.sections(this.collectLightSections());
    }

    public void update(float pt) {
        if (((TrackBlockEntity)this.blockEntity).connections.isEmpty()) {
            return;
        }
        this._delete();
        this.collectConnections();
        this.lightSections.sections(this.collectLightSections());
    }

    private void collectConnections() {
        ((TrackBlockEntity)this.blockEntity).connections.values().stream().map(this::createInstance).filter(Objects::nonNull).forEach(this.visuals::add);
    }

    public void updateLight(float partialTick) {
        this.visuals.forEach(BezierTrackVisual::updateLight);
    }

    @Nullable
    private BezierTrackVisual createInstance(BezierConnection bc) {
        if (!bc.isPrimary()) {
            return null;
        }
        return new BezierTrackVisual(bc);
    }

    public void _delete() {
        this.visuals.forEach(BezierTrackVisual::delete);
        this.visuals.clear();
    }

    public LongSet collectLightSections() {
        if (((TrackBlockEntity)this.blockEntity).connections.isEmpty()) {
            return LongSet.of();
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BezierConnection connection : ((TrackBlockEntity)this.blockEntity).connections.values()) {
            for (BlockPos pos : connection.bePositions) {
                minX = Math.min(minX, pos.m_123341_());
                minY = Math.min(minY, pos.m_123342_());
                minZ = Math.min(minZ, pos.m_123343_());
                maxX = Math.max(maxX, pos.m_123341_());
                maxY = Math.max(maxY, pos.m_123342_());
                maxZ = Math.max(maxZ, pos.m_123343_());
            }
        }
        int minSectionX = ContraptionVisual.minLightSection(minX);
        int minSectionY = ContraptionVisual.minLightSection(minY);
        int minSectionZ = ContraptionVisual.minLightSection(minZ);
        int maxSectionX = ContraptionVisual.maxLightSection(maxX);
        int maxSectionY = ContraptionVisual.maxLightSection(maxY);
        int maxSectionZ = ContraptionVisual.maxLightSection(maxZ);
        LongArraySet out = new LongArraySet();
        for (int x = minSectionX; x <= maxSectionX; ++x) {
            for (int y = minSectionY; y <= maxSectionY; ++y) {
                for (int z = minSectionZ; z <= maxSectionZ; ++z) {
                    out.add(SectionPos.m_123209_((int)x, (int)y, (int)z));
                }
            }
        }
        return out;
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        for (BezierTrackVisual instance : this.visuals) {
            instance.collectCrumblingInstances(consumer);
        }
    }

    private static void updateLight(FlatLit instance, Level level, BlockPos pos) {
        instance.light(level.m_45517_(LightLayer.BLOCK, pos), level.m_45517_(LightLayer.SKY, pos)).setChanged();
    }

    private class BezierTrackVisual {
        private final TransformedInstance[] ties;
        private final TransformedInstance[] left;
        private final TransformedInstance[] right;
        @Nullable
        private GirderVisual girder;

        private BezierTrackVisual(BezierConnection bc) {
            this.girder = bc.hasGirder ? new GirderVisual(bc) : null;
            PoseStack pose = new PoseStack();
            TransformStack.of((PoseStack)pose).translate((Vec3i)TrackVisual.this.getVisualPosition());
            int segCount = bc.getSegmentCount();
            this.ties = new TransformedInstance[segCount];
            this.left = new TransformedInstance[segCount];
            this.right = new TransformedInstance[segCount];
            TrackMaterial.TrackModelHolder modelHolder = bc.getMaterial().getModelHolder();
            TrackVisual.this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.flatChunk(modelHolder.tie())).createInstances((Instance[])this.ties);
            TrackVisual.this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.flatChunk(modelHolder.leftSegment())).createInstances((Instance[])this.left);
            TrackVisual.this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.flatChunk(modelHolder.rightSegment())).createInstances((Instance[])this.right);
            BezierConnection.SegmentAngles[] segments = bc.getBakedSegments();
            for (int i = 1; i < segments.length; ++i) {
                BezierConnection.SegmentAngles segment = segments[i];
                int modelIndex = i - 1;
                this.ties[modelIndex].setTransform(pose).mul(segment.tieTransform).setChanged();
                for (boolean first : Iterate.trueAndFalse) {
                    PoseStack.Pose transform = (PoseStack.Pose)segment.railTransforms.get(first);
                    (first ? this.left : this.right)[modelIndex].setTransform(pose).mul(transform).setChanged();
                }
            }
            this.updateLight();
        }

        void delete() {
            for (TransformedInstance d : this.ties) {
                d.delete();
            }
            for (TransformedInstance d : this.left) {
                d.delete();
            }
            for (TransformedInstance d : this.right) {
                d.delete();
            }
            if (this.girder != null) {
                this.girder.delete();
            }
        }

        void updateLight() {
            if (this.girder != null) {
                this.girder.updateLight();
            }
        }

        public void collectCrumblingInstances(Consumer<Instance> consumer) {
            for (TransformedInstance d : this.ties) {
                consumer.accept((Instance)d);
            }
            for (TransformedInstance d : this.left) {
                consumer.accept((Instance)d);
            }
            for (TransformedInstance d : this.right) {
                consumer.accept((Instance)d);
            }
            if (this.girder != null) {
                this.girder.collectCrumblingInstances(consumer);
            }
        }

        private class GirderVisual {
            private final Couple<TransformedInstance[]> beams;
            private final Couple<Couple<TransformedInstance[]>> beamCaps;
            private final BlockPos[] lightPos;

            private GirderVisual(BezierConnection bc) {
                BlockPos tePosition = (BlockPos)bc.bePositions.getFirst();
                PoseStack pose = new PoseStack();
                ((PoseTransformStack)TransformStack.of((PoseStack)pose).translate((Vec3i)TrackVisual.this.getVisualPosition())).nudge((int)((BlockPos)bc.bePositions.getFirst()).m_121878_());
                int segCount = bc.getSegmentCount();
                this.beams = Couple.create(() -> new TransformedInstance[segCount]);
                this.beamCaps = Couple.create(() -> Couple.create(() -> new TransformedInstance[segCount]));
                this.lightPos = new BlockPos[segCount];
                this.beams.forEach(arg_0 -> ((Instancer)TrackVisual.this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.GIRDER_SEGMENT_MIDDLE))).createInstances(arg_0));
                this.beamCaps.forEachWithContext((c, top) -> {
                    Model partialModel = Models.partial((PartialModel)(top != false ? AllPartialModels.GIRDER_SEGMENT_TOP : AllPartialModels.GIRDER_SEGMENT_BOTTOM));
                    c.forEach(arg_0 -> ((Instancer)TrackVisual.this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, partialModel)).createInstances(arg_0));
                });
                BezierConnection.GirderAngles[] bakedGirders = bc.getBakedGirders();
                for (int i = 1; i < bakedGirders.length; ++i) {
                    BezierConnection.GirderAngles segment = bakedGirders[i];
                    int modelIndex = i - 1;
                    this.lightPos[modelIndex] = segment.lightPosition.m_121955_((Vec3i)tePosition);
                    for (boolean first : Iterate.trueAndFalse) {
                        PoseStack.Pose beamTransform = (PoseStack.Pose)segment.beams.get(first);
                        ((TransformedInstance[])this.beams.get(first))[modelIndex].setTransform(pose).mul(beamTransform).setChanged();
                        for (boolean top2 : Iterate.trueAndFalse) {
                            PoseStack.Pose beamCapTransform = (PoseStack.Pose)((Couple)segment.beamCaps.get(top2)).get(first);
                            ((TransformedInstance[])((Couple)this.beamCaps.get(top2)).get(first))[modelIndex].setTransform(pose).mul(beamCapTransform).setChanged();
                        }
                    }
                }
                this.updateLight();
            }

            void delete() {
                this.beams.forEach(arr -> {
                    for (TransformedInstance d : arr) {
                        d.delete();
                    }
                });
                this.beamCaps.forEach(c -> c.forEach(arr -> {
                    for (TransformedInstance d : arr) {
                        d.delete();
                    }
                }));
            }

            void updateLight() {
                this.beams.forEach(arr -> {
                    for (int i = 0; i < ((TransformedInstance[])arr).length; ++i) {
                        TrackVisual.updateLight((FlatLit)arr[i], TrackVisual.this.level, this.lightPos[i]);
                    }
                });
                this.beamCaps.forEach(c -> c.forEach(arr -> {
                    for (int i = 0; i < ((TransformedInstance[])arr).length; ++i) {
                        TrackVisual.updateLight((FlatLit)arr[i], TrackVisual.this.level, this.lightPos[i]);
                    }
                }));
            }

            public void collectCrumblingInstances(Consumer<Instance> consumer) {
                this.beams.forEach(arr -> {
                    for (TransformedInstance d : arr) {
                        consumer.accept((Instance)d);
                    }
                });
                this.beamCaps.forEach(c -> c.forEach(arr -> {
                    for (TransformedInstance d : arr) {
                        consumer.accept((Instance)d);
                    }
                }));
            }
        }
    }
}

