/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data.recipe;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.simibubi.create.api.data.recipe.CuttingRecipeGen;
import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import com.simibubi.create.foundation.data.recipe.Mods;
import java.util.Objects;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public final class CreateCuttingRecipeGen
extends CuttingRecipeGen {
    BaseRecipeProvider.GeneratedRecipe ANDESITE_ALLOY = this.create(CreateRecipeProvider.I::andesiteAlloy, b -> b.duration(200).output((ItemLike)AllBlocks.SHAFT.get(), 6));
    BaseRecipeProvider.GeneratedRecipe BAMBOO_PLANKS = this.create(() -> Blocks.f_244477_, b -> b.duration(20).output((ItemLike)Blocks.f_244489_, 1));
    BaseRecipeProvider.GeneratedRecipe ARS_N = this.cuttingCompat(Mods.ARS_N, "purple_archwood", "green_archwood", "red_archwood");
    BaseRecipeProvider.GeneratedRecipe ARS_E_1 = this.stripAndMakePlanksDiffPlanksModId(Mods.ARS_E, null, "stripped_yellow_archwood_log", Mods.ARS_N, "archwood_planks");
    BaseRecipeProvider.GeneratedRecipe ARS_E_2 = this.stripAndMakePlanksDiffPlanksModId(Mods.ARS_E, null, "stripped_yellow_archwood", Mods.ARS_N, "archwood_planks");
    BaseRecipeProvider.GeneratedRecipe RU_1 = this.stripAndMakePlanks(Mods.RU, "brimwood_log_magma", "stripped_brimwood_log", null);
    BaseRecipeProvider.GeneratedRecipe RU_2 = this.stripAndMakePlanks(Mods.RU, "ashen_log", "stripped_dead_log", null);
    BaseRecipeProvider.GeneratedRecipe RU_3 = this.stripAndMakePlanks(Mods.RU, "ashen_wood", "stripped_dead_wood", null);
    BaseRecipeProvider.GeneratedRecipe RU_4 = this.stripOnlyDiffModId(Mods.RU, "silver_birch_log", Mods.MC, "stripped_birch_log");
    BaseRecipeProvider.GeneratedRecipe RU_5 = this.stripOnlyDiffModId(Mods.RU, "silver_birch_wood", Mods.MC, "stripped_birch_wood");
    BaseRecipeProvider.GeneratedRecipe AUTUM_1 = this.stripAndMakePlanks(Mods.AUTUM, null, "sappy_maple_log", "maple_planks");
    BaseRecipeProvider.GeneratedRecipe AUTUM_2 = this.stripAndMakePlanks(Mods.AUTUM, null, "sappy_maple_wood", "maple_planks");
    BaseRecipeProvider.GeneratedRecipe ENDERGETIC_1 = this.stripAndMakePlanks(Mods.ENDER, "glowing_poise_stem", "stripped_poise_stem", null);
    BaseRecipeProvider.GeneratedRecipe ENDERGETIC_2 = this.stripAndMakePlanks(Mods.ENDER, "glowing_poise_wood", "stripped_poise_wood", null);
    BaseRecipeProvider.GeneratedRecipe IE_WIRES = this.ieWires("copper", "electrum", "aluminum", "steel", "lead");

    public CreateCuttingRecipeGen(PackOutput output) {
        super(output, "create");
    }

    BaseRecipeProvider.GeneratedRecipe cuttingCompat(Mods mod, String ... woodtypes) {
        for (String type : woodtypes) {
            Object planks = type + "_planks";
            if (mod == Mods.ARS_N && type.contains("archwood")) {
                planks = "archwood_planks";
            }
            String strippedPre = mod.strippedIsSuffix ? "" : "stripped_";
            String strippedPost = mod.strippedIsSuffix ? "_stripped" : "";
            this.stripAndMakePlanks(mod, type + "_log", strippedPre + type + "_log" + strippedPost, (String)planks);
            String wood = type + (mod.omitWoodSuffix ? "" : "_wood");
            this.stripAndMakePlanks(mod, wood, strippedPre + wood + strippedPost, (String)planks);
        }
        return null;
    }

    BaseRecipeProvider.GeneratedRecipe cuttingCompatLogOnly(Mods mod, String ... woodtypes) {
        for (String type : woodtypes) {
            String planks = type + "_planks";
            String strippedPre = mod.strippedIsSuffix ? "" : "stripped_";
            String strippedPost = mod.strippedIsSuffix ? "_stripped" : "";
            this.stripAndMakePlanks(mod, type + "_log", strippedPre + type + "_log" + strippedPost, planks);
        }
        return null;
    }

    BaseRecipeProvider.GeneratedRecipe stripOnlyDiffModId(Mods mod1, String wood, Mods mod2, String stripped) {
        this.create("compat/" + mod1.getId() + "/" + wood, b -> b.duration(50).require(mod1, wood).output(1.0f, mod2, stripped, 1).whenModLoaded(mod1.getId()));
        return null;
    }

    BaseRecipeProvider.GeneratedRecipe stripAndMakePlanksDiffPlanksModId(Mods mod1, String log, String stripped, Mods mod2, String planks) {
        if (log != null) {
            this.create("compat/" + mod1.getId() + "/" + log, b -> b.duration(50).require(mod1, log).output(1.0f, mod1, stripped, 1).whenModLoaded(mod1.getId()));
        }
        if (planks != null) {
            this.create("compat/" + mod1.getId() + "/" + stripped, b -> b.duration(50).require(mod1, stripped).output(1.0f, mod2, planks, 6).whenModLoaded(mod1.getId()));
        }
        return null;
    }

    BaseRecipeProvider.GeneratedRecipe stripAndMakePlanks(Mods mod, String wood, String stripped, String planks) {
        if (wood != null) {
            this.create("compat/" + mod.getId() + "/" + wood, b -> b.duration(50).require(mod, wood).output(1.0f, mod, stripped, 1).whenModLoaded(mod.getId()));
        }
        if (planks != null) {
            if (!Objects.equals(mod.getId(), Mods.VH.getId())) {
                this.create("compat/" + mod.getId() + "/" + stripped, b -> b.duration(50).require(mod, stripped).output(1.0f, mod, planks, 6).whenModLoaded(mod.getId()));
            } else {
                this.create("compat/" + mod.getId() + "/" + stripped, b -> b.duration(50).require(mod, stripped).output(1.0f, mod, planks, 4).whenModLoaded(mod.getId()));
            }
        }
        return null;
    }

    BaseRecipeProvider.GeneratedRecipe ieWires(String ... metals) {
        for (String metal : metals) {
            this.create(Mods.IE.recipeId("wire_" + metal), b -> b.duration(50).require(AllTags.forgeItemTag("plates/" + metal)).output(1.0f, Mods.IE, "wire_" + metal, 2).whenModLoaded(Mods.IE.getId()));
        }
        return null;
    }
}

