/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.client.animators;

import com.nukateam.cgs.common.faundation.item.guns.HammerItem;
import com.nukateam.ntgl.client.animators.WeaponAnimator;
import com.nukateam.ntgl.client.render.renderers.weapon.DynamicWeaponRenderer;
import com.nukateam.ntgl.client.util.handler.ClientMeleeHandler;
import com.nukateam.ntgl.client.util.helpers.TransformUtils;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class HammerAnimator
extends WeaponAnimator {
    public static final String MELEE_POWER_END = "melee_power_end";
    public static final String MELEE_POWER_END2 = "melee_power_end2";
    public static final String MELEE_POWER = "melee_power";
    public static final String MELEE = "melee";
    public static final String MELEE_END = "melee_end";
    public static final String RELOAD_SHOT = "reload_shot";
    public static final String RELOAD_SHOT_EMPTY = "reload_shot_empty";
    private boolean isPowered = false;
    private int ammoCount;
    private boolean isShotPowered;
    private WeaponData data;
    private boolean isSecondary;

    public HammerAnimator(ItemDisplayContext transformType, DynamicWeaponRenderer<WeaponAnimator> renderer) {
        super(transformType, renderer);
    }

    protected void tickStart() {
        super.tickStart();
        ClientMeleeHandler.ClientMeleeTracker meleeTracker = ClientMeleeHandler.getTracker((LivingEntity)this.getEntity(), (InteractionHand)this.getArm());
        if (meleeTracker != null) {
            WeaponData data = meleeTracker.getData();
            boolean bl = this.isSecondary = data.weaponMode == WeaponMode.SECONDARY;
        }
        if (this.itemStack != null && !this.itemStack.m_41619_()) {
            this.data = this.getGunData();
        }
        this.ammoCount = WeaponStateHelper.getAmmoCount((WeaponData)this.data);
        this.isShotPowered = this.isShotPowered();
    }

    protected RawAnimation getMeleeDelayAnimation(AnimationState<WeaponAnimator> event) {
        if (TransformUtils.isFirstPerson((ItemDisplayContext)this.transformType)) {
            if (this.isSecondary && HammerItem.isPowered(this.data)) {
                this.isPowered = true;
                try {
                    RawAnimation animation = this.playGunAnim(MELEE_POWER, Animation.LoopType.HOLD_ON_LAST_FRAME);
                    this.animationHelper.syncAnimation(event, this.meleeDelay, new String[]{MELEE_POWER});
                    return animation;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.isPowered = false;
            RawAnimation animation = this.playGunAnim(MELEE, Animation.LoopType.HOLD_ON_LAST_FRAME);
            this.animationHelper.syncAnimation(event, this.meleeDelay, new String[]{MELEE});
            return animation;
        }
        return super.getMeleeDelayAnimation(event);
    }

    protected RawAnimation getMeleeCooldownAnimation(AnimationState<WeaponAnimator> event) {
        if (TransformUtils.isFirstPerson((ItemDisplayContext)this.transformType)) {
            if (this.isSecondary && this.isPowered) {
                if (!this.animationHelper.hasAnimation(MELEE_POWER_END)) {
                    return this.getHoldAnimation(event);
                }
                ArrayList<String> animations = new ArrayList<String>(List.of(MELEE_POWER_END));
                RawAnimation animation = RawAnimation.begin().then(this.getGunAnim(MELEE_POWER_END), Animation.LoopType.PLAY_ONCE);
                if (this.isShotPowered) {
                    animation.then(this.getGunAnim(MELEE_POWER_END2), Animation.LoopType.PLAY_ONCE);
                    animations.add(MELEE_POWER_END2);
                }
                this.animationHelper.syncAnimation(event, this.meleeCooldown, animations);
                return animation;
            }
            RawAnimation animation = this.playGunAnim(MELEE_END, Animation.LoopType.HOLD_ON_LAST_FRAME);
            this.animationHelper.syncAnimation(event, this.meleeCooldown, new String[]{MELEE_END});
            return animation;
        }
        return super.getMeleeCooldownAnimation(event);
    }

    protected RawAnimation getDefaultReloadAnimation(AnimationState<WeaponAnimator> event) {
        if (this.isShotPowered()) {
            ArrayList<String> animations = new ArrayList<String>(List.of(RELOAD_SHOT));
            RawAnimation animation = RawAnimation.begin().then(this.getGunAnim(RELOAD_SHOT), Animation.LoopType.PLAY_ONCE);
            if (this.ammoCount == 0) {
                animation.then(this.getGunAnim(RELOAD_SHOT_EMPTY), Animation.LoopType.PLAY_ONCE);
                animations.add(RELOAD_SHOT_EMPTY);
            }
            this.animationHelper.syncAnimation(event, this.reloadTime, animations);
            return animation;
        }
        return super.getDefaultReloadAnimation(event);
    }

    private boolean isShotPowered() {
        return this.getStack().m_41720_() instanceof WeaponItem && WeaponStateHelper.hasAttachmentEquipped((ItemStack)this.getStack(), (AttachmentType)AttachmentType.MAGAZINE);
    }

    protected RawAnimation getHoldAnimation(AnimationState<WeaponAnimator> event) {
        if (TransformUtils.isFirstPerson((ItemDisplayContext)this.transformType)) {
            return super.getHoldAnimation(event);
        }
        return null;
    }
}

