/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.faundation.item.guns;

import com.nukateam.cgs.client.renderers.weapon.BaseWeaponRenderer;
import com.nukateam.cgs.common.utils.GunUtils;
import com.nukateam.geo.render.DynamicGeoItemRenderer;
import com.nukateam.ntgl.client.animators.WeaponAnimator;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.registry.AmmoHolders;
import com.nukateam.ntgl.common.util.interfaces.IWeaponModifier;
import com.nukateam.ntgl.common.util.util.FuelUtils;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class CgsGunItem
extends WeaponItem {
    private final Lazy<BaseWeaponRenderer> RENDERER = Lazy.of(() -> new BaseWeaponRenderer());

    public CgsGunItem(Item.Properties properties, IWeaponModifier ... modifiers) {
        super(properties, modifiers);
    }

    @OnlyIn(value=Dist.CLIENT)
    public DynamicGeoItemRenderer<WeaponAnimator> getRenderer() {
        return (DynamicGeoItemRenderer)this.RENDERER.get();
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public void m_6883_(ItemStack gun, Level level, Entity entity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(gun, level, entity, pSlotId, pIsSelected);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            WeaponData gunData = new WeaponData(gun, livingEntity);
            CgsGunItem.onEngineTick(gunData);
            CgsGunItem.fillWater(gunData);
        }
    }

    public boolean m_142305_(ItemStack gun, ItemStack fuel, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY) {
            GunUtils.playAttachSound(player, 0.5f);
            return GunUtils.fillFuel(gun, player, fuel);
        }
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        WeaponData gunData = new WeaponData(stack, null);
        Set fuelTypes = WeaponModifierHelper.getAllFuel((WeaponData)gunData);
        if (!fuelTypes.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"info.cgs.fuel").m_130940_(ChatFormatting.GRAY));
        }
    }

    private static void onEngineTick(WeaponData data) {
        Set fuel = WeaponModifierHelper.getAllFuel((WeaponData)data);
        if (!fuel.isEmpty() && CgsGunItem.isInHand(data) && fuel.contains(AmmoHolders.BURNABLE)) {
            FuelUtils.addFuel((WeaponData)data, (AmmoHolder)AmmoHolders.BURNABLE, (int)-1);
        }
    }

    private static void fillWater(WeaponData gunData) {
        Set types = WeaponModifierHelper.getAllFuel((WeaponData)gunData);
        if (gunData.wielder.m_20069_() && types.contains(AmmoHolders.WATER)) {
            Integer maxWater = WeaponModifierHelper.getMaxFuel((ResourceLocation)AmmoHolders.WATER.getId(), (WeaponData)gunData);
            FuelUtils.setFuel((ItemStack)gunData.weapon, (AmmoHolder)AmmoHolders.WATER, (int)maxWater);
        }
    }

    private static boolean isInHand(WeaponData data) {
        ItemStack mainHand = data.wielder.m_21205_();
        ItemStack offHand = data.wielder.m_21206_();
        boolean oneHanded1 = WeaponModifierHelper.isOneHanded((WeaponData)new WeaponData(mainHand, data.wielder));
        boolean oneHanded2 = WeaponModifierHelper.isOneHanded((WeaponData)new WeaponData(offHand, data.wielder));
        return mainHand == data.weapon || offHand == data.weapon && oneHanded1 && oneHanded2;
    }
}

