/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.utility;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import plus.dragons.createcentralkitchen.foundation.utility.ModLoadSubscriber;
import plus.dragons.createcentralkitchen.foundation.utility.Mods;

public class AutomaticModLoadSubscriber {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Type MOD_LOAD_SUBSCRIBER = Type.getType(ModLoadSubscriber.class);
    private static final List<ModAnnotation.EnumHolder> DEFAULT_DIST = List.of(new ModAnnotation.EnumHolder(null, "CLIENT"), new ModAnnotation.EnumHolder(null, "DEDICATED_SERVER"));
    private static final ModAnnotation.EnumHolder DEFAULT_BUS = new ModAnnotation.EnumHolder(null, "MOD");

    public static void load(FMLModContainer mod, Class<?> modClass) {
        LOGGER.debug(Logging.LOADING, "Attempting to load class annotated with @ModLoadSubscriber {}", (Object)mod.getModId());
        String modId = mod.getModId();
        ClassLoader classLoader = modClass.getClassLoader();
        ModFileScanData scanData = mod.getModInfo().getOwningFile().getFile().getScanResult();
        ModList mods = ModList.get();
        List<ModFileScanData.AnnotationData> targets = scanData.getAnnotations().stream().filter(annotationData -> MOD_LOAD_SUBSCRIBER.equals((Object)annotationData.annotationType())).sorted(Comparator.comparing(data -> data.clazz().getClassName())).toList();
        for (ModFileScanData.AnnotationData target : targets) {
            String requiredModId;
            List<ModAnnotation.EnumHolder> distHolder = target.annotationData().getOrDefault("value", DEFAULT_DIST);
            EnumSet dist = distHolder.stream().map(holder -> Dist.valueOf((String)holder.getValue())).collect(Collectors.toCollection(() -> EnumSet.noneOf(Dist.class)));
            if (!dist.contains(FMLEnvironment.dist) || !Mods.isLoaded(requiredModId = target.annotationData().getOrDefault("modid", modId))) continue;
            ModAnnotation.EnumHolder busHolder = target.annotationData().getOrDefault("bus", DEFAULT_BUS);
            Mod.EventBusSubscriber.Bus bus = Mod.EventBusSubscriber.Bus.valueOf((String)busHolder.getValue());
            String targetClassName = target.clazz().getClassName();
            try {
                LOGGER.debug(Logging.LOADING, "Auto-loading class {}", (Object)targetClassName);
                Class<?> targetClass = Class.forName(targetClassName, true, classLoader);
                LOGGER.debug(Logging.LOADING, "Auto-subscribing {} to {}", (Object)targetClassName, (Object)bus);
                ((IEventBus)bus.bus().get()).register(targetClass);
            }
            catch (ClassNotFoundException exception) {
                LOGGER.fatal(Logging.LOADING, "Failed to load class {} for @ModLoadSubscriber annotation", (Object)targetClassName, (Object)exception);
                throw new RuntimeException(exception);
            }
        }
    }
}

