/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.jarPackager;

import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import ru.zznty.create_factory_abstractions.api.generic.capability.PackageBuilder;
import ru.zznty.create_factory_abstractions.api.generic.capability.PackageMeasureResult;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKey;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_logistics.Config;
import ru.zznty.create_factory_logistics.logistics.generic.FluidGenericStack;
import ru.zznty.create_factory_logistics.logistics.generic.FluidKey;
import ru.zznty.create_factory_logistics.logistics.jar.JarStyles;

class JarPackageBuilder
implements PackageBuilder {
    private FluidStack fluidStack = FluidStack.EMPTY;

    JarPackageBuilder() {
    }

    public int add(GenericStack content) {
        GenericKey genericKey = content.key();
        if (!(genericKey instanceof FluidKey)) {
            throw new IllegalArgumentException("Unsupported content: " + String.valueOf(content));
        }
        FluidKey fluidKey = (FluidKey)genericKey;
        if (!this.fluidStack.isEmpty() && !this.fluidStack.isFluidEqual(fluidKey.stack())) {
            return -1;
        }
        if (this.fluidStack.isEmpty()) {
            this.fluidStack = fluidKey.stack().copy();
            this.fluidStack.setAmount(0);
        }
        int remainingAmount = content.amount();
        int amountToAdd = Math.min(Config.jarCapacity - this.fluidStack.getAmount(), remainingAmount);
        this.fluidStack.grow(amountToAdd);
        return remainingAmount - amountToAdd;
    }

    public List<GenericStack> content() {
        return List.of(FluidGenericStack.wrap(this.fluidStack));
    }

    public boolean isFull() {
        return this.fluidStack.getAmount() >= Config.jarCapacity;
    }

    public int maxPerSlot() {
        return Config.jarCapacity;
    }

    public int slotCount() {
        return 1;
    }

    public PackageMeasureResult measure(GenericKey key) {
        if (key instanceof FluidKey) {
            return PackageMeasureResult.BULKY;
        }
        throw new IllegalArgumentException("Unsupported key: " + String.valueOf(key));
    }

    public ItemStack build() {
        if (this.fluidStack.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack jar = new ItemStack((ItemLike)JarStyles.getRandomJar());
        FluidUtil.getFluidHandler((ItemStack)jar).ifPresent(handler -> handler.fill(this.fluidStack, IFluidHandler.FluidAction.EXECUTE));
        return jar;
    }
}

