/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_chicken.compat.jei;

import com.oierbravo.create_mechanical_chicken.CreateMechanicalChicken;
import com.oierbravo.create_mechanical_chicken.ModRegistration;
import com.oierbravo.create_mechanical_chicken.compat.jei.AnimatedChicken;
import com.oierbravo.create_mechanical_chicken.content.components.MechanicalChickenConfigs;
import com.oierbravo.create_mechanical_chicken.foundation.utility.ModLang;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("create_mechanical_chicken", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new MechanicalChickenCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModRegistration.MECHANICAL_CHICKEN_BLOCK.get()), new RecipeType[]{MechanicalChickenCategory.TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(MechanicalChickenCategory.TYPE, MechanicalChickenCategory.getRecipes());
    }

    public class MechanicalChickenCategory
    implements IRecipeCategory<MechanicalChickenRecipe> {
        public static final RecipeType<MechanicalChickenRecipe> TYPE = RecipeType.create((String)"create_mechanical_chicken", (String)"production", MechanicalChickenRecipe.class);
        private final IDrawable background;
        private final IDrawable icon;
        private final IDrawable slotDrawable;
        private AnimatedChicken chicken = new AnimatedChicken();

        public MechanicalChickenCategory(IGuiHelper guiHelper) {
            this.background = new IDrawable(){

                public int getWidth() {
                    return 176;
                }

                public int getHeight() {
                    return 40;
                }

                public void draw(GuiGraphics graphics, int xOffset, int yOffset) {
                    AllGuiTextures.JEI_ARROW.render(graphics, 30, 16);
                    AllGuiTextures.JEI_ARROW.render(graphics, 110, 16);
                    MechanicalChickenCategory.this.chicken.draw(graphics, 82, 35);
                }
            };
            this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(ModRegistration.MECHANICAL_CHICKEN_BLOCK));
            this.slotDrawable = guiHelper.getSlotDrawable();
        }

        public RecipeType<MechanicalChickenRecipe> getRecipeType() {
            return TYPE;
        }

        public Component getTitle() {
            return ModLang.translate("recipe", new Object[0]).component();
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return this.icon;
        }

        public void setRecipe(IRecipeLayoutBuilder builder, MechanicalChickenRecipe recipe, IFocusGroup iFocusGroup) {
            IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 4, 15).setBackground(this.slotDrawable, -1, -1);
            if (recipe.fluid != null) {
                ((IRecipeSlotBuilder)input.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.fluid.getMatchingFluidStacks())).addRichTooltipCallback(MechanicalChickenCategory::addFluidAmountTooltip);
            }
            IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 155, 15);
            if (recipe.itemStack != null) {
                ((IRecipeSlotBuilder)output.addItemStack(recipe.itemStack)).setBackground(this.slotDrawable, -1, -1);
            }
        }

        private static void addFluidAmountTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
            Optional displayed = recipeSlotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK);
            if (displayed.isEmpty()) {
                return;
            }
            FluidStack fluidStack = (FluidStack)displayed.get();
            tooltip.add((FormattedText)Component.m_237113_((String)(fluidStack.getAmount() + "mB")));
        }

        public void draw(MechanicalChickenRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
            Minecraft minecraft = Minecraft.m_91087_();
        }

        private static FluidIngredient getFluidIngredientFromConfig() {
            FluidIngredient fluidIngredient = FluidIngredient.EMPTY;
            String fluidResourceRaw = (String)MechanicalChickenConfigs.REQUIRED_FLUID.get();
            int configuredAmount = (Integer)MechanicalChickenConfigs.REQUIRED_FLUID_AMOUNT.get();
            if (fluidResourceRaw.startsWith("#")) {
                ResourceLocation fluidTag = ResourceLocation.m_135820_((String)fluidResourceRaw.replace("#", ""));
                assert (fluidTag != null);
                return FluidIngredient.fromTag((TagKey)FluidTags.create((ResourceLocation)fluidTag), (int)configuredAmount);
            }
            ResourceLocation desiredFluid = new ResourceLocation(fluidResourceRaw);
            if (ForgeRegistries.FLUIDS.containsKey(desiredFluid)) {
                fluidIngredient = FluidIngredient.fromFluid((Fluid)((Fluid)ForgeRegistries.FLUIDS.getValue(desiredFluid)), (int)configuredAmount);
            } else {
                CreateMechanicalChicken.LOGGER.error("Unknown fluid '{}' in config, using default '{}' instead", (Object)fluidResourceRaw, (Object)"minecraft:water");
                fluidIngredient = FluidIngredient.fromFluid((Fluid)Fluids.f_76193_, (int)configuredAmount);
            }
            return fluidIngredient;
        }

        public static List<MechanicalChickenRecipe> getRecipes() {
            ArrayList<MechanicalChickenRecipe> recipes = new ArrayList<MechanicalChickenRecipe>();
            int configuredOutputAmount = (Integer)MechanicalChickenConfigs.OUTPUT_AMOUNT.get();
            recipes.add(new MechanicalChickenRecipe(MechanicalChickenCategory.getFluidIngredientFromConfig(), new ItemStack((ItemLike)Items.f_42521_, configuredOutputAmount)));
            return recipes;
        }

        public record MechanicalChickenRecipe(@Nullable FluidIngredient fluid, ItemStack itemStack) {
        }
    }
}

