/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_chicken.content.components;

import com.oierbravo.create_mechanical_chicken.CreateMechanicalChicken;
import com.oierbravo.create_mechanical_chicken.content.components.IHavePercent;
import com.oierbravo.create_mechanical_chicken.content.components.MechanicalChickenBlock;
import com.oierbravo.create_mechanical_chicken.content.components.MechanicalChickenConfigs;
import com.oierbravo.create_mechanical_chicken.foundation.blockEntity.behaviour.CycleBehavior;
import com.oierbravo.create_mechanical_chicken.foundation.utility.ModLang;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class MechanicalChickenBlockEntity
extends KineticBlockEntity
implements CycleBehavior.CycleBehaviourSpecifics,
IHavePercent {
    private CycleBehavior cycleBehaviour;
    private FluidIngredient requiredFluidIngredient;
    public final ItemStackHandler outputInventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            MechanicalChickenBlockEntity.this.m_6596_();
            MechanicalChickenBlockEntity.this.f_58857_.m_7260_(MechanicalChickenBlockEntity.this.f_58858_, MechanicalChickenBlockEntity.this.m_58900_(), MechanicalChickenBlockEntity.this.m_58900_(), 3);
        }
    };
    public SmartFluidTankBehaviour inputTank;
    private boolean contentsChanged;
    protected LazyOptional<IFluidHandler> fluidCapability;
    private final LazyOptional<IItemHandler> itemCapability = LazyOptional.of(() -> this.outputInventory);

    public MechanicalChickenBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.verifyConfig(CreateMechanicalChicken.LOGGER);
        this.inputTank.getPrimaryHandler().setValidator((Predicate)this.requiredFluidIngredient);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, ((Integer)MechanicalChickenConfigs.FLUID_CAPACITY.get()).intValue(), true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        this.fluidCapability = LazyOptional.of(() -> {
            LazyOptional inputCap = this.inputTank.getCapability();
            return new CombinedTankWrapper(new IFluidHandler[]{(IFluidHandler)inputCap.orElse(null)});
        });
        this.cycleBehaviour = new CycleBehavior(this, (Integer)MechanicalChickenConfigs.PROCESSING_TIME.get(), true);
        behaviours.add(this.cycleBehaviour);
    }

    public void invalidate() {
        super.invalidate();
        this.itemCapability.invalidate();
        this.fluidCapability.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        Direction localDir = (Direction)this.m_58900_().m_61143_(MechanicalChickenBlock.HORIZONTAL_FACING);
        if (side == null) {
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                return this.itemCapability.cast();
            }
            if (cap == ForgeCapabilities.FLUID_HANDLER) {
                return this.fluidCapability.cast();
            }
        }
        if (side == Direction.DOWN || side == Direction.UP) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && localDir == side.m_122424_()) {
            return this.itemCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && localDir == side) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public CycleBehavior getCycleBehaviour() {
        return this.cycleBehaviour;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("OutputInventory", (Tag)this.outputInventory.serializeNBT());
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.outputInventory.deserializeNBT(compound.m_128469_("OutputInventory"));
    }

    @Override
    public void onCycleCompleted() {
    }

    @Override
    public float getKineticSpeed() {
        return this.getSpeed();
    }

    @Override
    public boolean tryProcess(boolean simulate) {
        if (this.inputTank.getPrimaryHandler().isEmpty()) {
            return false;
        }
        if (this.inputTank.getPrimaryHandler().getFluidAmount() < (Integer)MechanicalChickenConfigs.REQUIRED_FLUID_AMOUNT.get()) {
            return false;
        }
        if (ItemStack.f_41583_ != this.outputInventory.insertItem(0, new ItemStack((ItemLike)Items.f_42521_, ((Integer)MechanicalChickenConfigs.OUTPUT_AMOUNT.get()).intValue()), true)) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.inputTank.getPrimaryHandler().drain(((Integer)MechanicalChickenConfigs.REQUIRED_FLUID_AMOUNT.get()).intValue(), IFluidHandler.FluidAction.EXECUTE);
        this.outputInventory.insertItem(0, new ItemStack((ItemLike)Items.f_42521_, ((Integer)MechanicalChickenConfigs.OUTPUT_AMOUNT.get()).intValue()), false);
        return true;
    }

    @Override
    public void playSound() {
        this.f_58857_.m_245803_((Entity)null, this.f_58858_, SoundEvents.f_11752_, SoundSource.BLOCKS, ((Double)MechanicalChickenConfigs.SOUND_VOLUME.get()).floatValue(), 1.0f);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.cycleBehaviour.isRunning()) {
            ModLang.translate("chicken.tooltip.progress", this.getProgressPercent()).style(ChatFormatting.YELLOW).forGoggles(tooltip);
            added = true;
        }
        return added;
    }

    @Override
    public int getProgressPercent() {
        return this.cycleBehaviour.getProgressPercent();
    }

    public FluidIngredient getFluidIngredient() {
        int amount = (Integer)MechanicalChickenConfigs.REQUIRED_FLUID_AMOUNT.get();
        String name = (String)MechanicalChickenConfigs.REQUIRED_FLUID.get();
        if (name.startsWith("#")) {
            return FluidIngredient.fromTag((TagKey)FluidTags.create((ResourceLocation)ResourceLocation.m_135820_((String)name.replace("#", ""))), (int)amount);
        }
        return FluidIngredient.fromFluid((Fluid)this.getRequiredFluid(), (int)amount);
    }

    public Fluid getRequiredFluid() {
        return (Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.m_135820_((String)((String)MechanicalChickenConfigs.REQUIRED_FLUID.get())));
    }

    public FluidStack getRequiredFluidStack() {
        Fluid requiredFluid = this.getRequiredFluid();
        if (requiredFluid == null) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(requiredFluid, ((Integer)MechanicalChickenConfigs.REQUIRED_FLUID_AMOUNT.get()).intValue());
    }

    public void verifyConfig(Logger logger) {
        if (this.requiredFluidIngredient == null) {
            String fluidResourceRaw = (String)MechanicalChickenConfigs.REQUIRED_FLUID.get();
            int configuredAmount = (Integer)MechanicalChickenConfigs.REQUIRED_FLUID_AMOUNT.get();
            if (fluidResourceRaw.startsWith("#")) {
                ResourceLocation fluidTag = ResourceLocation.m_135820_((String)fluidResourceRaw.replace("#", ""));
                assert (fluidTag != null);
                this.requiredFluidIngredient = FluidIngredient.fromTag((TagKey)FluidTags.create((ResourceLocation)fluidTag), (int)configuredAmount);
                return;
            }
            ResourceLocation desiredFluid = new ResourceLocation(fluidResourceRaw);
            if (ForgeRegistries.FLUIDS.containsKey(desiredFluid)) {
                this.requiredFluidIngredient = FluidIngredient.fromFluid((Fluid)((Fluid)ForgeRegistries.FLUIDS.getValue(desiredFluid)), (int)configuredAmount);
            } else {
                logger.error("Unknown fluid '{}' in config, using default '{}' instead", (Object)fluidResourceRaw, (Object)"minecraft:water");
                this.requiredFluidIngredient = FluidIngredient.fromFluid((Fluid)Fluids.f_76193_, (int)configuredAmount);
            }
        }
    }
}

