/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.commands;

import com.jesz.createdieselgenerators.world.OilChunksSavedData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ChunkPos;

public class CDGCommands {
    public CDGCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"cdg").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"oil").then(Commands.m_82127_((String)"get").executes(command -> this.getOilChunk((CommandSourceStack)command.getSource())))).then(Commands.m_82127_((String)"locate").executes(command -> this.locateOilChunk((CommandSourceStack)command.getSource())))).then(Commands.m_82127_((String)"regenerate").executes(command -> this.refreshOilChunk((CommandSourceStack)command.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"infinity").executes(command -> this.setOilChunkInfinite((CommandSourceStack)command.getSource(), (CommandContext<CommandSourceStack>)command)))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(command -> this.setOilChunk((CommandSourceStack)command.getSource(), (CommandContext<CommandSourceStack>)command))))));
    }

    private int getOilChunk(CommandSourceStack source) throws CommandSyntaxException {
        if (!source.m_6761_(2)) {
            return 0;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos((int)source.m_81371_().f_82479_, (int)source.m_81371_().f_82480_, (int)source.m_81371_().f_82481_));
        int amount = OilChunksSavedData.getChunkOilAmount(source.m_81372_(), chunkPos);
        if (amount == Integer.MAX_VALUE) {
            source.m_288197_(() -> Component.m_237113_((String)"This oil chunk is infinite.").m_130940_(ChatFormatting.GRAY), false);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"There is ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(String.format("%,1d", amount) + "mB")).m_130940_(ChatFormatting.GOLD)).m_130946_(" of Oil in this Chunk.").m_130940_(ChatFormatting.GRAY), false);
        }
        return 1;
    }

    private int refreshOilChunk(CommandSourceStack source) throws CommandSyntaxException {
        if (!source.m_6761_(2)) {
            return 0;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos((int)source.m_81371_().f_82479_, (int)source.m_81371_().f_82480_, (int)source.m_81371_().f_82481_));
        OilChunksSavedData.removeChunk(source.m_81372_(), chunkPos);
        source.m_288197_(() -> Component.m_237113_((String)"Refreshed this chunks oil contents").m_130940_(ChatFormatting.GRAY), false);
        return 1;
    }

    private int setOilChunk(CommandSourceStack source, CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        if (!source.m_6761_(2)) {
            return 0;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos((int)source.m_81371_().f_82479_, (int)source.m_81371_().f_82480_, (int)source.m_81371_().f_82481_));
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        OilChunksSavedData.setChunkOilAmount(source.m_81372_(), chunkPos, amount);
        source.m_288197_(() -> Component.m_237113_((String)"Set this chunk's oil deposits to ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(String.format("%,1d", amount) + "mB")).m_130940_(ChatFormatting.GOLD)), false);
        return 1;
    }

    private int setOilChunkInfinite(CommandSourceStack source, CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        if (!source.m_6761_(2)) {
            return 0;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos((int)source.m_81371_().f_82479_, (int)source.m_81371_().f_82480_, (int)source.m_81371_().f_82481_));
        OilChunksSavedData.setChunkOilAmount(source.m_81372_(), chunkPos, Integer.MAX_VALUE);
        source.m_288197_(() -> Component.m_237113_((String)"This chunk is now infinite").m_130940_(ChatFormatting.GRAY), false);
        return 1;
    }

    private int locateOilChunk(CommandSourceStack source) throws CommandSyntaxException {
        if (!source.m_6761_(2)) {
            return 0;
        }
        BlockPos sourcePos = BlockPos.m_274446_((Position)source.m_81371_());
        ChunkPos centerChunk = new ChunkPos(sourcePos);
        int radius = 10;
        int dx = 0;
        int dz = -1;
        for (int i = 0; i < (radius * 2 + 1) * (radius * 2 + 1); ++i) {
            int cx = centerChunk.f_45578_ + dx;
            int cz = centerChunk.f_45579_ + dz;
            ChunkPos currentChunk = new ChunkPos(cx, cz);
            int amount = OilChunksSavedData.getChunkOilAmount(source.m_81372_(), currentChunk);
            if (amount != 0) {
                int blockX = cx * 16 + 8;
                int blockZ = cz * 16 + 8;
                source.m_288197_(() -> Component.m_237113_((String)"There is oil in chunk ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(cx + " " + cz)).m_130940_(ChatFormatting.GOLD).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + blockX + " ~ " + blockZ)))).m_130946_(" with ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(String.format("%,1d", amount) + "mB ")).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"of oil.").m_130940_(ChatFormatting.GRAY)), false);
                return 1;
            }
            if (dx == dz || dx < 0 && dx == -dz || dx > 0 && dx == 1 - dz) {
                int temp = dx;
                dx = -dz;
                dz = temp;
            }
            dx += Integer.signum(dx);
            dz += Integer.signum(dz);
        }
        source.m_81352_((Component)Component.m_237113_((String)"There is no oil chunk nearby").m_130940_(ChatFormatting.RED));
        return 1;
    }
}

