/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.item;

import com.adonis.createfisheryindustry.client.renderer.ISTERProvider;
import com.adonis.createfisheryindustry.entity.HarpoonEntity;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class HarpoonItem
extends TridentItem {
    private static final float ATTACK_DAMAGE = 6.0f;
    private static final float ATTACK_SPEED = -2.9f;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public HarpoonItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 6.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-2.9f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(ISTERProvider.harpoon());
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity, int timeLeft) {
        if (livingEntity instanceof Player) {
            int riptideLevel;
            Player player = (Player)livingEntity;
            int i = this.m_8105_(stack) - timeLeft;
            if (i >= 10 && ((riptideLevel = EnchantmentHelper.m_44932_((ItemStack)stack)) <= 0 || player.m_20070_())) {
                if (!level.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(livingEntity.m_7655_()));
                    if (riptideLevel == 0) {
                        HarpoonEntity harpoon = new HarpoonEntity(level, (LivingEntity)player, stack);
                        harpoon.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f + (float)riptideLevel * 0.5f, 1.0f);
                        if (player.m_150110_().f_35937_) {
                            harpoon.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        level.m_7967_((Entity)harpoon);
                        level.m_6269_(null, (Entity)harpoon, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!player.m_150110_().f_35937_) {
                            player.m_150109_().m_36057_(stack);
                        }
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (riptideLevel > 0) {
                    float yaw = player.m_146908_();
                    float pitch = player.m_146909_();
                    float f2 = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
                    float f3 = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
                    float f4 = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
                    float f5 = Mth.m_14116_((float)(f2 * f2 + f3 * f3 + f4 * f4));
                    float f6 = 3.0f * ((1.0f + (float)riptideLevel) / 4.0f);
                    player.m_5997_((double)(f2 *= f6 / f5), (double)(f3 *= f6 / f5), (double)(f4 *= f6 / f5));
                    player.m_204079_(20);
                    if (player.m_20096_()) {
                        player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    SoundEvent soundevent = riptideLevel >= 3 ? SoundEvents.f_12519_ : (riptideLevel == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
                    level.m_6269_(null, (Entity)player, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (EnchantmentHelper.m_44932_((ItemStack)itemstack) > 0 && !player.m_20070_()) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        if ((double)state.m_60800_((BlockGetter)level, pos) != 0.0) {
            stack.m_41622_(2, miningEntity, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }

    public int m_6473_() {
        return 1;
    }
}

