/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.recipes;

import com.google.gson.JsonObject;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import fr.lucreeper74.createmetallurgy.CreateMetallurgy;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.CrucibleBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.MeltingInventory;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.slf4j.Logger;

public class FoundryRecipe
extends ProcessingRecipe<SmartInventory> {
    protected int minHeat;
    protected int maxHeat;

    public FoundryRecipe(IRecipeTypeInfo typeInfo, ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(typeInfo, params);
        this.validate(typeInfo.getId());
    }

    private void validate(ResourceLocation recipeTypeId) {
        String messageHeader = "Your custom recipe (" + String.valueOf(recipeTypeId) + ")";
        Logger logger = CreateMetallurgy.LOGGER;
        if (this.minHeat > this.maxHeat) {
            logger.warn(messageHeader + " specified a minimum heat value greater than the maximum value.");
        }
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public static boolean bulkMatch(CrucibleBlockEntity be, Recipe<?> recipe) {
        if (recipe instanceof ProcessingRecipe) {
            ProcessingRecipe processRecipe = (ProcessingRecipe)recipe;
            boolean matchItem = true;
            NonNullList ingredients = processRecipe.m_7527_();
            if (!ingredients.isEmpty()) {
                ArrayList<Integer> toExclude = new ArrayList<Integer>();
                block0: for (Ingredient item : ingredients) {
                    MeltingInventory inv = be.foundry.getInventory();
                    for (int i = 0; i < inv.getSlots(); ++i) {
                        if (toExclude.contains(i) || !item.test(inv.getSlot(i).getStack())) continue;
                        toExclude.add(i);
                        continue block0;
                    }
                    matchItem = false;
                }
            }
            return FoundryRecipe.fluidMatch(be, recipe) && matchItem;
        }
        return false;
    }

    public static boolean fluidMatch(CrucibleBlockEntity be, Recipe<?> recipe) {
        if (recipe instanceof ProcessingRecipe) {
            ProcessingRecipe processRecipe = (ProcessingRecipe)recipe;
            NonNullList fluidIngredients = processRecipe.getFluidIngredients();
            if (!fluidIngredients.isEmpty()) {
                block0: for (FluidIngredient fluidIngredient : fluidIngredients) {
                    for (FluidStack fluid : be.getTank().fluids) {
                        if (!fluidIngredient.test(fluid) || fluidIngredient.getRequiredAmount() > fluid.getAmount()) continue;
                        continue block0;
                    }
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean matchSpecific(ItemStack stack, Recipe<?> recipe) {
        if (recipe instanceof ProcessingRecipe) {
            ProcessingRecipe processRecipe = (ProcessingRecipe)recipe;
            return ((Ingredient)processRecipe.m_7527_().get(0)).test(stack);
        }
        return false;
    }

    public static boolean isEnoughHeated(CrucibleBlockEntity ladle, ProcessingRecipe<?> recipe) {
        if (recipe == null) {
            return false;
        }
        int currentHeat = ladle.foundry.getCurrentHeat();
        if (recipe instanceof FoundryRecipe) {
            FoundryRecipe foundryRecipe = (FoundryRecipe)recipe;
            return currentHeat >= foundryRecipe.getMinHeat() && currentHeat <= foundryRecipe.getMaxHeat();
        }
        return currentHeat >= FoundryRecipe.getHeatRequirement(recipe);
    }

    public static int getHeatRequirement(ProcessingRecipe<?> recipe) {
        if (recipe == null) {
            return 0;
        }
        return switch (recipe.getRequiredHeat()) {
            default -> throw new IncompatibleClassChangeError();
            case HeatCondition.NONE -> 0;
            case HeatCondition.HEATED -> 2;
            case HeatCondition.SUPERHEATED -> 3;
        };
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 1;
    }

    protected int getMaxFluidInputCount() {
        return 10;
    }

    protected int getMaxFluidOutputCount() {
        return 10;
    }

    public boolean matches(SmartInventory pContainer, Level pLevel) {
        return false;
    }

    public int getMaxHeat() {
        return this.maxHeat;
    }

    public int getMinHeat() {
        return this.minHeat;
    }

    public void readAdditional(JsonObject json) {
        super.readAdditional(json);
        this.maxHeat = GsonHelper.m_13824_((JsonObject)json, (String)"maxHeatRequirement", (int)50);
        this.minHeat = GsonHelper.m_13824_((JsonObject)json, (String)"minHeatRequirement", (int)-50);
    }

    public void writeAdditional(JsonObject json) {
        super.writeAdditional(json);
        json.addProperty("maxHeatRequirement", (Number)this.maxHeat);
        json.addProperty("minHeatRequirement", (Number)this.minHeat);
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        super.readAdditional(buffer);
        this.maxHeat = buffer.readInt();
        this.minHeat = buffer.readInt();
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        super.writeAdditional(buffer);
        buffer.writeInt(this.maxHeat);
        buffer.writeInt(this.minHeat);
    }
}

