/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.light_bulb.network;

import fr.lucreeper74.createmetallurgy.CreateMetallurgy;
import fr.lucreeper74.createmetallurgy.content.blocks.light_bulb.network.INetworkNode;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.level.Level;

public class Network {
    public final Set<INetworkNode> nodes = new HashSet<INetworkNode>();
    final Level level;

    public Network(Level level) {
        this.level = level;
    }

    public void addNode(INetworkNode actor) {
        this.nodes.add(actor);
    }

    public void removeNode(INetworkNode actor) {
        this.nodes.remove(actor);
        if (this.nodes.isEmpty()) {
            CreateMetallurgy.NETWORK_HANDLER.networkList.remove(actor.getAddress());
        }
    }

    public void transmit(INetworkNode actor) {
        int power = 0;
        for (INetworkNode other : this.nodes) {
            if (!other.isAlive() || power >= 15) continue;
            power = Math.max(other.getTransmittedSignal(), power);
        }
        for (INetworkNode node : this.nodes) {
            node.setReceivedSignal(power);
        }
    }
}

