/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.tom.createores.block.MultiblockPart;
import com.tom.createores.block.entity.MultiblockCapHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class KineticInputBlockEntity
extends KineticBlockEntity
implements MultiblockCapHandler.Kinetic {
    private float reqStress = 1.0f;

    public KineticInputBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public float calculateStressApplied() {
        this.lastStressApplied = this.reqStress;
        return this.reqStress;
    }

    public float calculateAddedStressCapacity() {
        return 0.0f;
    }

    public void initialize() {
        BlockEntity te;
        MultiblockPart d;
        super.initialize();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        BlockPos pos = this.f_58858_;
        for (int i = 0; i < 5 && state.m_60734_() instanceof MultiblockPart.MultiblockGhostPart; ++i) {
            Direction d2 = ((MultiblockPart.MultiblockGhostPart)state.m_60734_()).getParentDir(state);
            pos = pos.m_5484_(d2, 1);
            state = this.f_58857_.m_8055_(pos);
        }
        if (state.m_60734_() instanceof MultiblockPart && !((d = (MultiblockPart)state.m_60734_()) instanceof MultiblockPart.MultiblockGhostPart) && (te = this.f_58857_.m_7702_(pos)) instanceof MultiblockCapHandler) {
            ((MultiblockCapHandler)te).addKinetic(this);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        BlockPos pos = this.f_58858_;
        for (int i = 0; i < 5 && state.m_60734_() instanceof MultiblockPart.MultiblockGhostPart; ++i) {
            Direction d = ((MultiblockPart.MultiblockGhostPart)state.m_60734_()).getParentDir(state);
            pos = pos.m_5484_(d, 1);
            state = this.f_58857_.m_8055_(pos);
        }
        if (state.m_60734_() instanceof MultiblockPart) {
            MultiblockPart d = (MultiblockPart)state.m_60734_();
            if (d instanceof MultiblockPart.MultiblockGhostPart) {
                return added;
            }
            BlockEntity te = this.f_58857_.m_7702_(pos);
            if (te instanceof MultiblockCapHandler) {
                return ((MultiblockCapHandler)te).addToGoggleTooltip(tooltip, isPlayerSneaking) || added;
            }
            return added;
        }
        return added;
    }

    @Override
    public void setStress(float stress) {
        this.reqStress = stress;
        if (this.lastStressApplied != stress && this.hasNetwork()) {
            this.getOrCreateNetwork().updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
            this.networkDirty = true;
            this.notifyUpdate();
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128350_("reqStress", this.reqStress);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.reqStress = compound.m_128457_("reqStress");
    }

    @Override
    public float getRotationSpeed() {
        if (this.overStressed || this.lastStressApplied != this.reqStress) {
            return 0.0f;
        }
        return Math.abs(this.speed);
    }
}

