/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.item.TooltipHelper;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIndicator;
import de.mrjulsen.crn.client.gui.widgets.DLCreateTextBox;
import de.mrjulsen.crn.client.gui.widgets.DLNewListBox;
import de.mrjulsen.crn.client.gui.widgets.ModStationSuggestions;
import de.mrjulsen.crn.client.gui.widgets.ModernVerticalScrollBar;
import de.mrjulsen.crn.data.schedule.instruction.PrioritizedDestinationInstruction;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.StringUtils;

public class PrioritizedDestinationInstructionSettingsScreen
extends DLScreen {
    private static final MutableComponent TITLE = TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.prioritized_destination_instruction.settings");
    private static final ItemStack DISPLAY_ITEM = new ItemStack((ItemLike)AllItems.SCHEDULE.get());
    private static final int GUI_WIDTH = 250;
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private static final CreateDynamicWidgets.FooterSize headerSize = CreateDynamicWidgets.FooterSize.DEFAULT;
    private static final CreateDynamicWidgets.FooterSize footerSize = CreateDynamicWidgets.FooterSize.EXTENDED;
    private static final int GUI_HEIGHT = 200;
    private int guiLeft;
    private int guiTop;
    private GuiAreaDefinition workingArea;
    private DLCreateIconButton backButton;
    private ModStationSuggestions destinationSuggestions;
    private DLNewListBox<String, DestinationEntry> listBox;
    private DLCreateIconButton addBtn;
    private DLCreateTextBox addTextBox;
    private DLCreateIconButton avoidSignalsButton;
    private DLCreateIndicator avoidSignalsIndicator;
    private DLCreateIconButton avoidTrainsButton;
    private DLCreateIndicator avoidTrainsIndicator;
    private final Map<IconButton, Pair<Component, Component>> toggleButtonTooltips = new LinkedHashMap<IconButton, Pair<Component, Component>>();
    private final WidgetsCollection toggleButtons = new WidgetsCollection();
    private final Screen lastScreen;
    private final PrioritizedDestinationInstruction instruction;
    private final CompoundTag nbt;
    private final List<String> stationFilters = new ArrayList<String>();
    private boolean shouldAvoidSignals;
    private boolean shouldAvoidTrains;
    private final List<String> stationNames = new ArrayList<String>();
    private final MutableComponent txtAvoidSignalsTitle = TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.prioritized_destination_instruction.settings.avoid_signals");
    private final MutableComponent txtAvoidSignalsDescription = TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.prioritized_destination_instruction.settings.avoid_signals_description").m_130940_(ChatFormatting.GRAY);
    private final MutableComponent txtAvoidTrainsTitle = TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.prioritized_destination_instruction.settings.avoid_trains");
    private final MutableComponent txtAvoidTrainsDescription = TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.prioritized_destination_instruction.settings.avoid_trains_description").m_130940_(ChatFormatting.GRAY);

    public PrioritizedDestinationInstructionSettingsScreen(Screen lastScreen, PrioritizedDestinationInstruction instruction, CompoundTag nbt) {
        super((Component)TITLE);
        this.instruction = instruction;
        this.lastScreen = lastScreen;
        this.nbt = nbt;
        this.stationFilters.addAll(nbt.m_128437_("Filters", 8).stream().map(x -> x.m_7916_()).toList());
        this.shouldAvoidSignals = nbt.m_128441_("AvoidRedSignal") ? nbt.m_128471_("AvoidRedSignal") : true;
        this.shouldAvoidTrains = nbt.m_128441_("AvoidTrains") ? nbt.m_128471_("AvoidTrains") : true;
    }

    public void m_7379_() {
        ListTag list = new ListTag();
        Iterator i = this.stationFilters.stream().limit(20L).iterator();
        while (i.hasNext()) {
            list.add((Object)StringTag.m_129297_((String)((String)i.next())));
        }
        this.nbt.m_128365_("Filters", (Tag)list);
        this.nbt.m_128379_("AvoidRedSignal", this.shouldAvoidSignals);
        this.nbt.m_128379_("AvoidTrains", this.shouldAvoidTrains);
        super.m_7379_();
        Minecraft.m_91087_().m_91152_(this.lastScreen);
    }

    public void m_86600_() {
        super.m_86600_();
        DLUtils.doIfNotNull((Object)this.destinationSuggestions, x -> {
            x.tick();
            if (!this.destinationSuggestions.getEditBox().m_94204_()) {
                this.clearSuggestions();
            }
        });
        this.toggleButtons.performForEachOfType(IconButton.class, x -> {
            if (!this.toggleButtonTooltips.containsKey(x)) {
                return;
            }
            x.setToolTip((Component)this.toggleButtonTooltips.get(x).getFirst());
            x.getToolTip().add(TooltipHelper.holdShift((FontHelper.Palette)FontHelper.Palette.YELLOW, (boolean)PrioritizedDestinationInstructionSettingsScreen.m_96638_()));
            if (PrioritizedDestinationInstructionSettingsScreen.m_96638_()) {
                x.getToolTip().add((Component)this.toggleButtonTooltips.get(x).getSecond());
            }
        });
    }

    protected void m_7856_() {
        super.m_7856_();
        this.toggleButtons.clear();
        this.toggleButtonTooltips.clear();
        DataAccessor.getFromServer(null, ModAccessorTypes.GET_ALL_STATION_NAMES, names -> {
            this.stationNames.clear();
            this.stationNames.addAll((Collection<String>)names);
        });
        this.guiLeft = this.f_96543_ / 2 - 125;
        this.guiTop = this.f_96544_ / 2 - 100;
        this.workingArea = new GuiAreaDefinition(this.guiLeft + 3, this.guiTop + headerSize.size() + 1, 244, 200 - headerSize.size() - footerSize.size() - 2);
        ModernVerticalScrollBar scrollBar = new ModernVerticalScrollBar((Screen)this, this.workingArea.getRight() - 5, this.workingArea.getY(), this.workingArea.getHeight(), GuiAreaDefinition.empty());
        this.listBox = (DLNewListBox)this.m_142416_((GuiEventListener)new DLNewListBox((Screen)this, this.workingArea.getX() + 33, this.workingArea.getY() + 40, 178, this.workingArea.getHeight() - 40, (DLAbstractScrollBar<?>)scrollBar));
        this.addTextBox = (DLCreateTextBox)this.m_142416_((GuiEventListener)new DLCreateTextBox(this.f_96547_, this.workingArea.getX() + 63, this.workingArea.getY() + 9, 118, (Component)TextUtils.empty()));
        this.addTextBox.m_94151_(b -> {
            this.updateEditorSubwidgets((EditBox)this.addTextBox);
            this.addBtn.set_active(this.canAddMore() && this.addTextBox.m_94155_() != null && !this.addTextBox.m_94155_().isBlank());
        });
        this.addTextBox.m_94153_(s -> StringUtils.countMatches((CharSequence)s, (char)'*') <= 3);
        this.addTooltip(DLTooltip.of(this.instruction.getSecondLineTooltip(0).stream().map(x -> x).toList()).assignedTo((AbstractWidget)this.addTextBox));
        this.addBtn = (DLCreateIconButton)this.m_142416_((GuiEventListener)((DLCreateIconButton)new DLCreateIconButton(this.workingArea.getX() + 185, this.workingArea.getY() + 9, (ScreenElement)ModGuiIcons.ADD.getAsCreateIcon()).withCallback(() -> {
            this.stationFilters.add(this.addTextBox.m_94155_());
            this.addTextBox.m_94144_("");
            this.reloadList();
        })));
        this.addTooltip(DLTooltip.of((FormattedText)Constants.TEXT_ADD).assignedTo((AbstractWidget)this.addBtn));
        this.m_142416_((GuiEventListener)scrollBar);
        this.avoidSignalsButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 7, this.guiTop + 200 - 6 - 18, (ScreenElement)GuiGameElement.of((ItemStack)AllBlocks.TRACK_SIGNAL.asStack())));
        this.avoidSignalsIndicator = (DLCreateIndicator)this.m_142416_((GuiEventListener)new DLCreateIndicator(this.avoidSignalsButton.x(), this.avoidSignalsButton.y() - 6, (Component)TextUtils.empty()));
        this.avoidSignalsIndicator.state = this.shouldAvoidSignals ? Indicator.State.ON : Indicator.State.OFF;
        this.avoidSignalsButton.withCallback(() -> {
            this.shouldAvoidSignals = !this.shouldAvoidSignals;
            this.avoidSignalsIndicator.state = this.shouldAvoidSignals ? Indicator.State.ON : Indicator.State.OFF;
        });
        this.toggleButtons.add((AbstractWidget)this.avoidSignalsButton);
        this.toggleButtonTooltips.put(this.avoidSignalsButton, (Pair<Component, Component>)Pair.of((Object)this.txtAvoidSignalsTitle, (Object)this.txtAvoidSignalsDescription));
        this.avoidTrainsButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 7 + 18, this.guiTop + 200 - 6 - 18, (ScreenElement)GuiGameElement.of((ItemStack)AllBlocks.TRAIN_CONTROLS.asStack())));
        this.avoidTrainsIndicator = (DLCreateIndicator)this.m_142416_((GuiEventListener)new DLCreateIndicator(this.avoidTrainsButton.x(), this.avoidTrainsButton.y() - 6, (Component)TextUtils.empty()));
        this.avoidTrainsIndicator.state = this.shouldAvoidTrains ? Indicator.State.ON : Indicator.State.OFF;
        this.avoidTrainsButton.withCallback(() -> {
            this.shouldAvoidTrains = !this.shouldAvoidTrains;
            this.avoidTrainsIndicator.state = this.shouldAvoidTrains ? Indicator.State.ON : Indicator.State.OFF;
        });
        this.toggleButtons.add((AbstractWidget)this.avoidTrainsButton);
        this.toggleButtonTooltips.put(this.avoidTrainsButton, (Pair<Component, Component>)Pair.of((Object)this.txtAvoidTrainsTitle, (Object)this.txtAvoidTrainsDescription));
        this.backButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 250 - 7 - 18, this.guiTop + 200 - 6 - 18, 18, 18, (ScreenElement)AllIcons.I_CONFIRM));
        this.backButton.withCallback(() -> this.m_7379_());
        DLCreateIconButton helpButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 250 - 17 - 36, this.guiTop + 200 - 6 - 18, 18, 18, (ScreenElement)ModGuiIcons.HELP.getAsCreateIcon()){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Prioritized-Destination-Instruction");
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)Constants.TEXT_HELP).assignedTo((AbstractWidget)helpButton));
        this.reloadList();
    }

    private void reloadList() {
        this.listBox.displayData(this.stationFilters, (list, idx, data) -> new DestinationEntry(this.listBox, idx, (String)data, btn -> {
            this.stationFilters.remove(btn.getIndex());
            this.reloadList();
        }));
        this.addBtn.set_active(this.canAddMore() && this.addTextBox.m_94155_() != null && !this.addTextBox.m_94155_().isBlank());
        this.addTextBox.set_active(this.canAddMore());
        this.addTextBox.m_94186_(this.canAddMore());
    }

    private boolean canAddMore() {
        return this.stationFilters.size() < 20;
    }

    public boolean m_7043_() {
        return false;
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderScreenBackground(graphics);
        CreateDynamicWidgets.renderWindow(graphics, this.guiLeft, this.guiTop, 250, 200, CreateDynamicWidgets.ContainerColor.PURPLE, CreateDynamicWidgets.BarColor.GOLD, CreateDynamicWidgets.BarColor.GRAY, headerSize.size(), footerSize.size(), true);
        CreateDynamicWidgets.renderVerticalSeparator(graphics, this.guiLeft + 250 - 31, this.guiTop + 200 - footerSize.size() + 2, footerSize.size() - 4, CreateDynamicWidgets.BarColor.GRAY);
        CreateDynamicWidgets.renderWidgetInner(graphics, this.workingArea.getX() + 31, this.workingArea.getY(), 182, this.workingArea.getHeight(), CreateDynamicWidgets.ColorShade.DARK);
        DynamicGuiRenderer.renderArea((Graphics)graphics, (GuiAreaDefinition)new GuiAreaDefinition(this.workingArea.getX() + 41, this.workingArea.getY() + 9, 18, 18), (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
        GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.workingArea.getX() + 63), (int)(this.workingArea.getY() + 28), (String)String.format("%s / %s", this.stationFilters.size(), (byte)20), (int)-6381922, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 6), (int)(this.guiTop + 4), (FormattedText)TITLE, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
        GuiGameElement.of((ItemStack)AllBlocks.TRACK_STATION.asStack()).at((float)(this.workingArea.getX() + 42), (float)(this.workingArea.getY() + 10)).render(graphics.graphics());
        GuiUtils.drawTexture((ResourceLocation)CRNGui.GUI, (Graphics)graphics, (int)(this.guiLeft + 250 - 3), (int)(this.guiTop + 200 - 24), (int)11, (int)18, (int)0, (int)12, (int)64, (int)64);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)DISPLAY_ITEM).at((float)(this.guiLeft + 250 + 11), (float)(this.guiTop + 200 - 48), -200.0f)).scale(4.0).render(graphics.graphics());
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTick);
        this.toggleButtons.performForEach(widget -> {
            IDragonLibWidget dlw;
            AbstractSimiWidget simiWidget;
            if (widget instanceof AbstractSimiWidget && (simiWidget = (AbstractSimiWidget)widget) instanceof IDragonLibWidget && (dlw = (IDragonLibWidget)simiWidget).isMouseSelected()) {
                List tooltip = simiWidget.getToolTip();
                if (tooltip.isEmpty()) {
                    return;
                }
                int ttx = simiWidget.lockedTooltipX == -1 ? mouseX : simiWidget.lockedTooltipX + simiWidget.m_252754_();
                int tty = simiWidget.lockedTooltipY == -1 ? mouseY : simiWidget.lockedTooltipY + simiWidget.m_252907_();
                graphics.graphics().m_280666_(this.f_96547_, tooltip, ttx, tty);
            }
        });
        DLUtils.doIfNotNull((Object)this.destinationSuggestions, x -> x.render(graphics.graphics(), mouseX, mouseY));
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseClicked((int)pMouseX, (int)pMouseY, pButton)) {
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseScrolled(pMouseX, pMouseY, Mth.m_14008_((double)pDelta, (double)-1.0, (double)1.0))) {
            return true;
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public void updateEditorSubwidgets(EditBox field) {
        this.clearSuggestions();
        this.destinationSuggestions = new ModStationSuggestions(Minecraft.m_91087_(), (Screen)this, field, this.f_96547_, this.getViableStations(this.stationNames, field), field.m_93694_() + 2 + field.m_252907_());
        this.destinationSuggestions.setAllowSuggestions(true);
        this.destinationSuggestions.updateCommandInfo();
    }

    private List<String> getViableStations(Collection<String> src, EditBox field) {
        return src.stream().distinct().sorted((a, b) -> a.compareTo((String)b)).toList();
    }

    private void clearSuggestions() {
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.getEditBox().m_94167_("");
        }
        this.destinationSuggestions = null;
    }

    private static class DestinationEntry
    extends DLNewListBox.Entry<String, DestinationEntry> {
        private final MutableComponent txtDragNDrop = TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.prioritized_destination_instruction.settings.drag_and_drop");
        private final MutableComponent txtPriorities = TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.prioritized_destination_instruction.settings.priorities").m_130940_(ChatFormatting.GRAY);
        private final Function<Integer, MutableComponent> txtPriority = i -> TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.prioritized_destination_instruction.settings.priority_pos", (Object[])new Object[]{i}).m_130940_(ChatFormatting.DARK_GRAY);
        private final DLIconButton deleteBtn;

        protected DestinationEntry(DLNewListBox<String, DestinationEntry> list, int index, String data, Consumer<DestinationEntry> onDelete) {
            super(list, index, data, 20);
            this.deleteBtn = (DLIconButton)this.addRenderableWidget((GuiEventListener)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, ModGuiIcons.DELETE.getAsSprite(16, 16), this.x() + list.width() - 26, this.y() + 1, (Component)TextUtils.empty(), btn -> onDelete.accept(this)));
            this.deleteBtn.setBackColor(0);
        }

        @Override
        public void renderItem(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderItem(graphics, mouseX, mouseY, partialTicks);
            CreateDynamicWidgets.renderTextSlotOverlay(graphics, this.x + 30, this.y + 1, 118, 18);
            CreateDynamicWidgets.renderGrabber(graphics, this.x + 8, this.y + 2);
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.x + 30 + 5), (int)(this.y + 6), (String)((String)this.getData()), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
        }

        public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
            if (!this.getList().getParent().m_7282_()) {
                GuiUtils.renderTooltip((Screen)this.getList().getParent(), (AbstractWidget)this.deleteBtn, List.of(Constants.TEXT_REMOVE), (int)200, (Graphics)graphics, (int)mouseX, (int)mouseY);
                if (this.isMouseSelected() && mouseX > this.x() + 4 && mouseX < this.x() + 20) {
                    GuiUtils.renderTooltip((Screen)this.getList().getParent(), (GuiAreaDefinition)GuiAreaDefinition.of((Screen)this.getList().getParent()), List.of(this.txtDragNDrop, this.txtPriorities, this.txtPriority.apply(this.getIndex() + 1)), (int)200, (Graphics)graphics, (int)mouseX, (int)mouseY);
                }
            }
        }
    }
}

