/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.navigation;

import com.google.common.collect.ImmutableList;
import de.mrjulsen.crn.data.navigation.RoutePart;
import de.mrjulsen.crn.data.train.TrainState;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.util.IListenable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class TransferConnection
implements AutoCloseable,
IListenable<TransferConnection> {
    public static final String EVENT_CONNECTION_ENDANGERED = "connection_endangered";
    public static final String EVENT_CONNECTION_MISSED = "connection_missed";
    private final Map<String, IdentityHashMap<Object, Consumer<TransferConnection>>> listeners = new HashMap<String, IdentityHashMap<Object, Consumer<TransferConnection>>>();
    private final TrainStop arrival;
    private final TrainStop departure;
    private boolean isPossible = true;
    private boolean wasConnectionEndangered = false;
    private boolean wasConnectionMissed = false;

    public TransferConnection(TrainStop arrival, TrainStop departure) {
        this.arrival = arrival;
        this.departure = departure;
        this.createEvent(EVENT_CONNECTION_ENDANGERED);
        this.createEvent(EVENT_CONNECTION_MISSED);
    }

    public static ImmutableList<TransferConnection> getConnections(List<RoutePart> parts) {
        ArrayList<TransferConnection> connections = new ArrayList<TransferConnection>();
        for (int i = 0; i < parts.size() - 1; ++i) {
            connections.add(new TransferConnection(parts.get(i).getLastStop(), parts.get(i + 1).getFirstStop()));
        }
        return ImmutableList.copyOf(connections);
    }

    public TrainStop getArrivalStation() {
        return this.arrival;
    }

    public TrainStop getDepartureStation() {
        return this.departure;
    }

    public long getScheduledTransferTime() {
        return this.departure.getScheduledDepartureTime() - this.arrival.getScheduledArrivalTime();
    }

    public long getRealTimeTransferTime() {
        return (this.departure.shouldRenderRealTime() ? this.departure.getRealTimeDepartureTime() : this.departure.getScheduledDepartureTime()) - (this.arrival.shouldRenderRealTime() ? this.arrival.getRealTimeArrivalTime() : this.arrival.getScheduledArrivalTime());
    }

    public boolean isPossible() {
        return this.isPossible;
    }

    public boolean isConnectionEndangered() {
        return !this.isPossible() || this.getRealTimeTransferTime() <= 0L;
    }

    public boolean isConnectionMissed() {
        boolean possible;
        if (!this.isPossible) {
            return true;
        }
        boolean bl = possible = this.arrival.getState() != TrainState.BEFORE || this.departure.getState() != TrainState.AFTER;
        if (!possible) {
            this.isPossible = false;
        }
        return !possible;
    }

    @Override
    public Map<String, IdentityHashMap<Object, Consumer<TransferConnection>>> getListeners() {
        return this.listeners;
    }

    public void update() {
        if (!this.isPossible()) {
            return;
        }
        boolean endangered = this.isConnectionEndangered();
        boolean missed = this.isConnectionMissed();
        if (endangered != this.wasConnectionEndangered) {
            this.notifyListeners(EVENT_CONNECTION_ENDANGERED, this);
        }
        if (missed != this.wasConnectionMissed) {
            this.notifyListeners(EVENT_CONNECTION_MISSED, this);
        }
        this.wasConnectionEndangered = endangered;
        this.wasConnectionMissed = missed;
    }

    @Override
    public void close() {
        this.stopListeningAll(this);
    }
}

