/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.schedule.instruction;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DiscoveredPath;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.data.schedule.INavigationExtension;
import de.mrjulsen.crn.mixin.ScheduleRuntimeAccessor;
import de.mrjulsen.crn.util.PenaltyResult;
import de.mrjulsen.mcdragonlib.data.MapCache;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PrioritizedDestinationInstruction
extends DestinationInstruction {
    public static final String NBT_FILTERS = "Filters";
    public static final String NBT_AVOID_RED_SIGNAL = "AvoidRedSignal";
    public static final String NBT_AVOID_TRAINS = "AvoidTrains";
    public static final byte MAX_ENTRIES = 20;
    public final Component txtIsEmpty = TextUtils.translate((String)("createrailwaysnavigator.schedule.instruction." + this.getId().m_135815_() + ".empty")).m_130940_(ChatFormatting.GRAY);
    public final Component txtPrimary = TextUtils.translate((String)("createrailwaysnavigator.schedule.instruction." + this.getId().m_135815_() + ".primary")).m_130940_(ChatFormatting.AQUA);

    public Pair<ItemStack, Component> getSummary() {
        return Pair.of((Object)AllBlocks.TRACK_STATION.asStack(), (Object)TextUtils.text((String)this.getLabelText()));
    }

    protected void readAdditional(CompoundTag tag) {
        super.readAdditional(tag);
        if (!tag.m_128441_(NBT_AVOID_RED_SIGNAL)) {
            tag.m_128379_(NBT_AVOID_RED_SIGNAL, true);
        }
        if (!tag.m_128441_(NBT_AVOID_TRAINS)) {
            tag.m_128379_(NBT_AVOID_TRAINS, true);
        }
    }

    public List<Component> getTitleAs(String type) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add((Component)TextUtils.translate((String)("createrailwaysnavigator.schedule.instruction." + this.getId().m_135815_() + ".summary")).m_130940_(ChatFormatting.GOLD));
        if (this.data.m_128441_(NBT_FILTERS)) {
            ListTag list = this.data.m_128437_(NBT_FILTERS, 8);
            if (list.isEmpty()) {
                components.add(this.txtIsEmpty);
            }
            for (int i = 0; i < list.size(); ++i) {
                String entry = list.get(i).m_7916_();
                components.add((Component)TextUtils.empty().m_7220_((Component)TextUtils.text((String)String.format("%02d  ", i + 1)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)entry).m_130940_(i <= 0 ? ChatFormatting.WHITE : ChatFormatting.GRAY)).m_7220_((Component)(i <= 0 ? TextUtils.text((String)"  ").m_7220_(this.txtPrimary) : TextUtils.empty())));
            }
        } else {
            components.add(this.txtIsEmpty);
        }
        return components;
    }

    protected String getLabelText() {
        if (this.data.m_128441_(NBT_FILTERS)) {
            return this.data.m_128437_(NBT_FILTERS, 8).stream().findFirst().map(Tag::m_7916_).orElse("");
        }
        return "";
    }

    public boolean supportsConditions() {
        return true;
    }

    public ResourceLocation getId() {
        return new ResourceLocation("createrailwaysnavigator", "prioritized_destination_instruction");
    }

    public ItemStack getSecondLineIcon() {
        return AllBlocks.TRACK_STATION.asStack();
    }

    public boolean shouldAvoidRedSignals() {
        return this.data.m_128471_(NBT_AVOID_RED_SIGNAL);
    }

    public boolean shouldAvoidTrains() {
        return this.data.m_128471_(NBT_AVOID_TRAINS);
    }

    public List<String> getFilters() {
        if (this.data.m_128441_(NBT_FILTERS)) {
            return this.data.m_128437_(NBT_FILTERS, 8).stream().map(Tag::m_7916_).toList();
        }
        return List.of();
    }

    public String getFilter() {
        if (this.data.m_128441_(NBT_FILTERS)) {
            return this.data.m_128437_(NBT_FILTERS, 8).stream().map(Tag::m_7916_).findFirst().orElse("");
        }
        return "";
    }

    protected void modifyEditBox(EditBox box) {
    }

    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        ClientWrapper.initPrioritizedDestinationInstruction(this, builder);
    }

    @Nullable
    public DiscoveredPath start(ScheduleRuntime runtime, Level level) {
        ScheduleRuntimeAccessor accessor = (ScheduleRuntimeAccessor)runtime;
        Train train = accessor.crn$getTrain();
        List<String> filters = this.getFilters();
        List patterns = filters.stream().map(Pattern::compile).collect(Collectors.toList());
        INavigationExtension ext = (INavigationExtension)train.navigation;
        DiscoveredPath selectedDestination = null;
        int selectedPainCount = Integer.MAX_VALUE;
        boolean anyMatch = false;
        MapCache navigationCache = new MapCache(station -> train.navigation.findPathTo(station, Double.MAX_VALUE), Object::hashCode);
        if (!train.hasForwardConductor() && !train.hasBackwardConductor()) {
            train.status.missingConductor();
            accessor.crn$setCooldown(accessor.crn$getInterval());
            return null;
        }
        for (Pattern regex : patterns) {
            AtomicInteger painCount = new AtomicInteger(0);
            GlobalStation bestStation = null;
            DiscoveredPath bestPath = null;
            double bestCost = Double.MAX_VALUE;
            for (GlobalStation globalStation : train.graph.getPoints(EdgePointType.STATION)) {
                DiscoveredPath discoveredPath;
                if (!regex.matcher(globalStation.name).matches() || (discoveredPath = (DiscoveredPath)navigationCache.get((Object)globalStation, (Object)globalStation)) == null || discoveredPath.cost < 0.0 || discoveredPath.cost > bestCost) continue;
                bestStation = globalStation;
                bestPath = discoveredPath;
                bestCost = discoveredPath.cost;
            }
            if (bestStation == null) continue;
            anyMatch = true;
            if (this.shouldAvoidTrains() && (bestStation.getImminentTrain() != null && bestStation.getImminentTrain() != train || bestStation.getPresentTrain() != null && bestStation.getPresentTrain() != train || bestStation.getNearestTrain() != null && bestStation.getNearestTrain() != train)) {
                painCount.addAndGet(1);
            }
            ext.getPenaltiesByDirection().ifPresent(x -> {
                for (PenaltyResult.Type type : x.getPenalties().keySet()) {
                    if (this.shouldAvoidRedSignals() && type == PenaltyResult.Type.REDSTONE_RED_SIGNAL) {
                        painCount.addAndGet(1);
                        continue;
                    }
                    if (!this.shouldAvoidTrains() || type.getCategory() != PenaltyResult.Category.TRAINS && type != PenaltyResult.Type.RED_SIGNAL) continue;
                    painCount.addAndGet(1);
                }
            });
            if (painCount.get() >= selectedPainCount) continue;
            selectedPainCount = painCount.get();
            selectedDestination = bestPath;
            if (painCount.get() > 0) continue;
            break;
        }
        if (selectedDestination == null) {
            if (anyMatch) {
                train.status.failedNavigation();
            } else {
                train.status.failedNavigationNoTarget(String.join((CharSequence)", ", filters));
            }
            accessor.crn$setCooldown(accessor.crn$getInterval());
            return null;
        }
        return selectedDestination;
    }
}

