/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter;

import com.oierbravo.createsifter.ModRecipeTypes;
import com.oierbravo.createsifter.foundation.data.recipe.ModProcessingRecipeGen;
import com.oierbravo.createsifter.ponders.ModPonderPlugin;
import com.oierbravo.createsifter.register.ModBlockEntities;
import com.oierbravo.createsifter.register.ModBlocks;
import com.oierbravo.createsifter.register.ModConfigs;
import com.oierbravo.createsifter.register.ModCreativeTabs;
import com.oierbravo.createsifter.register.ModItems;
import com.oierbravo.createsifter.register.ModPartials;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="createsifter")
public class CreateSifter {
    public static final String MODID = "createsifter";
    public static final String DISPLAY_NAME = "Create Sifter";
    private static final Logger LOGGER = LogManager.getLogger((String)"createsifter");
    public static IEventBus modEventBus;
    public static final CreateRegistrate REGISTRATE;

    public CreateSifter() {
        modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        REGISTRATE.registerEventListeners(modEventBus);
        ModConfigs.register();
        ModBlocks.register();
        ModItems.register();
        ModBlockEntities.register();
        ModCreativeTabs.register(modEventBus);
        ModRecipeTypes.register(modEventBus);
        modEventBus.addListener(this::doClientStuff);
        this.generateLangEntries();
        modEventBus.addListener(EventPriority.LOWEST, CreateSifter::gatherData);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ModPartials::init);
    }

    private void generateLangEntries() {
        CreateSifter.registrate().addRawLang("createsifter.recipe.sifting", "Sifting recipe");
        CreateSifter.registrate().addRawLang("create.recipe.sifting", "Sifting recipe");
        CreateSifter.registrate().addRawLang("createsifter.recipe.sifting.minimumspeed", "%1$s RPM");
        CreateSifter.registrate().addRawLang("createsifter.recipe.sifting.waterlogged", "Waterlogged");
        CreateSifter.registrate().addRawLang("itemGroup.createsifter:main", "Create sifting");
        CreateSifter.registrate().addRawLang("config.jade.plugin_createsifter.sifter_data", "Create Sifting data");
        CreateSifter.registrate().addRawLang("createsifter.ponder.sifter.header", "Block sifting");
        CreateSifter.registrate().addRawLang("createsifter.ponder.sifter.text_1", "Sifter process items by sifting them");
        CreateSifter.registrate().addRawLang("createsifter.ponder.sifter.text_2", "They can be powered from the side using cogwheels");
        CreateSifter.registrate().addRawLang("createsifter.ponder.sifter.text_3", "Throw or Insert items at the top");
        CreateSifter.registrate().addRawLang("createsifter.ponder.sifter.text_4", "After some time, the result can be obtained via Right-click");
        CreateSifter.registrate().addRawLang("createsifter.ponder.sifter.text_5", "The outputs can also be extracted by automation");
        CreateSifter.registrate().addRawLang("createsifter.recipe.sifting.brass_required", "Brass sifter required");
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        if (event.includeClient()) {
            // empty if block
        }
        if (event.includeServer()) {
            ModProcessingRecipeGen.registerAll(gen, output);
        }
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        PonderIndex.addPlugin((PonderPlugin)new ModPonderPlugin());
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MODID, path);
    }

    static {
        REGISTRATE = CreateRegistrate.create((String)MODID);
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

