/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.compat.jei.category;

import com.oierbravo.createsifter.compat.jei.category.animations.AnimatedBrassSifter;
import com.oierbravo.createsifter.compat.jei.category.animations.AnimatedSifter;
import com.oierbravo.createsifter.content.contraptions.components.sifter.SiftingRecipe;
import com.oierbravo.createsifter.foundation.gui.ModGUITextures;
import com.oierbravo.createsifter.foundation.util.ModLang;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.material.Fluids;

public class SiftingCategory
extends CreateRecipeCategory<SiftingRecipe> {
    public SiftingCategory(CreateRecipeCategory.Info<SiftingRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SiftingRecipe recipe, IFocusGroup focuses) {
        List<ProcessingOutput> results;
        builder.addSlot(RecipeIngredientRole.INPUT, 15, 9).setBackground(SiftingCategory.getRenderedSlot(), -1, -1).addIngredients(recipe.getSiftableIngredient());
        if (!recipe.getMeshIngredient().m_43947_()) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 15, 24).setBackground(SiftingCategory.getRenderedSlot(), -1, -1).addIngredients(recipe.getMeshIngredient());
        }
        if (recipe.isWaterlogged()) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 15, 42).setBackground(SiftingCategory.getRenderedSlot(), -1, -1).addFluidStack(Fluids.f_76193_.m_5613_(), 1000L);
        }
        boolean single = (results = recipe.getRollableResults()).size() == 1;
        int i = 0;
        for (ProcessingOutput output : results) {
            int xOffset = i % 4 * 19;
            int yOffset = i / 4 * 19;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, single ? 139 : 100 + xOffset, 2 + yOffset).setBackground(SiftingCategory.getRenderedSlot((ProcessingOutput)output), -1, -1).addItemStack(output.getStack())).addRichTooltipCallback(SiftingCategory.addStochasticTooltip((ProcessingOutput)output));
            ++i;
        }
    }

    public void draw(SiftingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        boolean single;
        List<ProcessingOutput> results = recipe.getRollableResults();
        boolean bl = single = results.size() == 1;
        if (single) {
            AllGuiTextures.JEI_ARROW.render(graphics, 85, 32);
        } else {
            ModGUITextures.JEI_SHORT_ARROW.render(graphics, 75, 32);
        }
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 43, 2);
        this.drawSifter(graphics, recipe.requiresAdvancedMesh(), recipe.isWaterlogged());
        NonNullList requirements = NonNullList.m_122779_();
        if (recipe.isWaterlogged()) {
            requirements.add((Object)ModLang.translate("recipe.sifting.waterlogged", new Object[0]).component());
        }
        if (recipe.hasSpeedRequeriment()) {
            requirements.add((Object)ModLang.translate("recipe.sifting.minimumspeed", Float.valueOf(recipe.getSpeedRequeriment())).component());
        }
        if (recipe.requiresAdvancedMesh()) {
            requirements.add((Object)ModLang.translate("recipe.sifting.brass_required", new Object[0]).component());
        }
        this.drawRequirements(graphics, (NonNullList<MutableComponent>)requirements);
    }

    protected void drawSifter(GuiGraphics guiGraphics, boolean pAdvanced, boolean waterlogged) {
        int x = 48;
        int y = 27;
        if (pAdvanced) {
            AnimatedBrassSifter brassSifter = new AnimatedBrassSifter();
            brassSifter.waterlogged(waterlogged);
            brassSifter.draw(guiGraphics, x, y);
            return;
        }
        AnimatedSifter sifter = new AnimatedSifter();
        sifter.waterlogged(waterlogged);
        sifter.draw(guiGraphics, x, y);
    }

    protected void drawRequirements(GuiGraphics guiGraphics, NonNullList<MutableComponent> requirements) {
        int startX = 41;
        int startY = 56;
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        for (int index = 0; index < requirements.size(); ++index) {
            guiGraphics.m_280614_(fontRenderer, (Component)requirements.get(index), startX, startY + 15 * index, -8355712, false);
        }
    }
}

