/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.compat.kubejs;

import com.google.gson.JsonObject;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.BooleanComponent;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.TimeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import net.minecraft.world.item.ItemStack;

public interface SiftingRecipeSchema {
    public static final RecipeKey<InputItem[]> INGREDIENTS = ItemComponents.INPUT_ARRAY.key("ingredients");
    public static final RecipeKey<OutputItem[]> RESULTS = ItemComponents.OUTPUT_ARRAY.key("results");
    public static final RecipeKey<Long> PROCESSING_TIME_REQUIRED = TimeComponent.TICKS.key("processingTime").optional((Object)100L).alwaysWrite();
    public static final RecipeKey<Boolean> WATERLOGGED = BooleanComponent.BOOLEAN.key("waterlogged").optional((Object)false);
    public static final RecipeKey<Float> MINIMUM_SPEED = NumberComponent.FLOAT.key("minimumSpeed").optional((Object)Float.valueOf(1.0f));
    public static final RecipeSchema SIFTING = new RecipeSchema(SiftingRecipeJS.class, SiftingRecipeJS::new, new RecipeKey[]{RESULTS, INGREDIENTS, PROCESSING_TIME_REQUIRED, WATERLOGGED, MINIMUM_SPEED});

    public static class SiftingRecipeJS
    extends RecipeJS {
        public OutputItem readOutputItem(Object from) {
            JsonObject j;
            if (from instanceof ProcessingOutput) {
                ProcessingOutput output = (ProcessingOutput)from;
                return OutputItem.of((ItemStack)output.getStack(), (double)output.getChance());
            }
            OutputItem outputItem = super.readOutputItem(from);
            if (from instanceof JsonObject && (j = (JsonObject)from).has("chance")) {
                return outputItem.withChance((double)j.get("chance").getAsFloat());
            }
            return outputItem;
        }

        public RecipeJS waterlogged() {
            return this.setValue(WATERLOGGED, true);
        }
    }
}

