/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.foundation.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oierbravo.createsifter.content.contraptions.components.sifter.SifterConfig;
import com.oierbravo.createsifter.content.contraptions.components.sifter.SiftingRecipe;
import com.oierbravo.createsifter.content.contraptions.components.sifter.SiftingRecipeSerializer;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.data.SimpleDatagenIngredient;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.tterrag.registrate.util.DataIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.data.Pair;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;

public class SiftingRecipeBuilder {
    protected SiftingRecipeFactory factory;
    protected SiftingRecipeParams params;
    protected List<ICondition> recipeConditions;

    public SiftingRecipeBuilder(SiftingRecipeFactory factory, ResourceLocation recipeId) {
        this.params = new SiftingRecipeParams(recipeId);
        this.recipeConditions = new ArrayList<ICondition>();
        this.factory = factory;
    }

    public SiftingRecipeBuilder withItemIngredients(Ingredient ... ingredients) {
        return this.withItemIngredients((NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients));
    }

    public SiftingRecipeBuilder withItemIngredients(NonNullList<Ingredient> ingredients) {
        this.params.ingredients = ingredients;
        return this;
    }

    public SiftingRecipeBuilder withSingleItemOutput(ItemStack output) {
        return this.withItemOutputs(new ProcessingOutput(output, 1.0f));
    }

    public SiftingRecipeBuilder withItemOutputs(ProcessingOutput ... outputs) {
        return this.withItemOutputs((NonNullList<ProcessingOutput>)NonNullList.m_122783_((Object)ProcessingOutput.EMPTY, (Object[])outputs));
    }

    public SiftingRecipeBuilder withItemOutputs(NonNullList<ProcessingOutput> outputs) {
        this.params.results = outputs;
        return this;
    }

    public SiftingRecipeBuilder duration(int ticks) {
        this.params.processingDuration = ticks;
        return this;
    }

    public SiftingRecipeBuilder averageProcessingDuration() {
        return this.duration(100);
    }

    public SiftingRecipeBuilder waterlogged(boolean value) {
        this.params.waterlogged = value;
        return this;
    }

    public SiftingRecipeBuilder isWaterlogged() {
        this.params.waterlogged = true;
        return this;
    }

    public SiftingRecipeBuilder minimumSpeed(float speed) {
        this.params.minimumSpeed = speed;
        return this;
    }

    public SiftingRecipeBuilder require(TagKey<Item> tag) {
        return this.require(Ingredient.m_204132_(tag));
    }

    public SiftingRecipeBuilder require(ItemLike item) {
        return this.require(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public SiftingRecipeBuilder require(Ingredient ingredient) {
        this.params.ingredients.add((Object)ingredient);
        return this;
    }

    public SiftingRecipeBuilder require(Mods mod, String id) {
        this.params.ingredients.add((Object)new SimpleDatagenIngredient(mod, id));
        return this;
    }

    public SiftingRecipeBuilder require(ResourceLocation ingredient) {
        this.params.ingredients.add((Object)DataIngredient.ingredient(null, (ResourceLocation)ingredient, (ItemPredicate[])new ItemPredicate[0]));
        return this;
    }

    public SiftingRecipeBuilder output(ItemLike item) {
        return this.output(item, 1);
    }

    public SiftingRecipeBuilder output(float chance, ItemLike item) {
        return this.output(chance, item, 1);
    }

    public SiftingRecipeBuilder output(ItemLike item, int amount) {
        return this.output(1.0f, item, amount);
    }

    public SiftingRecipeBuilder output(float chance, ItemLike item, int amount) {
        return this.output(chance, new ItemStack(item, amount));
    }

    public SiftingRecipeBuilder output(ItemStack output) {
        return this.output(1.0f, output);
    }

    public SiftingRecipeBuilder output(float chance, ItemStack output) {
        return this.output(new ProcessingOutput(output, chance));
    }

    public SiftingRecipeBuilder output(float chance, Mods mod, String id, int amount) {
        return this.output(new ProcessingOutput(Pair.of((Object)mod.asResource(id), (Object)amount), chance));
    }

    public SiftingRecipeBuilder output(float chance, ResourceLocation registryName, int amount) {
        return this.output(new ProcessingOutput(Pair.of((Object)registryName, (Object)amount), chance));
    }

    public SiftingRecipeBuilder output(ProcessingOutput output) {
        this.params.results.add((Object)output);
        return this;
    }

    public SiftingRecipeBuilder whenModLoaded(String modid) {
        return this.withCondition((ICondition)new ModLoadedCondition(modid));
    }

    public SiftingRecipeBuilder whenModMissing(String modid) {
        return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
    }

    public SiftingRecipeBuilder withCondition(ICondition condition) {
        this.recipeConditions.add(condition);
        return this;
    }

    public SiftingRecipe build() {
        return this.factory.create(this.params);
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new DataGenResult(this.build(), this.recipeConditions));
    }

    public static class SiftingRecipeParams
    extends ProcessingRecipeBuilder.ProcessingRecipeParams {
        public ResourceLocation id;
        public NonNullList<Ingredient> ingredients;
        public NonNullList<ProcessingOutput> results;
        public int processingDuration;
        public boolean waterlogged;
        public float minimumSpeed;

        protected SiftingRecipeParams(ResourceLocation id) {
            super(id);
            this.id = id;
            this.ingredients = NonNullList.m_122779_();
            this.results = NonNullList.m_122779_();
            this.processingDuration = 0;
            this.waterlogged = false;
            this.minimumSpeed = ((Double)SifterConfig.SIFTER_MINIMUM_SPEED.get()).floatValue();
        }
    }

    @FunctionalInterface
    public static interface SiftingRecipeFactory {
        public SiftingRecipe create(SiftingRecipeParams var1);
    }

    public static class DataGenResult
    implements FinishedRecipe {
        private List<ICondition> recipeConditions;
        private SiftingRecipeSerializer serializer;
        private ResourceLocation id;
        private SiftingRecipe recipe;

        public DataGenResult(SiftingRecipe recipe, List<ICondition> recipeConditions) {
            this.recipe = recipe;
            this.recipeConditions = recipeConditions;
            IRecipeTypeInfo recipeType = this.recipe.getTypeInfo();
            ResourceLocation typeId = recipeType.getId();
            if (!(recipeType.getSerializer() instanceof SiftingRecipeSerializer)) {
                throw new IllegalStateException("Cannot datagen ProcessingRecipe of type: " + typeId);
            }
            this.id = new ResourceLocation(recipe.m_6423_().m_135827_(), typeId.m_135815_() + "/" + recipe.m_6423_().m_135815_());
            this.serializer = recipe.getSerializer();
        }

        public void m_7917_(JsonObject json) {
            this.serializer.write(json, this.recipe);
            if (this.recipeConditions.isEmpty()) {
                return;
            }
            JsonArray conds = new JsonArray();
            this.recipeConditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            json.add("conditions", (JsonElement)conds);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

