/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.japanese;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.IBlockChain;
import org.dawnoftime.dawnoftime.block.japanese.SmallTatamiFloorBlock;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.registry.DoTBBlocksRegistry;
import org.dawnoftime.dawnoftime.registry.DoTBTags;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class SmallTatamiMatBlock
extends WaterloggedBlock
implements IBlockChain {
    public static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.f_61364_;
    public static final BooleanProperty ATTACHED = BlockStateProperties.f_61386_;
    public static final BooleanProperty ROLLED = BlockStatePropertiesAA.ROLLED;
    public static final IntegerProperty STACK = BlockStatePropertiesAA.STACK;

    public SmallTatamiMatBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.SMALL_TATAMI_MAT_SHAPES);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ROLLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)STACK, (Comparable)Integer.valueOf(1)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ATTACHED, HORIZONTAL_AXIS, ROLLED, STACK});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)ATTACHED)).booleanValue()) {
            return 7;
        }
        if (((Boolean)state.m_61143_((Property)ROLLED)).booleanValue()) {
            boolean isAxisX = state.m_61143_(HORIZONTAL_AXIS) == Direction.Axis.X;
            return switch ((Integer)state.m_61143_((Property)STACK)) {
                default -> {
                    if (isAxisX) {
                        yield 1;
                    }
                    yield 4;
                }
                case 2 -> {
                    if (isAxisX) {
                        yield 2;
                    }
                    yield 5;
                }
                case 3 -> isAxisX ? 3 : 6;
            };
        }
        return 0;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Level world = context.m_43725_();
        BlockState oldState = world.m_8055_(pos = context.m_8083_());
        if (oldState.m_60734_() == this) {
            int stack = (Integer)oldState.m_61143_((Property)STACK);
            if (((Boolean)oldState.m_61143_((Property)ROLLED)).booleanValue() && !((Boolean)oldState.m_61143_((Property)ATTACHED)).booleanValue() && stack < 3) {
                return (BlockState)oldState.m_61124_((Property)STACK, (Comparable)Integer.valueOf(stack + 1));
            }
        }
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)ROLLED, (Comparable)Boolean.valueOf(world.m_8055_(pos.m_7495_()).m_204336_(DoTBTags.INSTANCE.COVERED_BLOCKS)))).m_61124_(HORIZONTAL_AXIS, (Comparable)context.m_8125_().m_122434_());
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)ATTACHED)).booleanValue()) {
            BlockState stateUp = worldIn.m_8055_(pos.m_7494_());
            Block blockUp = stateUp.m_60734_();
            if (stateUp.m_204336_(BlockTags.f_13039_) || worldIn.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13039_)) {
                return true;
            }
            if (IBlockChain.canBeChained(stateUp, true)) {
                return true;
            }
        }
        return !worldIn.m_46859_(pos.m_7495_());
    }

    @Override
    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (facing.m_122434_().m_122478_()) {
            BlockState stateUp;
            if (((Boolean)(stateIn = (BlockState)stateIn.m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).m_61143_((Property)ROLLED)).booleanValue() && (Integer)stateIn.m_61143_((Property)STACK) == 1 && ((stateUp = worldIn.m_8055_(currentPos.m_7494_())).m_204336_(BlockTags.f_13039_) || worldIn.m_8055_(currentPos.m_7495_()).m_204336_(BlockTags.f_13039_) || IBlockChain.canBeChained(stateUp, true))) {
                stateIn = (BlockState)stateIn.m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(true));
            }
            if (!stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
                return Blocks.f_50016_.m_49966_();
            }
        }
        return stateIn;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockState newState = this.tryMergingWithSprucePlanks(state, (LevelAccessor)worldIn, pos);
        if (newState.m_60734_() == Blocks.f_50016_) {
            worldIn.m_7731_(pos, newState, 10);
        }
    }

    private BlockState tryMergingWithSprucePlanks(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)ROLLED)).booleanValue()) {
            return state;
        }
        Block blockDown = worldIn.m_8055_(pos.m_7495_()).m_60734_();
        if (blockDown == Blocks.f_50741_) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
            BlockState floorState = (BlockState)DoTBBlocksRegistry.INSTANCE.SMALL_TATAMI_FLOOR.get().m_49966_().m_61124_(SmallTatamiFloorBlock.HORIZONTAL_AXIS, (Comparable)axis);
            worldIn.m_7731_(pos.m_7495_(), floorState, 10);
            return Blocks.f_50016_.m_49966_();
        }
        return (BlockState)state.m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_6047_()) {
            int stack = (Integer)state.m_61143_((Property)STACK);
            boolean isRolled = (Boolean)state.m_61143_((Property)ROLLED);
            if (isRolled && stack == 1 && worldIn.m_8055_(pos.m_7495_()).m_204336_(DoTBTags.INSTANCE.COVERED_BLOCKS)) {
                return InteractionResult.PASS;
            }
            if ((Integer)state.m_61143_((Property)STACK) > 1) {
                state = (BlockState)state.m_61124_((Property)STACK, (Comparable)Integer.valueOf(stack - 1));
                Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)this.m_5456_()));
            } else {
                state = (BlockState)state.m_61124_((Property)ROLLED, (Comparable)Boolean.valueOf(!isRolled));
            }
            state = this.m_7417_(state, Direction.DOWN, worldIn.m_8055_(pos.m_7495_()), (LevelAccessor)worldIn, pos, pos.m_7495_());
            worldIn.m_7731_(pos, state, 10);
            worldIn.m_5594_(player, pos, this.f_60446_.m_56777_(), SoundSource.BLOCKS, (this.f_60446_.m_56773_() + 1.0f) / 2.0f, this.f_60446_.m_56774_() * 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.m_43722_();
        if (itemstack.m_41720_() == this.m_5456_()) {
            if (!((Boolean)state.m_61143_((Property)ROLLED)).booleanValue() || ((Boolean)state.m_61143_((Property)ATTACHED)).booleanValue() || (Integer)state.m_61143_((Property)STACK) == 3) {
                return false;
            }
            return useContext.m_7058_();
        }
        return false;
    }

    @Override
    public boolean canConnectToChainAbove(BlockState state) {
        return (Boolean)state.m_61143_((Property)ATTACHED);
    }

    @Override
    public boolean canConnectToChainUnder(BlockState state) {
        return (Boolean)state.m_61143_((Property)ATTACHED);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_(HORIZONTAL_AXIS, (Comparable)(state.m_61143_(HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, this, new String[0]);
    }
}

