/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.deco_storage.block.entities;

import com.yablon.deco_storage.block.entities.ModBlockEntities;
import com.yablon.deco_storage.recipe.StorageCrafterRecipe;
import com.yablon.deco_storage.screen.StorageCrafterMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageCrafterBlockEntity
extends BlockEntity
implements MenuProvider {
    private int lastOutputCount = 0;
    private boolean isCraftingValid = false;
    private boolean isUpdating = false;
    private final ItemStackHandler itemHandler = new ItemStackHandler(11){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onContentsChanged(int slot) {
            if (StorageCrafterBlockEntity.this.isUpdating) {
                return;
            }
            try {
                StorageCrafterBlockEntity.this.isUpdating = true;
                if (slot < 10) {
                    StorageCrafterBlockEntity.this.updateCraftingResult();
                } else if (slot == 10) {
                    ItemStack outputSlot = this.getStackInSlot(10);
                    int currentOutputCount = outputSlot.m_41613_();
                    if (StorageCrafterBlockEntity.this.isCraftingValid && currentOutputCount < StorageCrafterBlockEntity.this.lastOutputCount && StorageCrafterBlockEntity.this.lastOutputCount > 0) {
                        StorageCrafterBlockEntity.this.consumeResources();
                        StorageCrafterBlockEntity.this.updateCraftingResult();
                    }
                    StorageCrafterBlockEntity.this.lastOutputCount = currentOutputCount;
                }
                StorageCrafterBlockEntity.this.m_6596_();
            }
            finally {
                StorageCrafterBlockEntity.this.isUpdating = false;
            }
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();

    public StorageCrafterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.STORAGE_CRAFTER_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (i == 10) continue;
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.tutorialmod.gem_polishing_station");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new StorageCrafterMenu(pContainerId, pPlayerInventory, this, (ContainerData)new SimpleContainerData(2));
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("inventory")) {
            this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCraftingResult() {
        if (this.isUpdating) {
            return;
        }
        try {
            this.isUpdating = true;
            SimpleContainer simpleContainer = new SimpleContainer(11);
            for (int i = 0; i < 11; ++i) {
                simpleContainer.m_6836_(i, this.itemHandler.getStackInSlot(i));
            }
            Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)StorageCrafterRecipe.Type.INSTANCE, (Container)simpleContainer, this.f_58857_);
            ItemStack currentOutput = this.itemHandler.getStackInSlot(10);
            if (recipe.isPresent()) {
                ItemStack result = ((StorageCrafterRecipe)recipe.get()).m_8043_(this.f_58857_.m_9598_());
                if (currentOutput.m_41619_() || ItemStack.m_150942_((ItemStack)currentOutput, (ItemStack)result) && currentOutput.m_41613_() < result.m_41741_()) {
                    this.itemHandler.setStackInSlot(10, result.m_41777_());
                    this.lastOutputCount = result.m_41613_();
                    this.isCraftingValid = true;
                }
            } else {
                if (!currentOutput.m_41619_()) {
                    this.itemHandler.setStackInSlot(10, ItemStack.f_41583_);
                }
                this.isCraftingValid = false;
            }
        }
        finally {
            this.isUpdating = false;
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StorageCrafterBlockEntity entity) {
        if (!level.f_46443_) {
            entity.updateCraftingResult();
        }
    }

    public void consumeResources() {
        if (!this.isCraftingValid) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stack.m_41774_(1);
            if (!stack.m_41619_()) continue;
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
        ItemStack inputSlot = this.itemHandler.getStackInSlot(9);
        if (!inputSlot.m_41619_()) {
            inputSlot.m_41774_(1);
            if (inputSlot.m_41619_()) {
                this.itemHandler.setStackInSlot(9, ItemStack.f_41583_);
            }
        }
    }
}

