/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.deco_storage.integration.jei;

import com.yablon.deco_storage.integration.jei.StorageCrafterRecipeCategory;
import com.yablon.deco_storage.integration.jei.StorageExtractorRecipeCategory;
import com.yablon.deco_storage.recipe.StorageCrafterRecipe;
import com.yablon.deco_storage.recipe.StorageExtractorRecipe;
import com.yablon.deco_storage.screen.StorageCrafterScreen;
import com.yablon.deco_storage.screen.StorageExtractorScreen;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.fml.ModList;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("deco_storage", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (!this.isJEILoaded()) {
            return;
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new StorageCrafterRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new StorageExtractorRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (!this.isJEILoaded()) {
            return;
        }
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        List recipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)StorageCrafterRecipe.Type.INSTANCE);
        List extractorRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)StorageExtractorRecipe.Type.INSTANCE);
        registration.addRecipes(StorageCrafterRecipeCategory.STORAGE_CRAFTER_RECIPE_TYPE, recipes);
        registration.addRecipes(StorageExtractorRecipeCategory.STORAGE_EXTRACTOR_RECIPE_TYPE, extractorRecipes);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (!this.isJEILoaded()) {
            return;
        }
        registration.addRecipeClickArea(StorageCrafterScreen.class, 120, 30, 20, 30, new RecipeType[]{StorageCrafterRecipeCategory.STORAGE_CRAFTER_RECIPE_TYPE});
        registration.addRecipeClickArea(StorageExtractorScreen.class, 70, 30, 20, 30, new RecipeType[]{StorageExtractorRecipeCategory.STORAGE_EXTRACTOR_RECIPE_TYPE});
    }

    private boolean isJEILoaded() {
        return ModList.get().isLoaded("jei");
    }
}

