/*
 * Decompiled with CFR 0.152.
 */
package com.razz.essentialpartnermod;

import com.razz.essentialpartnermod.EssentialPartner;
import com.razz.essentialpartnermod.ModLoaderUtil;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import net.minecraft.client.Minecraft;

public class EssentialUtil {
    private static boolean installationCompleted = false;
    private static Boolean isEssentialLoaded = null;

    public static boolean isEssentialOrContainerLoaded() {
        if (isEssentialLoaded == null) {
            isEssentialLoaded = ModLoaderUtil.isModLoaded("essential") || EssentialUtil.isEssentialContainerLoaded();
        }
        return isEssentialLoaded;
    }

    private static boolean isEssentialContainerLoaded() {
        return Launcher.INSTANCE.findLayerManager().flatMap(it -> it.getLayer(IModuleLayerManager.Layer.SERVICE)).map(ModuleLayer::modules).orElseGet(Collections::emptySet).stream().anyMatch(it -> it.getClassLoader().getResource("essential_container_marker.txt") != null);
    }

    public static boolean installationCompleted() {
        return installationCompleted;
    }

    public static boolean installContainer() {
        try {
            Path destination = Paths.get("mods", "essential-container.jar");
            if (Files.exists(destination, new LinkOption[0])) {
                int i = 1;
                do {
                    destination = Paths.get("mods", "essential-container-" + i + ".jar");
                    ++i;
                } while (Files.exists(destination, new LinkOption[0]));
            }
            try (InputStream is = EssentialUtil.class.getResourceAsStream("container.jarx");){
                if (is == null) {
                    throw new IllegalStateException("No bundled container jar found!");
                }
                Files.copy(is, destination, new CopyOption[0]);
            }
            EssentialPartner.LOGGER.info("Successfully installed essential container to {}", (Object)destination.toRealPath(new LinkOption[0]));
            installationCompleted = true;
            return true;
        }
        catch (Exception e) {
            EssentialPartner.LOGGER.error("Failed to install essential container", (Throwable)e);
            return false;
        }
    }

    public static void shutdown() {
        Minecraft.m_91087_().m_91395_();
    }
}

