/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.decorative_core.block.base;

import com.mojang.logging.LogUtils;
import com.yablon.decorative_core.block.entity.AbstractStorageBlockEntity;
import com.yablon.decorative_core.item.CapacityUpgradeItem;
import com.yablon.decorative_core.item.ModItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public abstract class AbstractStorageBlockBase<T extends AbstractStorageBlockEntity>
extends Block
implements EntityBlock {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String storedItemId;
    private final VoxelShape shape;

    public AbstractStorageBlockBase(BlockBehaviour.Properties properties, String storedItemId, VoxelShape shape) {
        super(properties);
        this.storedItemId = storedItemId;
        this.shape = shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        String heldId;
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof AbstractStorageBlockEntity)) {
            return InteractionResult.PASS;
        }
        AbstractStorageBlockEntity storage = (AbstractStorageBlockEntity)be;
        ItemStack held = player.m_21120_(hand);
        Item item = held.m_41720_();
        if (item instanceof CapacityUpgradeItem) {
            CapacityUpgradeItem up = (CapacityUpgradeItem)item;
            int target = up.getTargetCapacity();
            int currentCap = storage.getMaxCapacity();
            int currentCount = storage.getItemCount();
            if (target == currentCap) {
                if (level.f_46443_) {
                    player.m_5661_((Component)Component.m_237110_((String)"gui.decorative_core.capacity_same", (Object[])new Object[]{target}), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (currentCount > target) {
                if (level.f_46443_) {
                    int need = currentCount - target;
                    player.m_5661_((Component)Component.m_237110_((String)"gui.decorative_core.capacity_too_many_items", (Object[])new Object[]{need}), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (!level.f_46443_) {
                Item prevUpgrade;
                if (target < currentCap && (prevUpgrade = this.upgradeItemForCapacity(currentCap)) != null) {
                    Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)prevUpgrade));
                }
                if (storage.trySetCapacity(target)) {
                    if (!player.m_7500_()) {
                        held.m_41774_(1);
                    }
                    AbstractStorageBlockBase.sync(level, pos, state, storage);
                    player.m_5661_((Component)Component.m_237110_((String)"gui.decorative_core.capacity_set", (Object[])new Object[]{target}), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!held.m_41619_() && (heldId = ForgeRegistries.ITEMS.getKey((Object)held.m_41720_()).toString()).equals(this.storedItemId)) {
            int cap;
            int count = storage.getItemCount();
            if (count < (cap = storage.getMaxCapacity())) {
                int insert = Math.min(held.m_41613_(), cap - count);
                if (insert > 0 && !level.f_46443_) {
                    storage.setItemCount(count + insert);
                    held.m_41774_(insert);
                    AbstractStorageBlockBase.sync(level, pos, state, storage);
                }
                return InteractionResult.SUCCESS;
            }
            if (level.f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)"gui.decorative_core.full_message"), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_21120_(hand).m_41619_()) {
            int available;
            boolean shift = player.m_6144_();
            int toTake = shift ? 64 : 1;
            int canTake = Math.min(toTake, available = storage.getItemCount());
            if (canTake > 0 && !level.f_46443_) {
                ItemStack out = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(storage.getStoredItem()), canTake);
                if (!player.m_36356_(out)) {
                    Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)out);
                }
                storage.setItemCount(available - canTake);
                AbstractStorageBlockBase.sync(level, pos, state, storage);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    protected Item upgradeItemForCapacity(int capacity) {
        return switch (capacity) {
            case 512 -> (Item)ModItems.IRON_UPGRADE.get();
            case 1024 -> (Item)ModItems.GOLD_UPGRADE.get();
            case 2048 -> (Item)ModItems.DIAMOND_UPGRADE.get();
            case 4096 -> (Item)ModItems.NETHERITE_UPGRADE.get();
            default -> null;
        };
    }

    protected static void sync(Level level, BlockPos pos, BlockState state, AbstractStorageBlockEntity be) {
        be.m_6596_();
        level.m_7260_(pos, state, state, 3);
    }

    public String getStoredItemId() {
        return this.storedItemId;
    }

    @Nullable
    public abstract BlockEntity m_142194_(BlockPos var1, BlockState var2);

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity be;
        if (!state.m_60713_(newState.m_60734_()) && !level.f_46443_ && (be = level.m_7702_(pos)) instanceof AbstractStorageBlockEntity) {
            AbstractStorageBlockEntity storage = (AbstractStorageBlockEntity)be;
            storage.dropAllStoredItems();
            Item up = this.upgradeItemForCapacity(storage.getMaxCapacity());
            if (up != null) {
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)up));
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity be;
        if (!level.f_46443_ && (be = level.m_7702_(pos)) instanceof AbstractStorageBlockEntity) {
            AbstractStorageBlockEntity storage = (AbstractStorageBlockEntity)be;
            if (player.m_7500_()) {
                storage.dropAllStoredItems();
            }
        }
        super.m_5707_(level, pos, state, player);
    }
}

