/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client;

import de.mrjulsen.mcdragonlib.client.gui.DLOverlayScreen;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class OverlayManager {
    protected static final Map<Long, DLOverlayScreen> instances = new HashMap<Long, DLOverlayScreen>();

    public static <T extends DLOverlayScreen> Optional<T> get(long id) {
        return OverlayManager.has(id) ? Optional.of(instances.get(id)) : Optional.empty();
    }

    public static long add(DLOverlayScreen overlay) {
        instances.put(overlay.getId(), overlay);
        return overlay.getId();
    }

    public static boolean has(long id) {
        return instances.containsKey(id);
    }

    public static int count() {
        return instances.size();
    }

    public static void remove(long id) {
        if (!OverlayManager.has(id)) {
            return;
        }
        instances.remove(id).onClose();
    }

    public static void clear() {
        instances.values().forEach(x -> x.onClose());
        instances.clear();
    }

    public static void tickAll() {
        instances.values().stream().forEach(x -> x.m_94120_());
    }

    public static void renderAll(GuiGraphics graphics, float partialTicks) {
        instances.values().stream().forEach(x -> x.render(new Graphics(graphics, graphics.m_280168_()), partialTicks, Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_()));
    }

    public static Collection<DLOverlayScreen> getAllOverlays() {
        return instances.values();
    }
}

