/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.ber;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.vertex.PoseStack;
import de.mrjulsen.mcdragonlib.client.ber.RenderGraphics;
import de.mrjulsen.mcdragonlib.client.util.BERUtils;
import de.mrjulsen.mcdragonlib.client.util.FontUtils;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.mixin.BakedGlyphAccessor;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;

public class BERLabel {
    private static final byte CHAR_SIZE = 8;
    public static final float INVALID = -1.0f;
    public static final float DEFAULT_SCROLL_SPEED = 0.5f;
    public static final BoundsHitReaction DEFAULT_BOUNDS_HIT_REACTION = BoundsHitReaction.CUT_OFF;
    private final FontUtils fontUtils;
    private Component text;
    private float x = 0.0f;
    private float y = 0.0f;
    private boolean widthLimited = false;
    private float maxWidth = 0.0f;
    private BoundsHitReaction boundsHitReaction = BoundsHitReaction.CUT_OFF;
    private float minScale = 1.0f;
    private float scale = 1.0f;
    private float yScale = 1.0f;
    private float scrollingSpeed = 0.5f;
    private boolean forceScrolling = false;
    private boolean center = false;
    private int color = -1;
    private int backgroundColor = 0;
    private boolean backgroundColorFullLabel = false;
    private final Cache<TextDataCache> textData = new Cache<TextDataCache>(this::calc);
    private final Cache<Float> scaledTextWidth = new Cache<Float>(() -> {
        float textWidth = this.getFontUtils().font.m_92852_((FormattedText)this.getText());
        float rawXScale = textWidth * this.getScale();
        return Float.valueOf(rawXScale);
    });
    private final Cache<Float> textWidth = new Cache<Float>(() -> Float.valueOf(this.getText().getString().isEmpty() ? 0.0f : (float)this.getFontUtils().font.m_92852_((FormattedText)this.getText()) * this.textData.get().scale()));
    private final Map<Integer, CharData> charDataCache = new HashMap<Integer, CharData>();
    private float xScrollOffset = 0.0f;

    public BERLabel() {
        this((Component)TextUtils.empty());
    }

    public BERLabel(Component initialText) {
        this(new FontUtils(Style.f_131100_), initialText);
    }

    public BERLabel(FontUtils fontUtils, Component initialText) {
        this.fontUtils = fontUtils;
        this.text = initialText;
    }

    public BERLabel setPos(float x, float y) {
        this.x = x;
        this.y = y;
        this.resetCaches();
        return this;
    }

    public BERLabel setMaxWidth(float maxWidth, BoundsHitReaction reaction) {
        this.maxWidth = maxWidth;
        this.boundsHitReaction = reaction;
        this.widthLimited = true;
        this.resetCaches();
        return this;
    }

    public BERLabel noMaxWidth() {
        this.maxWidth = 0.0f;
        this.widthLimited = false;
        this.resetCaches();
        return this;
    }

    public BERLabel setScale(float def, float min) {
        this.minScale = min;
        this.scale = def;
        this.resetCaches();
        return this;
    }

    public BERLabel setScrollingSpeed(float speed) {
        this.scrollingSpeed = speed;
        this.resetCaches();
        return this;
    }

    public BERLabel setForceScrolling(boolean b) {
        this.forceScrolling = b;
        this.resetCaches();
        return this;
    }

    public BERLabel setYScale(float scale) {
        this.yScale = scale;
        this.resetCaches();
        return this;
    }

    public BERLabel setCentered(boolean b) {
        this.center = b;
        this.resetCaches();
        return this;
    }

    public BERLabel setBackground(int color, boolean fullSize) {
        this.backgroundColor = color;
        this.backgroundColorFullLabel = fullSize;
        return this;
    }

    public BERLabel setColor(int color) {
        this.color = color;
        return this;
    }

    public BERLabel setText(Component text) {
        this.text = text;
        this.resetCaches();
        return this;
    }

    public FontUtils getFontUtils() {
        return this.fontUtils;
    }

    public Component getText() {
        return this.text;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getMaxWidth() {
        return this.maxWidth;
    }

    public BoundsHitReaction getBoundsHitReaction() {
        return this.boundsHitReaction;
    }

    public float getMinScale() {
        return this.minScale;
    }

    public float getScale() {
        return this.scale;
    }

    public float getScrollingSpeed() {
        return this.scrollingSpeed;
    }

    public boolean isForceScrolling() {
        return this.forceScrolling;
    }

    public boolean isCentered() {
        return this.center;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean isBackgroundColorFullSize() {
        return this.backgroundColorFullLabel;
    }

    public int getColor() {
        return this.color;
    }

    public float getYScale() {
        return this.yScale;
    }

    public float getTextWidth() {
        return this.textWidth.get().floatValue();
    }

    private void resetCaches() {
        this.textData.clear();
        this.charDataCache.clear();
        this.scaledTextWidth.clear();
        this.textWidth.clear();
    }

    protected TextDataCache calc() {
        boolean mustScroll;
        float textWidth = this.getFontUtils().font.m_92852_((FormattedText)this.getText());
        if (!this.widthLimited) {
            return new TextDataCache(textWidth, textWidth, this.getScale(), this.isForceScrolling());
        }
        float rawXScale = this.getMaxWidth() / textWidth;
        float minScale = this.getBoundsHitReaction() == BoundsHitReaction.SCROLL ? this.getScale() : this.getMinScale();
        float defScale = this.getScale();
        float finalXScale = MathUtils.clamp(rawXScale, minScale, defScale);
        boolean bl = mustScroll = this.isForceScrolling() || rawXScale < this.getMinScale() && this.getMaxWidth() > 0.0f && (this.getBoundsHitReaction() == BoundsHitReaction.SCROLL || this.getBoundsHitReaction() == BoundsHitReaction.SCALE_SCROLL);
        if (mustScroll) {
            finalXScale = defScale;
        }
        return new TextDataCache(textWidth, textWidth * finalXScale, finalXScale, mustScroll);
    }

    public void renderTick() {
        if (this.textData.get().shouldScroll()) {
            float scaledMaxWidth = (!this.widthLimited ? this.scaledTextWidth.get().floatValue() : this.getMaxWidth()) / this.textData.get().scale();
            this.xScrollOffset -= Minecraft.m_91087_().m_91297_() * this.getScrollingSpeed();
            if (this.xScrollOffset < -this.textData.get().textWidth()) {
                this.xScrollOffset = scaledMaxWidth;
            }
        }
    }

    public void render(RenderGraphics graphics) {
        this.render(graphics, graphics.packedLight());
    }

    public void render(RenderGraphics graphics, int light) {
        float txtX;
        this.getFontUtils().reset();
        float scaledMaxWidth = (!this.widthLimited ? this.scaledTextWidth.get().floatValue() : this.getMaxWidth()) / this.textData.get().scale();
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_252880_(this.getX(), this.getY(), 0.0f);
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(this.textData.get().scale(), this.getYScale(), 1.0f);
        float f = this.textData.get().shouldScroll() ? this.xScrollOffset : (txtX = this.center ? Math.max(0.0f, scaledMaxWidth / 2.0f - this.textData.get().textWidth() / 2.0f) : 0.0f);
        if (this.getBackgroundColor() != 0 && !this.getText().getString().isEmpty()) {
            if (this.isBackgroundColorFullSize()) {
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                BERUtils.fillColor(graphics, -1.0f, -1.0f, 0.0f, scaledMaxWidth + 2.0f, 9 + 1, this.getBackgroundColor(), Direction.NORTH, light);
            } else {
                float f2 = (this.center ? Math.max(0.0f, scaledMaxWidth / 2.0f - this.textData.get().textWidth() / 2.0f) : 0.0f) - 1.0f;
                float f3 = Math.min(this.scaledTextWidth.get().floatValue() / this.textData.get().scale(), scaledMaxWidth) + 2.0f;
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                BERUtils.fillColor(graphics, f2, -1.0f, 0.0f, f3, 9 + 1, this.getBackgroundColor(), Direction.NORTH, light);
            }
            graphics.poseStack().m_252880_(0.0f, 0.0f, 0.01f);
        }
        this.renderTextInBounds(graphics.poseStack(), this.getFontUtils(), graphics.multiBufferSource(), this.getText(), light, txtX, 0.0f, this.getBoundsHitReaction() == BoundsHitReaction.IGNORE ? 2.1474836E9f : scaledMaxWidth);
        graphics.poseStack().m_85849_();
        graphics.poseStack().m_85849_();
    }

    protected void renderTextInBounds(PoseStack poseStack, FontUtils fontUtils, MultiBufferSource bufferSource, Component text, int packedLight, float xOffset, float xLeft, float xRight) {
        if (xRight <= xLeft) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252880_(xLeft + (xOffset > 0.0f ? xOffset : 0.0f), 0.0f, 0.0f);
        Font font = fontUtils.font;
        Objects.requireNonNull(font);
        Font.StringRenderOutput sro = new Font.StringRenderOutput(font, bufferSource, 0.0f, 0.0f, this.getColor(), false, poseStack.m_85850_().m_252922_(), Font.DisplayMode.NORMAL, packedLight);
        float newX = xOffset;
        float glyphTranslation = 0.0f;
        float charSize = 8 + (text.m_7383_().m_131154_() ? 1 : 0);
        for (int i = 0; i < text.getString().length(); ++i) {
            float diff;
            char charCode = text.getString().charAt(i);
            CharData charData = this.charDataCache.computeIfAbsent(Integer.valueOf(charCode), c -> {
                GlyphInfo info = fontUtils.fontSet.m_243128_(c.intValue(), false);
                float glyphWidth = info.m_83827_(text.m_7383_().m_131154_());
                BakedGlyphAccessor glyph = fontUtils.getGlyphAccessor((int)c);
                float glyphUVDiff = glyph.dragonlib$getU1() - glyph.dragonlib$getU0();
                return new CharData((int)c, info, glyphWidth, glyph, glyphUVDiff);
            });
            float oldX = newX;
            if ((newX += charData.glyphWidth()) > xLeft && oldX < xLeft) {
                diff = xLeft - oldX;
                float scale = 1.0f / charSize * diff;
                float sub = charData.glyphUVDiff() * scale;
                fontUtils.pushUV(charCode);
                charData.glyph().dragonlib$setU0(charData.glyph().dragonlib$getU0() + sub);
                poseStack.m_85836_();
                float invScale = 1.0f - scale;
                poseStack.m_85841_(invScale, 1.0f, 1.0f);
                Font font2 = fontUtils.font;
                Objects.requireNonNull(font2);
                Font.StringRenderOutput sro2 = new Font.StringRenderOutput(font2, bufferSource, 0.0f, 0.0f, this.getColor(), false, poseStack.m_85850_().m_252922_(), Font.DisplayMode.NORMAL, packedLight);
                StringDecomposer.m_14346_((String)String.valueOf(charCode), (Style)text.m_7383_(), (FormattedCharSink)sro2);
                poseStack.m_85849_();
                fontUtils.popUV(charCode);
                poseStack.m_252880_(charData.glyphWidth() - charSize * scale, 0.0f, 0.0f);
                continue;
            }
            if (newX > xRight && newX < xRight + 16.0f) {
                diff = newX - xRight;
                float charRightSpace = charSize - charData.glyphWidth();
                float totalDiff = diff + charRightSpace;
                float scale = 1.0f / charSize * totalDiff;
                float sub = charData.glyphUVDiff() * scale;
                fontUtils.pushUV(charCode);
                charData.glyph().dragonlib$setU1(charData.glyph().dragonlib$getU1() - sub);
                poseStack.m_85836_();
                float invScale = 1.0f - scale;
                poseStack.m_85841_(invScale, 1.0f, 1.0f);
                poseStack.m_252880_(glyphTranslation / invScale, 0.0f, 0.0f);
                Font font3 = fontUtils.font;
                Objects.requireNonNull(font3);
                Font.StringRenderOutput sro2 = new Font.StringRenderOutput(font3, bufferSource, 0.0f, 0.0f, this.getColor(), false, poseStack.m_85850_().m_252922_(), Font.DisplayMode.NORMAL, packedLight);
                StringDecomposer.m_14346_((String)String.valueOf(charCode), (Style)text.m_7383_(), (FormattedCharSink)sro2);
                poseStack.m_85849_();
                fontUtils.popUV(charCode);
                break;
            }
            if (!(oldX >= xLeft) || !(newX <= xRight)) continue;
            StringDecomposer.m_14346_((String)String.valueOf(charCode), (Style)text.m_7383_(), (FormattedCharSink)sro);
            glyphTranslation += charData.glyphWidth();
        }
        poseStack.m_85849_();
    }

    public static enum BoundsHitReaction {
        IGNORE,
        CUT_OFF,
        SCALE_SCROLL,
        SCROLL;

    }

    protected record TextDataCache(float textWidth, float scaledTextWidth, float scale, boolean shouldScroll) {
    }

    protected record CharData(int charCode, GlyphInfo glyphInfo, float glyphWidth, BakedGlyphAccessor glyph, float glyphUVDiff) {
    }
}

