/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.GuiIcons;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class DLCheckBox
extends DLButton {
    public static final int DEFAULT_CHECKBOX_HEIGHT = 12;
    private final int maxLineWidth;
    protected boolean checked;
    protected final Cache<GuiAreaDefinition> boxArea;
    protected final Consumer<DLCheckBox> onCheckedChanged;

    public DLCheckBox(int pX, int pY, int pWidth, String pMessage, boolean checked, Consumer<DLCheckBox> onCheckedChanged) {
        super(pX, pY, pWidth, 16, (Component)TextUtils.text(pMessage), (T b) -> ((DLCheckBox)b).toggleChecked());
        this.maxLineWidth = this.f_93618_ - 12 - 12;
        this.boxArea = new Cache<GuiAreaDefinition>(() -> new GuiAreaDefinition(this.x(), this.y() + 8 - 6, 12, 12));
        this.setChecked(checked);
        this.onCheckedChanged = onCheckedChanged;
    }

    public boolean setChecked(boolean b) {
        return this.setChecked(b, true);
    }

    public boolean setChecked(boolean value, boolean callEvents) {
        this.checked = value;
        if (callEvents && this.onCheckedChanged != null) {
            this.onCheckedChanged.accept(this);
        }
        return this.checked;
    }

    public boolean toggleChecked() {
        return this.toggleChecked(true);
    }

    public boolean toggleChecked(boolean callEvents) {
        return this.setChecked(!this.checked, callEvents);
    }

    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        DynamicGuiRenderer.renderArea(graphics, this.boxArea.get(), this.getBackColor(), this.getStyle(), DynamicGuiRenderer.ButtonState.DOWN);
        GuiUtils.resetTint();
        if (this.isMouseSelected()) {
            GuiUtils.drawBox(graphics, this.boxArea.get(), 0, -1);
        }
        if (this.isChecked()) {
            GuiUtils.setTint(this.active() ? -1 : -6381922);
            GuiIcons.X.render(graphics, this.x() + 6 - 8, this.y() + this.height() / 2 - 8);
        }
        GuiUtils.setTint(1.0f, 1.0f, 1.0f, this.f_93625_);
        boolean tooWide = this.font.m_92852_((FormattedText)this.m_6035_()) > this.maxLineWidth;
        int j = this.active() ? this.getFontColor() : -6381922;
        int n = this.x() + 12 + 4;
        int n2 = this.y() + this.height() / 2;
        Objects.requireNonNull(this.font);
        GuiUtils.drawString(graphics, this.font, n, n2 - 9 / 2, (FormattedText)(tooWide ? TextUtils.text(this.font.m_92854_((FormattedText)this.m_6035_(), this.maxLineWidth).getString() + "...") : this.m_6035_()), j, EAlignment.LEFT, this.isRenderingTextShadow());
    }

    @Override
    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean tooWide;
        boolean bl = tooWide = this.font.m_92852_((FormattedText)this.m_6035_()) > this.maxLineWidth;
        if (tooWide && this.isMouseSelected()) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            GuiAreaDefinition guiAreaDefinition = GuiAreaDefinition.of(this);
            List<Component> list = List.of(this.m_6035_());
            int n = this.m_252754_() + 12;
            int n2 = this.m_252907_() + this.m_93694_() / 2;
            Objects.requireNonNull(this.font);
            GuiUtils.renderTooltipAt(screen, guiAreaDefinition, list, 255, graphics, n, n2 - 9 / 2 - 4, mouseX, mouseY, 0, 0);
        }
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void set_width(int w) {
        super.set_width(w);
        this.boxArea.clear();
    }

    @Override
    public void set_height(int h) {
        super.set_height(h);
        this.boxArea.clear();
    }

    @Override
    public void set_x(int x) {
        super.set_x(x);
        this.boxArea.clear();
    }

    @Override
    public void set_y(int y) {
        super.set_y(y);
        this.boxArea.clear();
    }
}

