/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenuItemSeparator;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.phys.Vec2;

public class DLContextMenuItem
extends DLButton {
    private static final int DEFAULT_PADDING = 2;
    private static final int MIN_ICON_SIZE = 12;
    private static final Component ARROW_TEXT = TextUtils.text(">");
    private final DLContextMenu parentMenu;
    private final Sprite icon;

    public DLContextMenuItem(DLContextMenu parent, int x, int y, int w, Component text, Sprite icon, Consumer<DLContextMenuItem> pOnPress) {
        super(x, y, w, Math.max(12, icon.getHeight()), text, pOnPress);
        this.icon = icon;
        this.parentMenu = parent;
        this.setTextShadow(false);
    }

    @Override
    public void onHoverChange(int mouseX, int mouseY, boolean isHovering) {
        if (this.getContextMenu() != null && isHovering && this.m_142518_()) {
            new ArrayList<GuiEventListener>(this.parentMenu.m_6702_()).forEach((Consumer<? extends GuiEventListener>)((Consumer<GuiEventListener>)x -> {
                DLContextMenuItem item;
                if (x instanceof DLContextMenuItem && (item = (DLContextMenuItem)x).getContextMenu() != null) {
                    item.getContextMenu().close();
                }
            }));
            this.getContextMenu().open(mouseX, mouseY, menu -> {
                Screen s = Minecraft.m_91087_().f_91080_;
                int pX = this.m_252754_() + this.f_93618_ - 3 + menu.getWidth() > s.f_96543_ ? this.m_252754_() - menu.getWidth() : this.m_252754_() + this.f_93618_ - 3;
                int pY = Math.min(this.m_252907_() - 3, s.f_96544_ - menu.getHeight());
                return new Vec2((float)pX, (float)pY);
            });
        } else if (this.getContextMenu() != null && !this.getContextMenu().isHovered()) {
            this.getContextMenu().close();
        }
    }

    @Override
    public void setMenu(DLContextMenu menu) {
        if (menu != null) {
            menu.setParentMenu(this.parentMenu);
        }
        super.setMenu(menu);
    }

    @Override
    public int getContextMenuOpenButton() {
        return -1;
    }

    @Override
    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int color;
        int n = this.active() ? (this.m_198029_() ? -96 : this.getFontColor()) : (color = -12566464);
        if ((this.m_198029_() || this.getContextMenu() != null && this.getContextMenu().isOpen()) && this.f_93623_) {
            GuiUtils.fill(graphics, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, 0x30FFFFFF);
        }
        int iconW = Math.max(12, this.icon.getWidth());
        GuiUtils.setTint(color);
        this.icon.render(graphics, this.x() + 2, this.y() + this.height() / 2 - this.icon.getHeight() / 2);
        GuiUtils.setTint(1.0f, 1.0f, 1.0f, this.f_93625_);
        int n2 = this.x() + 6 + iconW;
        int n3 = this.y() + this.height() / 2;
        Objects.requireNonNull(this.font);
        GuiUtils.drawString(graphics, this.font, n2, n3 - 9 / 2, (FormattedText)this.m_6035_(), color, EAlignment.LEFT, this.isRenderingTextShadow());
        if (this.getContextMenu() != null) {
            int n4 = this.x() + this.width() - 2;
            int n5 = this.y() + this.height() / 2;
            Objects.requireNonNull(this.font);
            GuiUtils.drawString(graphics, this.font, n4, n5 - 9 / 2, (FormattedText)ARROW_TEXT, color, EAlignment.RIGHT, this.isRenderingTextShadow());
        }
    }

    @Override
    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public static int calcWidth(Component text, Sprite icon) {
        if (text == null || icon == null) {
            return 12;
        }
        return 16 + Math.max(12, icon.getWidth()) + Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text) + 4;
    }

    public static int calcHeight(Sprite icon) {
        if (icon == null) {
            return 3;
        }
        return Math.max(12, icon.getHeight());
    }

    public record ContextMenuItemData(Component text, Sprite icon, boolean enabled, Consumer<DLContextMenuItem> click, Function<DLContextMenuItem, DLContextMenu> subMenu) {
    }

    public static class Builder {
        private final Collection<ContextMenuItemData> rawItems = new ArrayList<ContextMenuItemData>();

        public Builder add(ContextMenuItemData item) {
            this.rawItems.add(item);
            return this;
        }

        public Builder addSeparator() {
            this.rawItems.add(new ContextMenuItemData(null, null, false, null, null));
            return this;
        }

        public void applySize(DLContextMenu menu) {
            int w = this.rawItems.stream().mapToInt(x -> DLContextMenuItem.calcWidth(x.text(), x.icon())).max().orElse(12);
            int h = this.rawItems.stream().mapToInt(x -> DLContextMenuItem.calcHeight(x.icon())).sum();
            menu.setSize(w, h);
        }

        public Collection<DLContextMenuItem> build(DLContextMenu menu) {
            int w = this.rawItems.stream().mapToInt(x -> DLContextMenuItem.calcWidth(x.text(), x.icon())).max().orElse(12);
            int y = menu.getAreaY();
            ArrayList<DLContextMenuItem> items = new ArrayList<DLContextMenuItem>();
            for (ContextMenuItemData data : this.rawItems) {
                DLContextMenuItem itm;
                if (data.text() == null) {
                    itm = new DLContextMenuItemSeparator(menu, menu.getAreaX(), y, w);
                } else {
                    itm = new DLContextMenuItem(menu, menu.getAreaX(), y, w, data.text(), data.icon(), data.click());
                    itm.f_93623_ = data.enabled();
                    itm.setMenu(data.subMenu() == null ? null : data.subMenu().apply(itm));
                }
                items.add(itm);
                y += itm.m_93694_();
            }
            return items;
        }
    }
}

