/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

public class DLItemButton
extends DLAbstractImageButton<DLItemButton> {
    public static final int DEFAULT_BUTTON_WIDTH = 18;
    public static final int DEFAULT_BUTTON_HEIGHT = 18;
    private ItemStack item;
    private boolean renderItemTooltip = true;

    public DLItemButton(DLAbstractImageButton.ButtonType type, DynamicGuiRenderer.AreaStyle color, ItemStack item, WidgetsCollection collection, int x, int y, int w, int h, Component customText, Consumer<DLItemButton> onClick) {
        super(type, color, collection, x, y, w, h, customText == null ? item.m_41786_() : customText, onClick);
        this.withItem(item);
        if (color == DynamicGuiRenderer.AreaStyle.NATIVE) {
            this.setFontColor(-1);
        } else {
            this.setFontColor(-12566464);
        }
    }

    public DLItemButton(DLAbstractImageButton.ButtonType type, DynamicGuiRenderer.AreaStyle color, ItemStack item, int x, int y, int w, int h, Component customText, Consumer<DLItemButton> onClick) {
        this(type, color, item, null, x, y, w, h, customText, onClick);
    }

    public DLItemButton(DLAbstractImageButton.ButtonType type, DynamicGuiRenderer.AreaStyle color, ItemStack item, WidgetsCollection collection, int x, int y, Component customText, Consumer<DLItemButton> onClick) {
        this(type, color, item, collection, x, y, 18, 18, customText, onClick);
    }

    public DLItemButton(DLAbstractImageButton.ButtonType type, DynamicGuiRenderer.AreaStyle color, ItemStack item, int x, int y, Component customText, Consumer<DLItemButton> onClick) {
        this(type, color, item, x, y, 18, 18, customText, onClick);
    }

    public ItemStack getItem() {
        return this.item;
    }

    public DLItemButton withItem(ItemStack stack) {
        this.item = stack;
        return this;
    }

    public DLItemButton withDefaultItemTooltip(boolean b) {
        this.renderItemTooltip = b;
        return this;
    }

    @Override
    public void renderImage(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int labelWidth = 0;
        switch (this.getAlignment()) {
            case LEFT: {
                if (this.m_6035_() != null) {
                    int n = this.x() + 2 + 16 + 4;
                    int n2 = this.y() + this.height() / 2;
                    Objects.requireNonNull(this.font);
                    GuiUtils.drawString(graphics, this.font, n, n2 - 9 / 2, (FormattedText)this.m_6035_(), this.getFontColor(), EAlignment.LEFT, this.isRenderingTextShadow());
                }
                graphics.graphics().m_280480_(this.item, this.m_252754_() + 2, this.m_252907_() + this.f_93619_ / 2 - 8);
                break;
            }
            case RIGHT: {
                if (this.m_6035_() != null && !this.m_6035_().getString().isEmpty()) {
                    labelWidth = this.font.m_92852_((FormattedText)this.m_6035_()) + 4;
                }
                graphics.graphics().m_280480_(this.item, this.x() + this.width() - 2 - labelWidth - 16, this.y() + this.height() / 2 - 8);
                if (this.m_6035_() != null) {
                    int n = this.x() + this.width() - 2 + 2;
                    int n3 = this.y() + this.height() / 2;
                    Objects.requireNonNull(this.font);
                    GuiUtils.drawString(graphics, this.font, n, n3 - 9 / 2, (FormattedText)this.m_6035_(), this.getFontColor(), EAlignment.RIGHT, this.isRenderingTextShadow());
                }
                graphics.graphics().m_280480_(this.item, this.m_252754_() + this.f_93618_ - 2 - labelWidth - 16, this.m_252907_() + this.f_93619_ / 2 - 8);
                break;
            }
            default: {
                if (this.m_6035_() != null && !this.m_6035_().getString().isEmpty()) {
                    labelWidth = this.font.m_92852_((FormattedText)this.m_6035_()) + 4;
                }
                graphics.graphics().m_280480_(this.item, this.x() + this.width() / 2 - 8 - labelWidth / 2, this.y() + this.height() / 2 - 8);
                if (this.m_6035_() != null) {
                    labelWidth = this.font.m_92852_((FormattedText)this.m_6035_()) + 4;
                    int n = this.x() + this.width() / 2 + 8 + 2;
                    int n4 = this.y() + this.height() / 2;
                    Objects.requireNonNull(this.font);
                    GuiUtils.drawString(graphics, this.font, n, n4 - 9 / 2, (FormattedText)this.m_6035_(), this.getFontColor(), EAlignment.CENTER, this.isRenderingTextShadow());
                }
                graphics.graphics().m_280480_(this.item, this.m_252754_() + this.f_93618_ / 2 - 8 - labelWidth / 2, this.m_252907_() + this.f_93619_ / 2 - 8);
            }
        }
    }

    public void renderTooltip(Screen parent, Graphics graphics, int pMouseX, int pMouseY) {
        if (this.m_5953_(pMouseX, pMouseY) && this.renderItemTooltip) {
            GuiUtils.renderTooltip(parent, this, Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)this.getItem()), -1, graphics, pMouseX, pMouseY);
        }
    }

    public static void renderAllItemButtonTooltips(Screen parent, Graphics graphics, int pMouseX, int pMouseY) {
        parent.f_169369_.stream().filter(x -> {
            DLItemButton b;
            return x instanceof DLItemButton && (b = (DLItemButton)x).m_5953_(pMouseX, pMouseY) && b.renderItemTooltip;
        }).forEach(x -> ((DLItemButton)x).renderTooltip(parent, graphics, pMouseX, pMouseY));
    }
}

