/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.text.DecimalFormat;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class DLSlider
extends AbstractSliderButton
implements IDragonLibWidget {
    protected Component prefix;
    protected Component suffix;
    protected double minValue;
    protected double maxValue;
    protected double stepSize;
    protected boolean drawString;
    protected DynamicGuiRenderer.AreaStyle style = DynamicGuiRenderer.AreaStyle.NATIVE;
    protected int fontColor = -1;
    protected int backColor = -1;
    protected boolean textShadow = true;
    protected EAlignment textAlignment = EAlignment.CENTER;
    private final DecimalFormat format;
    private Consumer<DLSlider> onUpdateMessage;
    private BiConsumer<DLSlider, Double> onValueChanged;
    private DLContextMenu menu;
    private boolean mouseSelected;

    public DLSlider(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double currentValue, double stepSize, int precision, boolean drawString) {
        super(x, y, width, height, (Component)TextUtils.empty(), 0.0);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = Math.abs(stepSize);
        this.f_93577_ = this.snapToNearest((currentValue - minValue) / (maxValue - minValue));
        this.drawString = drawString;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }
            while (precision-- > 0) {
                builder.append('0');
            }
            this.format = new DecimalFormat(builder.toString());
        } else {
            this.format = Mth.m_14082_((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }
        this.m_5695_();
    }

    @Deprecated(forRemoval=true)
    public DLSlider(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double currentValue, double stepSize, int precision, boolean drawString, Consumer<DLSlider> onUpdateMessage) {
        super(x, y, width, height, (Component)TextUtils.empty(), 0.0);
        this.onUpdateMessage = onUpdateMessage;
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = Math.abs(stepSize);
        this.f_93577_ = this.snapToNearest((currentValue - minValue) / (maxValue - minValue));
        this.drawString = drawString;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }
            while (precision-- > 0) {
                builder.append('0');
            }
            this.format = new DecimalFormat(builder.toString());
        } else {
            this.format = Mth.m_14082_((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }
        this.m_5695_();
    }

    public void setOnUpdateMessage(Consumer<DLSlider> action) {
        this.onUpdateMessage = action;
    }

    public void setOnValueChanged(BiConsumer<DLSlider, Double> action) {
        this.onValueChanged = action;
    }

    public void setStepSize(int stepSize) {
        this.stepSize = stepSize;
    }

    public boolean isRenderingTextShadow() {
        return this.textShadow;
    }

    public void setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
    }

    public EAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(EAlignment textAlignment) {
        this.textAlignment = textAlignment;
    }

    public void setRenderStyle(DynamicGuiRenderer.AreaStyle style) {
        this.style = style;
        if (style.isCustom()) {
            this.setBackColor(-12040120);
        }
    }

    public DynamicGuiRenderer.AreaStyle getStyle() {
        return this.style;
    }

    public DLSlider(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double currentValue, boolean drawString, Consumer<DLSlider> onUpdateMessage) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, currentValue, 1.0, 0, drawString, onUpdateMessage);
    }

    public double getValue() {
        return this.f_93577_ * (this.maxValue - this.minValue) + this.minValue;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public void setValue(double value) {
        this.f_93577_ = this.snapToNearest((value - this.minValue) / (this.maxValue - this.minValue));
        this.m_5695_();
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        super.m_7212_(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }
            float f2 = f = flag ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.f_93577_ + (double)(f / (float)(this.f_93618_ - 8)));
            } else {
                this.setValue(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderMainLayer(new Graphics(graphics, graphics.m_280168_()), mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        DynamicGuiRenderer.renderArea(graphics, this.x(), this.y(), this.width(), this.height(), this.getBackColor(), this.style, DynamicGuiRenderer.ButtonState.DISABLED);
        DynamicGuiRenderer.renderArea(graphics, new GuiAreaDefinition(this.x() + (int)(this.f_93577_ * (double)(this.m_5711_() - 8)), this.y(), 8, this.m_93694_()), this.getBackColor(), this.style, this.m_142518_() ? (this.m_93696_() || this.isMouseSelected() ? DynamicGuiRenderer.ButtonState.SELECTED : DynamicGuiRenderer.ButtonState.BUTTON) : DynamicGuiRenderer.ButtonState.DISABLED);
        int j = this.active() ? this.getFontColor() : -6381922;
        GuiUtils.drawString(graphics, Minecraft.m_91087_().f_91062_, this.x() + this.width() / 2, this.y() + (this.height() - 8) / 2, (FormattedText)this.m_6035_(), j, this.getTextAlignment(), this.isRenderingTextShadow());
        GuiUtils.resetTint();
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.m_252754_() + 4)) / (double)(this.f_93618_ - 8));
    }

    private void setSliderValue(double value) {
        double oldValue = this.f_93577_;
        this.f_93577_ = this.snapToNearest(value);
        if (!Mth.m_14082_((double)oldValue, (double)this.f_93577_)) {
            this.m_5697_();
        }
        this.m_5695_();
    }

    private double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        }
        value = Mth.m_14139_((double)Mth.m_14008_((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? Mth.m_14008_((double)value, (double)this.maxValue, (double)this.minValue) : Mth.m_14008_((double)value, (double)this.minValue, (double)this.maxValue);
        return Mth.m_144914_((double)value, (double)this.minValue, (double)this.maxValue, (double)0.0, (double)1.0);
    }

    protected void m_5695_() {
        if (this.onUpdateMessage == null) {
            if (this.drawString) {
                this.m_93666_((Component)TextUtils.empty().m_7220_(this.prefix).m_130946_(this.getValueString()).m_7220_(this.suffix));
            } else {
                this.m_93666_((Component)TextUtils.empty());
            }
            return;
        }
        DLUtils.doIfNotNull(this.onUpdateMessage, x -> x.accept(this));
    }

    protected void m_5697_() {
        DLUtils.doIfNotNull(this.onValueChanged, x -> x.accept(this, this.getValue()));
    }

    @Override
    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.menu != null) {
            this.menu.m_88315_(graphics.graphics(), mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public DLContextMenu getContextMenu() {
        return this.menu;
    }

    @Override
    public void setMenu(DLContextMenu menu) {
        this.menu = menu;
    }

    @Override
    public void onFocusChangeEvent(boolean focus) {
        this.m_93692_(focus);
    }

    @Override
    public boolean isMouseSelected() {
        return this.mouseSelected;
    }

    @Override
    public void setMouseSelected(boolean selected) {
        this.mouseSelected = selected;
    }

    public int getBackColor() {
        return this.backColor;
    }

    public int getFontColor() {
        return this.fontColor;
    }

    public void setBackColor(int color) {
        this.backColor = color;
    }

    public void setFontColor(int color) {
        this.fontColor = color;
    }

    @Override
    public int x() {
        return this.m_252754_();
    }

    @Override
    public int y() {
        return this.m_252907_();
    }

    @Override
    public void set_x(int x) {
        this.m_252865_(x);
    }

    @Override
    public void set_y(int y) {
        this.m_253211_(y);
    }

    @Override
    public void set_width(int w) {
        this.f_93618_ = w;
    }

    @Override
    public void set_height(int h) {
        this.f_93619_ = h;
    }

    @Override
    public void set_visible(boolean b) {
        this.f_93624_ = b;
    }

    @Override
    public boolean visible() {
        return this.f_93624_;
    }

    @Override
    public void set_active(boolean b) {
        this.f_93623_ = b;
    }

    @Override
    public boolean active() {
        return super.m_142518_();
    }

    @Override
    public int width() {
        return this.f_93618_;
    }

    @Override
    public int height() {
        return this.f_93619_;
    }
}

