/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.RenderGraphics;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.ColorUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import java.util.BitSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public final class BERUtils {
    private static boolean aoRenderingErrorKnown = false;
    public static final ResourceLocation BLANK_TEXTURE_LOCATION;

    public static <T extends BlockEntity> void registerBER(BlockEntityType<? extends T> type, BlockEntityRendererProvider<T> renderProvider) {
        BlockEntityRendererRegistry.register(type, renderProvider);
    }

    public static void initRenderEngine() {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    public static float px(float pixelValue, int maxPixels) {
        return 1.0f / (float)maxPixels * pixelValue;
    }

    public static float bpx(float pixelValue) {
        return BERUtils.px(pixelValue, 16);
    }

    public static void setTint(int r, int g, int b, int a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static void setTint(int color) {
        short[] argb = ColorUtils.decodeARGB(color);
        RenderSystem.setShaderColor((float)argb[1], (float)argb[2], (float)argb[3], (float)argb[0]);
    }

    public static void renderTexture(ResourceLocation texture, RenderGraphics graphics, boolean ao, float x, float y, float z, float w, float h, float u0, float v0, float u1, float v1, Direction facing, int tint, int light) {
        VertexConsumer vertexconsumer = graphics.vertexConsumer(texture);
        short[] color = ColorUtils.decodeARGB(tint);
        BERUtils.addQuadSide(facing, vertexconsumer, graphics, ao, x, y, z, x + w, y + h, z, u0, v0, u1, v1, (float)color[1] / 255.0f, (float)color[2] / 255.0f, (float)color[3] / 255.0f, (float)color[0] / 255.0f, light);
    }

    public static void renderTexture(ResourceLocation texture, RenderGraphics graphics, boolean ao, float x, float y, float z, float w, float h, float u0, float v0, float u1, float v1, Direction facing, int tint) {
        BERUtils.renderTexture(texture, graphics, ao, x, y, z, w, h, u0, v0, u1, v1, facing, tint, graphics.packedLight());
    }

    public static void addVert(VertexConsumer builder, RenderGraphics graphics, float x, float y, float z, float u, float v, float r, float g, float b, float a, int lu, int lv) {
        builder.m_252986_(graphics.poseStack().m_85850_().m_252922_(), x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_7120_(lu, lv).m_86008_(OverlayTexture.f_118083_).m_252939_(graphics.poseStack().m_85850_().m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
    }

    private static void renderWithoutAO(VertexConsumer builder, RenderGraphics graphics, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int packedLight) {
        BERUtils.addVert(builder, graphics, x0, y0, z0, u0, v0, r, g, b, a, packedLight & 0xFFFF, packedLight >> 16 & 0xFFFF);
        BERUtils.addVert(builder, graphics, x0, y1, z0, u0, v1, r, g, b, a, packedLight & 0xFFFF, packedLight >> 16 & 0xFFFF);
        BERUtils.addVert(builder, graphics, x1, y1, z1, u1, v1, r, g, b, a, packedLight & 0xFFFF, packedLight >> 16 & 0xFFFF);
        BERUtils.addVert(builder, graphics, x1, y0, z1, u1, v0, r, g, b, a, packedLight & 0xFFFF, packedLight >> 16 & 0xFFFF);
    }

    private static void renderWithAO(Direction direction, VertexConsumer builder, BERGraphics<?> graphics, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int packedLight) {
        float[] afloat = new float[Direction.values().length * 2];
        BitSet bitset = new BitSet(3);
        ModelBlockRenderer.AmbientOcclusionFace ao = new ModelBlockRenderer.AmbientOcclusionFace();
        ClientLevel batg = Minecraft.m_91087_().f_91073_;
        ao.m_111167_((BlockAndTintGetter)batg, graphics.blockEntity().m_58900_(), graphics.blockEntity().m_58899_(), direction, afloat, bitset, true);
        BERUtils.addVert(builder, graphics, x0, y0, z0, u0, v0, r * ao.f_111149_[0], g * ao.f_111149_[0], b * ao.f_111149_[0], a, ao.f_111150_[0] & 0xFFFF, ao.f_111150_[0] >> 16 & 0xFFFF);
        BERUtils.addVert(builder, graphics, x0, y1, z0, u0, v1, r * ao.f_111149_[1], g * ao.f_111149_[1], b * ao.f_111149_[1], a, ao.f_111150_[1] & 0xFFFF, ao.f_111150_[1] >> 16 & 0xFFFF);
        BERUtils.addVert(builder, graphics, x1, y1, z1, u1, v1, r * ao.f_111149_[2], g * ao.f_111149_[2], b * ao.f_111149_[2], a, ao.f_111150_[2] & 0xFFFF, ao.f_111150_[2] >> 16 & 0xFFFF);
        BERUtils.addVert(builder, graphics, x1, y0, z1, u1, v0, r * ao.f_111149_[3], g * ao.f_111149_[3], b * ao.f_111149_[3], a, ao.f_111150_[3] & 0xFFFF, ao.f_111150_[3] >> 16 & 0xFFFF);
    }

    public static void addQuadSide(Direction direction, VertexConsumer builder, RenderGraphics graphics, boolean ao, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int packedLight) {
        BERGraphics berGraphics;
        if (!(ao && Minecraft.m_91086_() && graphics instanceof BERGraphics && (berGraphics = (BERGraphics)graphics).blockEntity().m_58904_() != null && berGraphics.blockEntity().m_58899_() != null)) {
            try {
                BERUtils.renderWithoutAO(builder, graphics, x0, y0, z0, x1, y1, z1, u0, v0, u1, v1, r, g, b, a, packedLight);
            }
            catch (Exception e2) {
                DragonLib.LOGGER.error("Error while rendering without AO.", (Throwable)e2);
            }
        } else {
            try {
                BERUtils.renderWithAO(direction, builder, berGraphics, x0, y0, z0, x1, y1, z1, u0, v0, u1, v1, r, g, b, a, packedLight);
                aoRenderingErrorKnown = false;
            }
            catch (Exception e) {
                if (!aoRenderingErrorKnown) {
                    DragonLib.LOGGER.error("Error while rendering with AO.", (Throwable)e);
                }
                aoRenderingErrorKnown = true;
                try {
                    BERUtils.renderWithoutAO(builder, graphics, x0, y0, z0, x1, y1, z1, u0, v0, u1, v1, r, g, b, a, packedLight);
                }
                catch (Exception e2) {
                    DragonLib.LOGGER.error("Error while rendering without AO.", (Throwable)e2);
                }
            }
        }
    }

    public static void fillColor(RenderGraphics graphics, float x, float y, float z, float w, float h, int color, Direction facing, int light) {
        BERUtils.renderTexture(BLANK_TEXTURE_LOCATION, graphics, false, x, y, z, w, h, 0.0f, 0.0f, 1.0f, 1.0f, facing, color, light);
    }

    public static void fillColor(RenderGraphics graphics, float x, float y, float z, float w, float h, int color, Direction facing) {
        BERUtils.fillColor(graphics, x, y, z, w, h, color, facing, graphics.packedLight());
    }

    public static void drawString(RenderGraphics graphics, Font font, float x, float y, Component text, int color, EAlignment alignment, boolean drawShadow, boolean transparent, int backgroundColor, int packedLight) {
        float dx = x;
        switch (alignment) {
            case RIGHT: {
                dx = x - (float)font.m_92852_((FormattedText)text);
                break;
            }
            case CENTER: {
                dx = x - (float)(font.m_92852_((FormattedText)text) / 2);
                break;
            }
        }
        font.m_272077_(text, dx, y, color, drawShadow, graphics.poseStack().m_85850_().m_252922_(), graphics.multiBufferSource(), transparent ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, backgroundColor, packedLight);
    }

    public static void drawString(RenderGraphics graphics, Font font, float x, float y, Component text, int color, EAlignment alignment, boolean drawShadow, int packedLight) {
        BERUtils.drawString(graphics, font, x, y, text, color, alignment, drawShadow, false, 0, packedLight);
    }

    public static void drawString(RenderGraphics graphics, Font font, float x, float y, Component text, int color, EAlignment alignment, boolean drawShadow) {
        BERUtils.drawString(graphics, font, x, y, text, color, alignment, drawShadow, graphics.packedLight());
    }

    public static void drawString(RenderGraphics graphics, Font font, float x, float y, String text, int color, EAlignment alignment, boolean drawShadow, boolean transparent, int backgroundColor, int packedLight) {
        BERUtils.drawString(graphics, font, x, y, (Component)TextUtils.text(text), color, alignment, drawShadow, transparent, backgroundColor, packedLight);
    }

    public static void drawString(RenderGraphics graphics, Font font, float x, float y, String text, int color, EAlignment alignment, boolean drawShadow, int packedLight) {
        BERUtils.drawString(graphics, font, x, y, text, color, alignment, drawShadow, false, 0, packedLight);
    }

    public static void drawString(RenderGraphics graphics, Font font, float x, float y, String text, int color, EAlignment alignment, boolean drawShadow) {
        BERUtils.drawString(graphics, font, x, y, text, color, alignment, drawShadow, graphics.packedLight());
    }

    static {
        NativeImage img = new NativeImage(1, 1, false);
        img.m_84988_(0, 0, -1);
        BLANK_TEXTURE_LOCATION = Minecraft.m_91087_().m_91097_().m_118490_("dragonlib_blank_texture", new DynamicTexture(img));
    }
}

