/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.core;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class Location {
    private static final String NBT_X = "x";
    private static final String NBT_Y = "y";
    private static final String NBT_Z = "z";
    private static final String NBT_DIM = "dim";
    public double x;
    public double y;
    public double z;
    public String dimension;
    private BlockPos blockPos;

    private Location() {
    }

    public Location(int x, int y, int z, String dimension) {
        this((double)x, (double)y, (double)z, dimension);
    }

    public Location(double x, double y, double z, String dimension) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
        this.generateBlockPos();
    }

    public Location(BlockPos pos, Level level) {
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.dimension = level.m_46472_().m_135782_().toString();
        this.blockPos = pos;
    }

    public Location(Vec3 vec, Level level) {
        this(vec.f_82479_, vec.f_82480_, vec.f_82481_, level.m_46472_().m_135782_().toString());
    }

    public BlockPos getLocationBlockPos() {
        return this.blockPos;
    }

    public Vec3 getLocationVec3() {
        return new Vec3(this.x, this.y, this.z);
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_(NBT_X, this.x);
        tag.m_128347_(NBT_Y, this.y);
        tag.m_128347_(NBT_Z, this.z);
        tag.m_128359_(NBT_DIM, this.dimension);
        return tag;
    }

    private void generateBlockPos() {
        this.blockPos = new BlockPos((int)this.x, (int)this.y, (int)this.z);
    }

    public static Location fromNbt(CompoundTag tag) {
        return Location.fromNbtInternal(tag, false);
    }

    @Deprecated
    public static Location fromNbtAsInt(CompoundTag tag) {
        return Location.fromNbtInternal(tag, true);
    }

    private static Location fromNbtInternal(CompoundTag tag, boolean legacy) {
        if (!(tag.m_128441_(NBT_X) && tag.m_128441_(NBT_Y) && tag.m_128441_(NBT_Z) && tag.m_128441_(NBT_DIM))) {
            return null;
        }
        Location loc = new Location();
        loc.loadFromNbt(tag, legacy);
        return loc;
    }

    public void loadFromNbt(CompoundTag tag, boolean legacy) {
        if (legacy) {
            this.x = tag.m_128451_(NBT_X);
            this.y = tag.m_128451_(NBT_Y);
            this.z = tag.m_128451_(NBT_Z);
        } else {
            this.x = tag.m_128459_(NBT_X);
            this.y = tag.m_128459_(NBT_Y);
            this.z = tag.m_128459_(NBT_Z);
        }
        this.dimension = tag.m_128461_(NBT_DIM);
        this.generateBlockPos();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            Location other = (Location)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z && this.dimension.equals(other.dimension);
        }
        return false;
    }

    public String toString() {
        return String.format("x=%s, y=%s, z=%s, dim=%s", this.x, this.y, this.z, this.dimension);
    }
}

