/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.config.ModCommonConfig;
import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.time.Duration;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;

public final class TimeUtils {
    private static final byte TIME_SPLITTER_MINUTES_INDEX = 0;
    private static final byte TIME_SPLITTER_HOURS_INDEX = 1;
    private static final byte TIME_SPLITTER_DAYS_INDEX = 2;

    public static final long convertTicksToMs(long ticks) {
        return (long)((double)ticks * DragonLib.mspt());
    }

    public static final String formatDurationMs(long s) {
        Duration duration = Duration.ofMillis(s);
        long HH = duration.toHours();
        long MM = duration.toMinutesPart();
        long SS = duration.toSecondsPart();
        if (HH <= 0L) {
            return String.format("%02d:%02d", MM, SS);
        }
        return String.format("%02d:%02d:%02d", HH, MM, SS);
    }

    public static long shiftDayTimeToMinecraftTicks(long time) {
        if ((time = (time - DragonLib.daytimeShift()) % DragonLib.ticksPerDay()) < 0L) {
            time += DragonLib.ticksPerDay();
        }
        return time;
    }

    private static long[] splitTime(long time) {
        long ticks = time % DragonLib.ticksPerDay();
        long days = time / DragonLib.ticksPerDay();
        long hours = ticks / DragonLib.ticksPerIngameHour();
        long minutes = ticks % DragonLib.ticksPerIngameHour();
        minutes = (long)((double)minutes / ((double)DragonLib.ticksPerIngameHour() / 60.0));
        return new long[]{minutes, hours, days};
    }

    public static long dayTime(Level level) {
        return level.m_46468_() + DragonLib.daytimeShift();
    }

    public static double calcClockHandRotationDegrees(long time, double mod) {
        int modNumber = (int)((double)time % mod);
        double rotation = (double)modNumber / mod * 360.0;
        return rotation;
    }

    public static long convertTicksToRealLife(long ticks) {
        return ticks / (DragonLib.ticksPerRealLifeDay() / DragonLib.ticksPerDay());
    }

    public static String parseTime(long time, TimeFormat format) {
        if (format == TimeFormat.TICKS) {
            return TimeUtils.shiftDayTimeToMinecraftTicks(time) + "t";
        }
        long[] splitTime = TimeUtils.splitTime(time);
        long minutes = splitTime[0];
        long hours = splitTime[1];
        if (format == TimeFormat.HOURS_24) {
            return String.format("%02d:%02d", hours, minutes);
        }
        if (format == TimeFormat.HOURS_12) {
            String suffix = "AM";
            if (hours >= 12L) {
                suffix = "PM";
                hours -= 12L;
            }
            if (hours == 0L) {
                hours = 12L;
            }
            return String.format("%02d:%02d %s", hours, minutes, suffix);
        }
        return "";
    }

    public static String parseDurationScaled(long time) {
        return TimeUtils.parseDuration(TimeUtils.scaleTicks(time));
    }

    public static String parseDuration(long time) {
        if (time < 0L) {
            return "-";
        }
        long[] splitTime = TimeUtils.splitTime(time);
        long minutes = splitTime[0];
        long hours = splitTime[1];
        long days = splitTime[2];
        if (hours <= 0L && days <= 0L) {
            return TextUtils.translate("dragonlib.time_format.m", minutes).getString();
        }
        if (days <= 0L) {
            return TextUtils.translate("dragonlib.time_format.hm", hours, minutes).getString();
        }
        return TextUtils.translate("dragonlib.time_format.dhm", days, hours, minutes).getString();
    }

    public static String parseDurationShortScaled(long time) {
        return TimeUtils.parseDurationShort(TimeUtils.scaleTicks(time));
    }

    public static String parseDurationShort(long time) {
        if (time < 0L) {
            return "-";
        }
        long[] splitTime = TimeUtils.splitTime(time);
        long minutes = splitTime[0];
        long hours = splitTime[1];
        long days = splitTime[2];
        if (hours <= 0L && days <= 0L) {
            return String.format("%sm", minutes);
        }
        if (days <= 0L) {
            return String.format("%sh %sm", hours, minutes);
        }
        return String.format("%sd %sh %sm", days, hours, minutes);
    }

    public static boolean isInRange(long time, long start, long end) {
        time %= DragonLib.ticksPerDay();
        if ((start %= DragonLib.ticksPerDay()) <= (end %= DragonLib.ticksPerDay())) {
            return time >= start && time <= end;
        }
        return time >= start || time <= end;
    }

    public static long addTime(long current, long add, boolean scale) {
        return scale ? current + TimeUtils.scaleTicks(add) : current + add;
    }

    public static String formatTime(long time, TimeFormat format) {
        return TimeUtils.parseTime((time + DragonLib.daytimeShift()) % DragonLib.ticksPerDay(), format);
    }

    public static long formatToMinutes(long ticks) {
        return (long)((double)ticks / ((double)DragonLib.ticksPerIngameHour() / 60.0));
    }

    public static long scaleTicks(long ticks) {
        return (long)Math.ceil((double)ticks / (Double)ModCommonConfig.TIME_MULTIPLIER.get());
    }

    public static long scaleTicksDiff(long total, long base) {
        long diff = total - base;
        return base + TimeUtils.scaleTicks(diff);
    }

    public static enum TimeFormat implements StringRepresentable,
    ITranslatableEnum
    {
        TICKS(0, "ticks"),
        HOURS_24(1, "hours_24"),
        HOURS_12(2, "hours_12");

        private String format;
        private byte index;

        private TimeFormat(byte index, String format) {
            this.format = format;
            this.index = index;
        }

        public String getFormat() {
            return this.format;
        }

        public byte getIndex() {
            return this.index;
        }

        public String getTranslationKey() {
            return String.format("%s.time_format.%s", "dragonlib", this.format);
        }

        public static TimeFormat getFormatByIndex(byte index) {
            for (TimeFormat shape : TimeFormat.values()) {
                if (shape.getIndex() != index) continue;
                return shape;
            }
            return TICKS;
        }

        public String m_7912_() {
            return this.format;
        }

        @Override
        public String getEnumName() {
            return "time_format";
        }

        @Override
        public String getEnumValueName() {
            return this.getFormat();
        }
    }
}

