/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.accessor;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.data.Single;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.WorkerAsync;
import de.mrjulsen.mcdragonlib.util.accessor.BasicDataAccessorPacket;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessorType;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;

public class DataAccessor {
    private static final Map<UUID, IChunkProcessor> callbacks = new HashMap<UUID, IChunkProcessor>();
    private static WorkerAsync serverWorker;
    private static WorkerAsync clientWorker;

    public static void startServerWorker() {
        DataAccessor.stopServerWorker();
        serverWorker = new WorkerAsync("DragonLib Network Manager (Server)", DragonLib.LOGGER);
        serverWorker.start();
    }

    public static void startClientWorker() {
        DataAccessor.stopClientWorker();
        clientWorker = new WorkerAsync("DragonLib Network Manager (Client)", DragonLib.LOGGER);
        clientWorker.start();
    }

    public static void stopServerWorker() {
        DLUtils.doIfNotNull(serverWorker, WorkerAsync::stop);
    }

    public static void stopClientWorker() {
        DLUtils.doIfNotNull(clientWorker, WorkerAsync::stop);
    }

    public static WorkerAsync getServerWorker() {
        return serverWorker;
    }

    public static WorkerAsync getClientWorker() {
        return clientWorker;
    }

    public static WorkerAsync getWorker(boolean preferServer) {
        if (clientWorker == null && serverWorker == null) {
            DataAccessor.startServerWorker();
        }
        boolean useClient = !preferServer && Platform.getEnv() == Dist.CLIENT && clientWorker != null || serverWorker == null;
        return useClient ? clientWorker : serverWorker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UUID addCallback(IChunkProcessor callback) {
        Map<UUID, IChunkProcessor> map = callbacks;
        synchronized (map) {
            UUID id;
            while (callbacks.containsKey(id = UUID.randomUUID())) {
            }
            callbacks.put(id, callback);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(UUID id, boolean hasMore, int iteration, CompoundTag nbt) {
        Map<UUID, IChunkProcessor> map = callbacks;
        synchronized (map) {
            if (callbacks.containsKey(id)) {
                (hasMore ? callbacks.get(id) : callbacks.remove(id)).run(hasMore, iteration, nbt);
            }
        }
    }

    public static <I, C, O> void getFromServer(I param, DataAccessorType<I, C, O> type, Consumer<O> output) {
        BasicDataAccessorPacket instance = new BasicDataAccessorPacket();
        Single.MutableSingle<Object> chunks = new Single.MutableSingle<Object>(null);
        UUID id = DataAccessor.addCallback((hasMore, iteration, nbt) -> {
            chunks.setFirst(instance.receiveChunk(hasMore, chunks.getFirst(), iteration, nbt));
            if (!hasMore) {
                output.accept(instance.processClient(chunks.getFirst()));
            }
        });
        instance.setData(id, param, type, true);
        DragonLib.getDragonLibNetworkManager().CHANNEL.sendToServer(instance);
    }

    public static <I, C, O> void getFromClient(ServerPlayer player, I param, DataAccessorType<I, C, O> type, Consumer<O> output) {
        BasicDataAccessorPacket instance = new BasicDataAccessorPacket();
        Single.MutableSingle<Object> chunks = new Single.MutableSingle<Object>(null);
        UUID id = DataAccessor.addCallback((hasMore, iteration, nbt) -> {
            chunks.setFirst(instance.receiveChunk(hasMore, chunks.getFirst(), iteration, nbt));
            if (!hasMore) {
                output.accept(instance.processClient(chunks.getFirst()));
            }
        });
        instance.setData(id, param, type, false);
        DragonLib.getDragonLibNetworkManager().CHANNEL.sendToPlayer(player, instance);
    }

    @FunctionalInterface
    public static interface IChunkProcessor {
        public void run(boolean var1, int var2, CompoundTag var3);
    }
}

