/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.config;

import de.markusbordihn.easymobfarm.config.Config;
import java.io.File;
import java.util.Properties;

public class MobFarmConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "mob_farm.cfg";
    public static final String CONFIG_FILE_HEADER = " Mob Farm Configuration\n\n This configuration file allows you to define the general settings for the Mob Farms.\n\n Configuration Options:\n ----------------------\n farmProgressingTime: Time in ticks for farm progression (default: 6000 = 5 minutes)\n\n tier0progressionUpgradeSpeed: Speed bonus for tier 0 farms (default: 0)\n tier1progressionUpgradeSpeed: Speed bonus for tier 1 farms (default: 2)\n tier2progressionUpgradeSpeed: Speed bonus for tier 2 farms (default: 4)\n tier3progressionUpgradeSpeed: Speed bonus for tier 3 farms (default: 6)\n\n experienceDropChance: Chance for experience drops (1 in x chance, default: 5)\n speedEnhancementUpgradeSpeed: Speed bonus from speed enhancement upgrades (default: 6)\n\n progressingRequiresOwnerToBeOnline: Whether farms only work when owner is online (default: false)\n luckyDropFarmLuckPercentage: Luck percentage for lucky drop farms (default: 95)\n enforceLogicalTierProgression: Whether farms must be upgraded in order (default: false)\n\n";
    public static int farmProgressingTime = 6000;
    public static int tier0progressionUpgradeSpeed = 0;
    public static int tier1progressionUpgradeSpeed = 2;
    public static int tier2progressionUpgradeSpeed = 4;
    public static int tier3progressionUpgradeSpeed = 6;
    public static int experienceDropChance = 5;
    public static int speedEnhancementUpgradeSpeed = 6;
    public static boolean processingRequiresOwnerToBeOnline = false;
    public static int luckyDropFarmLuckPercentage = 95;
    public static boolean enforceLogicalTierProgression = false;

    public static void registerConfig() {
        MobFarmConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        MobFarmConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = MobFarmConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = MobFarmConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        farmProgressingTime = MobFarmConfig.parseConfigValue(properties, "farmProgressingTime", farmProgressingTime);
        tier0progressionUpgradeSpeed = MobFarmConfig.parseConfigValue(properties, "tier0progressionUpgradeSpeed", tier0progressionUpgradeSpeed);
        tier1progressionUpgradeSpeed = MobFarmConfig.parseConfigValue(properties, "tier1progressionUpgradeSpeed", tier1progressionUpgradeSpeed);
        tier2progressionUpgradeSpeed = MobFarmConfig.parseConfigValue(properties, "tier2progressionUpgradeSpeed", tier2progressionUpgradeSpeed);
        tier3progressionUpgradeSpeed = MobFarmConfig.parseConfigValue(properties, "tier3progressionUpgradeSpeed", tier3progressionUpgradeSpeed);
        experienceDropChance = MobFarmConfig.parseConfigValue(properties, "experienceDropChance", experienceDropChance);
        speedEnhancementUpgradeSpeed = MobFarmConfig.parseConfigValue(properties, "speedEnhancementUpgradeSpeed", speedEnhancementUpgradeSpeed);
        processingRequiresOwnerToBeOnline = MobFarmConfig.parseConfigValue(properties, "progressingRequiresOwnerToBeOnline", processingRequiresOwnerToBeOnline);
        luckyDropFarmLuckPercentage = MobFarmConfig.parseConfigValue(properties, "luckyDropFarmLuckPercentage", luckyDropFarmLuckPercentage);
        enforceLogicalTierProgression = MobFarmConfig.parseConfigValue(properties, "enforceLogicalTierProgression", enforceLogicalTierProgression);
        MobFarmConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static int getFarmTierProgressionUpgradeSpeed(int tierLevel) {
        return switch (tierLevel) {
            case 0 -> tier0progressionUpgradeSpeed;
            case 1 -> tier1progressionUpgradeSpeed;
            case 2 -> tier2progressionUpgradeSpeed;
            case 3 -> tier3progressionUpgradeSpeed;
            default -> 0;
        };
    }
}

