/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item.mobcapturecard;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.item.mobcapturecard.BlankMobCaptureCardItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreativeBlankMobCaptureCardItem
extends BlankMobCaptureCardItem {
    public static final String ID = "creative_blank_mob_capture_card";
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");

    public CreativeBlankMobCaptureCardItem() {
        super(new Item.Properties());
    }

    public CreativeBlankMobCaptureCardItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        if (livingEntity == null || livingEntity instanceof Player || livingEntity.m_21224_()) {
            return InteractionResult.FAIL;
        }
        Level level = livingEntity.m_9236_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack mobCaptureCardItemStack = MobCaptureManager.getMobCaptureCardItem(livingEntity);
        if (mobCaptureCardItemStack == null || mobCaptureCardItemStack.m_41619_()) {
            log.error("Failed to capture entity {}", (Object)livingEntity);
            return InteractionResult.FAIL;
        }
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(mobCaptureCardItemStack);
        if (mobCaptureData == null || mobCaptureData.entityType() == null) {
            log.error("Failed to get mob capture data for entity {}", (Object)livingEntity);
            return InteractionResult.FAIL;
        }
        if (player.m_150110_().f_35937_) {
            ItemStack mobCaptureCardItemStackCopy = mobCaptureCardItemStack.m_41777_();
            if (!player.m_36356_(mobCaptureCardItemStack)) {
                log.error("Failed to add mob capture card {} to player {}", (Object)mobCaptureCardItemStack, (Object)player);
                return InteractionResult.FAIL;
            }
            log.info("Added mob capture card {} to players inventory {}", (Object)mobCaptureCardItemStackCopy, (Object)player);
        } else {
            player.m_21008_(hand, mobCaptureCardItemStack);
            log.info("Set mob capture card {} to players hand {}", (Object)player.m_21120_(hand), (Object)player);
        }
        livingEntity.m_142687_(Entity.RemovalReason.KILLED);
        return InteractionResult.CONSUME;
    }
}

