/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmodifier;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.ClientEvents;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.buildmodifier.Array;
import nl.requios.effortlessbuilding.buildmodifier.BaseModifier;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;
import nl.requios.effortlessbuilding.create.foundation.gui.AbstractSimiScreen;
import nl.requios.effortlessbuilding.create.foundation.gui.AllIcons;
import nl.requios.effortlessbuilding.create.foundation.gui.element.RenderElement;
import nl.requios.effortlessbuilding.create.foundation.gui.widget.AbstractSimiWidget;
import nl.requios.effortlessbuilding.create.foundation.gui.widget.BoxWidget;
import nl.requios.effortlessbuilding.create.foundation.utility.Components;
import nl.requios.effortlessbuilding.gui.buildmodifier.ArrayEntry;
import nl.requios.effortlessbuilding.gui.buildmodifier.BaseModifierEntry;
import nl.requios.effortlessbuilding.gui.buildmodifier.MirrorEntry;
import nl.requios.effortlessbuilding.gui.buildmodifier.ModifiersScreenList;
import nl.requios.effortlessbuilding.gui.buildmodifier.RadialMirrorEntry;

@OnlyIn(value=Dist.CLIENT)
public class ModifiersScreen
extends AbstractSimiScreen {
    protected ModifiersScreenList list;
    protected BoxWidget addArrayButton;
    protected BoxWidget addMirrorButton;
    protected BoxWidget addRadialMirrorButton;
    protected BoxWidget closeButton;

    public ModifiersScreen() {
        super((Component)Component.m_237115_((String)"effortlessbuilding.screen.modifier_settings"));
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int listWidth = Math.min(this.f_96543_ - 80, 300);
        int yCenter = this.f_96544_ / 2;
        int listL = this.f_96543_ / 2 - listWidth / 2;
        int listR = this.f_96543_ / 2 + listWidth / 2;
        this.list = new ModifiersScreenList(this.f_96541_, listWidth, this.f_96544_ - 80, 45, this.f_96544_ - 45, 68);
        this.list.m_93507_(this.f_96543_ / 2 - this.list.getWidth() / 2);
        this.m_142416_(this.list);
        this.initScrollEntries();
        this.addArrayButton = (BoxWidget)((AbstractSimiWidget)new BoxWidget(listR - 90, 10, 20, 20).withPadding(2.0f, 2.0f)).withCallback(() -> this.addModifier(new Array()));
        this.addArrayButton.showingElement((RenderElement)AllIcons.I_ADD.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.addArrayButton)));
        this.addArrayButton.getToolTip().add((Component)Components.literal("Add Array"));
        this.addMirrorButton = (BoxWidget)((AbstractSimiWidget)new BoxWidget(listR - 60, 10, 20, 20).withPadding(2.0f, 2.0f)).withCallback(() -> this.addModifier(new Mirror()));
        this.addMirrorButton.showingElement((RenderElement)AllIcons.I_ADD.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.addMirrorButton)));
        this.addMirrorButton.getToolTip().add((Component)Components.literal("Add Mirror"));
        this.addRadialMirrorButton = (BoxWidget)((AbstractSimiWidget)new BoxWidget(listR - 30, 10, 20, 20).withPadding(2.0f, 2.0f)).withCallback(() -> this.addModifier(new RadialMirror()));
        this.addRadialMirrorButton.showingElement((RenderElement)AllIcons.I_ADD.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.addRadialMirrorButton)));
        this.addRadialMirrorButton.getToolTip().add((Component)Components.literal("Add Radial Mirror"));
        this.closeButton = (BoxWidget)((AbstractSimiWidget)new BoxWidget(listL - 30, yCenter - 10, 20, 20).withPadding(2.0f, 2.0f)).withCallback(this::m_7379_);
        this.closeButton.showingElement((RenderElement)AllIcons.I_CONFIG_BACK.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.closeButton)));
        this.closeButton.getToolTip().add((Component)Components.literal("Close"));
        this.m_142416_(this.addArrayButton);
        this.m_142416_(this.addMirrorButton);
        this.m_142416_(this.addRadialMirrorButton);
        this.m_142416_(this.closeButton);
    }

    private void initScrollEntries() {
        this.list.m_6702_().clear();
        List<BaseModifier> modifierSettingsList = EffortlessBuildingClient.BUILD_MODIFIERS.getModifierSettingsList();
        for (BaseModifier modifier : modifierSettingsList) {
            BaseModifierEntry entry = this.createModifierPanel(modifier);
            this.list.m_6702_().add(entry);
        }
    }

    private BaseModifierEntry createModifierPanel(BaseModifier modifier) {
        if (modifier instanceof Mirror) {
            return new MirrorEntry(this, modifier);
        }
        if (modifier instanceof Array) {
            return new ArrayEntry(this, modifier);
        }
        if (modifier instanceof RadialMirror) {
            return new RadialMirrorEntry(this, modifier);
        }
        return null;
    }

    private void addModifier(BaseModifier modifier) {
        BaseModifierEntry entry = this.createModifierPanel(modifier);
        this.list.m_6702_().add(entry);
        EffortlessBuildingClient.BUILD_MODIFIERS.addModifierSettings(modifier);
    }

    public void removeModifier(BaseModifierEntry entry) {
        this.list.m_6702_().remove(entry);
        EffortlessBuildingClient.BUILD_MODIFIERS.removeModifierSettings((BaseModifier)entry.modifier);
    }

    public boolean canMoveUp(BaseModifierEntry modifierEntry) {
        int index = this.list.m_6702_().indexOf(modifierEntry);
        return index > 0;
    }

    public boolean canMoveDown(BaseModifierEntry modifierEntry) {
        int index = this.list.m_6702_().indexOf(modifierEntry);
        return index < this.list.m_6702_().size() - 1;
    }

    public void moveModifierUp(BaseModifierEntry modifierEntry) {
        int index = this.list.m_6702_().indexOf(modifierEntry);
        if (index == 0) {
            return;
        }
        Collections.swap(this.list.m_6702_(), index, index - 1);
        EffortlessBuildingClient.BUILD_MODIFIERS.moveUp((BaseModifier)modifierEntry.modifier);
    }

    public void moveModifierDown(BaseModifierEntry modifierEntry) {
        int index = this.list.m_6702_().indexOf(modifierEntry);
        if (index == this.list.m_6702_().size() - 1) {
            return;
        }
        Collections.swap(this.list.m_6702_(), index, index + 1);
        EffortlessBuildingClient.BUILD_MODIFIERS.moveDown((BaseModifier)modifierEntry.modifier);
    }

    public void m_6574_(@Nonnull Minecraft client, int width, int height) {
        double scroll = this.list.m_93517_();
        this.m_6575_(client, width, height);
        this.list.m_93410_(scroll);
    }

    @Override
    protected void renderWindow(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void m_7379_() {
        super.m_7379_();
        EffortlessBuildingClient.BUILD_MODIFIERS.save();
    }

    @Override
    public boolean m_7933_(int keyCode, int p_96553_, int p_96554_) {
        if (keyCode == ClientEvents.keyBindings[1].getKey().m_84873_()) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, p_96553_, p_96554_);
    }
}

