/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.handrails;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import javax.annotation.Nullable;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.escalated.handrails.AbstractHandrailBlock;
import rbasamoyai.escalated.handrails.HandrailBlockEntity;
import rbasamoyai.escalated.index.EscalatedBlockPartials;
import rbasamoyai.escalated.index.EscalatedSpriteShiftEntries;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class HandrailRenderer
extends SafeBlockEntityRenderer<HandrailBlockEntity> {
    public HandrailRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(HandrailBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.m_58904_())) {
            return;
        }
        BlockState state = be.m_58900_();
        Block block = state.m_60734_();
        if (!(block instanceof AbstractHandrailBlock)) {
            return;
        }
        AbstractHandrailBlock handrailBlock = (AbstractHandrailBlock)block;
        VertexConsumer vcons = bufferSource.m_6299_(RenderType.m_110451_());
        WalkwaySlope slope = handrailBlock.getHandrailSlope(state);
        boolean end = handrailBlock.isEndHandrail(state);
        AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)state.m_61143_(AbstractHandrailBlock.SIDE));
        Direction facing = (Direction)state.m_61143_((Property)AbstractHandrailBlock.f_54117_);
        DyeColor handrailColor = be.getHandrailColor();
        PartialModel model = HandrailRenderer.getHandrailModel(slope, end);
        SuperByteBuffer buf = CachedBuffers.partialFacing((PartialModel)model, (BlockState)state, (Direction)facing.m_122424_());
        SpriteShiftEntry spriteShift = HandrailRenderer.getSpriteShift(handrailColor);
        float scroll = HandrailRenderer.getScrollOffset(be, partialTicks, facing, spriteShift.getTarget().m_118411_(), spriteShift.getTarget().m_118412_());
        if (side == AbstractHandrailBlock.Side.LEFT || side == AbstractHandrailBlock.Side.BOTH) {
            ms.m_85836_();
            Direction left = facing.m_122428_();
            ms.m_252880_((float)(left.m_122429_() * 7) / 16.0f, 0.0f, (float)(left.m_122431_() * 7) / 16.0f);
            buf.light(light).shiftUVScrolling(spriteShift, scroll).renderInto(ms, vcons);
            ms.m_85849_();
        }
        if (side == AbstractHandrailBlock.Side.RIGHT || side == AbstractHandrailBlock.Side.BOTH) {
            ms.m_85836_();
            Direction right = facing.m_122427_();
            ms.m_252880_((float)(right.m_122429_() * 7) / 16.0f, 0.0f, (float)(right.m_122431_() * 7) / 16.0f);
            buf.light(light).shiftUVScrolling(spriteShift, scroll).renderInto(ms, vcons);
            ms.m_85849_();
        }
    }

    public static PartialModel getHandrailModel(WalkwaySlope slope, boolean end) {
        return switch (slope) {
            default -> throw new IncompatibleClassChangeError();
            case WalkwaySlope.HORIZONTAL -> EscalatedBlockPartials.HANDRAIL_HORIZONTAL;
            case WalkwaySlope.BOTTOM -> EscalatedBlockPartials.HANDRAIL_BOTTOM;
            case WalkwaySlope.MIDDLE -> EscalatedBlockPartials.HANDRAIL_MIDDLE;
            case WalkwaySlope.TOP -> EscalatedBlockPartials.HANDRAIL_TOP;
            case WalkwaySlope.TERMINAL -> end ? EscalatedBlockPartials.HANDRAIL_END : EscalatedBlockPartials.HANDRAIL_START;
        };
    }

    public static SpriteShiftEntry getSpriteShift(@Nullable DyeColor color) {
        return color == null ? EscalatedSpriteShiftEntries.HANDRAIL : EscalatedSpriteShiftEntries.DYED_HANDRAILS.getOrDefault(color, EscalatedSpriteShiftEntries.HANDRAIL);
    }

    public static float getScrollOffset(HandrailBlockEntity be, float partialTicks, Direction facing, float v0, float v1) {
        float speed = be.getSpeed();
        float stepOffset = be.getVisualProgress() + partialTicks * speed;
        if (facing == Direction.NORTH || facing == Direction.EAST) {
            stepOffset *= -1.0f;
        }
        return (v1 - v0) * (stepOffset += 1.0f) / 3.0f;
    }
}

