/*
 * Decompiled with CFR 0.152.
 */
package com.exline.exlinecopperequipment.init;

import com.exline.exlinecopperequipment.items.CopperArmorMaterial;
import com.exline.exlinecopperequipment.items.CopperToolMaterial;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ItemInit {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"exlinecopperequipment");
    private static boolean isInitialised;
    public static final RegistryObject<Item> COPPER_NUGGET;
    public static final RegistryObject<SwordItem> COPPER_SWORD;
    public static final RegistryObject<ArmorItem> COPPER_HELM;
    public static final RegistryObject<ArmorItem> COPPER_CHEST;
    public static final RegistryObject<ArmorItem> COPPER_LEGGS;
    public static final RegistryObject<ArmorItem> COPPER_BOOTS;
    public static final RegistryObject<ShovelItem> COPPER_SHOVEL;
    public static final RegistryObject<PickaxeItem> COPPER_PICK;
    public static final RegistryObject<AxeItem> COPPER_AXE;
    public static final RegistryObject<HoeItem> COPPER_HOE;
    public static final RegistryObject<HorseArmorItem> HORSE_ARMOR_COPPER;

    public static void register(IEventBus modEventBus) {
        if (isInitialised) {
            throw new IllegalStateException("Already initialised");
        }
        ITEMS.register(modEventBus);
        isInitialised = true;
    }

    static {
        COPPER_NUGGET = ITEMS.register("copper_nugget", () -> new Item(new Item.Properties()));
        COPPER_SWORD = ITEMS.register("copper_sword", () -> new SwordItem((Tier)CopperToolMaterial.COPPER, 0, -2.4f, new Item.Properties()));
        COPPER_HELM = ITEMS.register("copper_helmet", () -> new ArmorItem((ArmorMaterial)CopperArmorMaterial.COPPER, ArmorItem.Type.HELMET, new Item.Properties()));
        COPPER_CHEST = ITEMS.register("copper_chestplate", () -> new ArmorItem((ArmorMaterial)CopperArmorMaterial.COPPER, ArmorItem.Type.CHESTPLATE, new Item.Properties()));
        COPPER_LEGGS = ITEMS.register("copper_leggings", () -> new ArmorItem((ArmorMaterial)CopperArmorMaterial.COPPER, ArmorItem.Type.LEGGINGS, new Item.Properties()));
        COPPER_BOOTS = ITEMS.register("copper_boots", () -> new ArmorItem((ArmorMaterial)CopperArmorMaterial.COPPER, ArmorItem.Type.BOOTS, new Item.Properties()));
        COPPER_SHOVEL = ITEMS.register("copper_shovel", () -> new ShovelItem((Tier)CopperToolMaterial.COPPER, -1.5f, -3.0f, new Item.Properties()));
        COPPER_PICK = ITEMS.register("copper_pickaxe", () -> new PickaxeItem((Tier)CopperToolMaterial.COPPER, -2, -2.8f, new Item.Properties()));
        COPPER_AXE = ITEMS.register("copper_axe", () -> new AxeItem((Tier)CopperToolMaterial.COPPER, 3.5f, -3.1f, new Item.Properties()));
        COPPER_HOE = ITEMS.register("copper_hoe", () -> new HoeItem((Tier)CopperToolMaterial.COPPER, -4, -1.0f, new Item.Properties()));
        HORSE_ARMOR_COPPER = ITEMS.register("copper_horse_armor", () -> new HorseArmorItem(3, "copper", new Item.Properties()));
    }
}

