/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.recipes.AbstractMachineRecipe;
import net.permutated.exmachinis.util.IngredientStack;
import net.permutated.exmachinis.util.SerializerUtil;

public class CompactingRecipe
extends AbstractMachineRecipe {
    public static final CompactingRecipe EMPTY = new CompactingRecipe(new ResourceLocation("empty"), IngredientStack.EMPTY, ItemStack.f_41583_);
    private final IngredientStack ingredient;
    private final ItemStack output;

    public CompactingRecipe(ResourceLocation id, IngredientStack input, ItemStack output) {
        super(id);
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        Preconditions.checkState((input.count() > 0 ? 1 : 0) != 0, (Object)"input count must be greater than 0");
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        this.ingredient = input;
        this.output = output;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistry.COMPACTING_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRegistry.COMPACTING_RECIPE_TYPE.get();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.ingredient.toNetwork(buffer);
        buffer.m_130055_(this.output);
    }

    public IngredientStack getIngredient() {
        return this.ingredient;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public static class Serializer
    implements RecipeSerializer<CompactingRecipe> {
        public CompactingRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            IngredientStack input = IngredientStack.fromJson(jsonObject.getAsJsonObject("input"));
            ItemStack output = SerializerUtil.getItemStack(jsonObject, "output");
            return new CompactingRecipe(resourceLocation, input, output);
        }

        @Nullable
        public CompactingRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buffer) {
            IngredientStack input = IngredientStack.fromNetwork(buffer);
            ItemStack output = buffer.m_130267_();
            return new CompactingRecipe(resourceLocation, input, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, CompactingRecipe compactingRecipe) {
            compactingRecipe.write(buffer);
        }
    }
}

