/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.crafttweaker.handler;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.recipe.component.RecipeComponentEqualityCheckers;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.google.gson.reflect.TypeToken;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import novamachina.exnihilosequentia.world.item.crafting.CompostRecipe;

@IRecipeHandler.For(value=CompostRecipe.class)
public class CompostRecipeHandler
implements IRecipeHandler<CompostRecipe> {
    IRecipeComponent<Integer> OUTPUT_AMOUNT = IRecipeComponent.simple((ResourceLocation)new ResourceLocation("exnihilosequentia", "output/amount"), (TypeToken)new TypeToken<Integer>(){}, RecipeComponentEqualityCheckers::areNumbersEqual);

    public String dumpToCommandString(IRecipeManager<? super CompostRecipe> manager, CompostRecipe recipe) {
        return String.format("<recipetype:exnihilosequentia:compost>.addRecipe(%s, %s, %d);", StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()), IIngredient.fromIngredient((Ingredient)recipe.getInput()).getCommandString(), recipe.getAmount());
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super CompostRecipe> manager, CompostRecipe firstRecipe, U secondRecipe) {
        CompostRecipe second = (CompostRecipe)secondRecipe;
        return IngredientUtil.canConflict((Ingredient)firstRecipe.getInput(), (Ingredient)second.getInput());
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super CompostRecipe> manager, CompostRecipe recipe) {
        IIngredient ingredient = IIngredient.fromIngredient((Ingredient)recipe.getInput());
        IDecomposedRecipe decomposition = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Input.INGREDIENTS, (Object)ingredient).with(this.OUTPUT_AMOUNT, (Object)recipe.getAmount()).build();
        return Optional.of(decomposition);
    }

    public Optional<CompostRecipe> recompose(IRecipeManager<? super CompostRecipe> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        IIngredient input = (IIngredient)recipe.getOrThrowSingle(BuiltinRecipeComponents.Input.INGREDIENTS);
        int amount = (Integer)recipe.getOrThrowSingle(this.OUTPUT_AMOUNT);
        if (input.isEmpty()) {
            throw new IllegalArgumentException("Invalid input: empty ingredient");
        }
        if (amount <= 0) {
            throw new IllegalArgumentException("Invalid amount: less than min allowed 1: " + amount);
        }
        return Optional.of(new CompostRecipe(name, input.asVanillaIngredient(), amount));
    }
}

