/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import novamachina.exnihilosequentia.world.item.crafting.CompostRecipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompostRegistry {
    private static Logger log = LoggerFactory.getLogger(CompostRegistry.class);
    @Nonnull
    public final List<CompostRecipe> recipeList = new ArrayList<CompostRecipe>();
    private final LoadingCache<ItemLike, Integer> cache;

    public CompostRegistry() {
        CacheLoader<ItemLike, Integer> loader = new CacheLoader<ItemLike, Integer>(){

            public Integer load(ItemLike key) {
                return CompostRegistry.this.recipeList.stream().filter(compostRecipe -> compostRecipe.getInput().test(new ItemStack(key))).findFirst().map(CompostRecipe::getAmount).orElse(0);
            }
        };
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)loader);
    }

    public boolean containsSolid(@Nonnull ItemLike item) {
        return this.getSolidAmount(item) > 0;
    }

    public int getSolidAmount(@Nonnull ItemLike item) {
        try {
            return (Integer)this.cache.get((Object)item);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void setRecipes(@Nonnull List<CompostRecipe> recipes) {
        log.debug("Compost Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
        this.cache.invalidateAll();
    }

    @Nonnull
    public List<CompostRecipe> getRecipeList() {
        return this.recipeList;
    }

    public void clearRecipes() {
        this.recipeList.clear();
        this.cache.invalidateAll();
    }
}

