/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import novamachina.exnihilosequentia.common.compat.jei.melting.JEICrucibleRecipe;
import novamachina.exnihilosequentia.world.item.crafting.MeltingRecipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeltingRegistry {
    private static Logger log = LoggerFactory.getLogger(MeltingRegistry.class);
    @Nonnull
    private final List<MeltingRecipe> recipeList = new ArrayList<MeltingRecipe>();
    private final LoadingCache<ItemLike, Optional<MeltingRecipe>> cache;

    public MeltingRegistry() {
        CacheLoader<ItemLike, Optional<MeltingRecipe>> loader = new CacheLoader<ItemLike, Optional<MeltingRecipe>>(){

            public Optional<MeltingRecipe> load(ItemLike key) {
                return MeltingRegistry.this.recipeList.stream().filter(recipe -> recipe.getInput().test(new ItemStack(key))).findFirst();
            }
        };
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)loader);
    }

    @Nonnull
    public List<JEICrucibleRecipe> getRecipeList() {
        return this.recipeList.stream().flatMap(crucibleRecipe -> {
            if (crucibleRecipe.getInput().m_43908_().length <= 21) {
                return Stream.of(new JEICrucibleRecipe(crucibleRecipe.getResultFluid().getAmount(), crucibleRecipe.getCrucibleType(), Arrays.asList(crucibleRecipe.getInput().m_43908_()), crucibleRecipe.getResultFluid()));
            }
            List partitions = Lists.partition(List.of(crucibleRecipe.getInput().m_43908_()), (int)21);
            return partitions.stream().map(partition -> new JEICrucibleRecipe(crucibleRecipe.getResultFluid().getAmount(), crucibleRecipe.getCrucibleType(), (List<ItemStack>)partition, crucibleRecipe.getResultFluid()));
        }).collect(Collectors.toList());
    }

    public void setRecipes(@Nonnull List<MeltingRecipe> recipes) {
        log.debug("Crucible Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
        this.cache.invalidateAll();
    }

    @Nonnull
    public Optional<MeltingRecipe> findRecipe(ItemLike item) {
        try {
            return (Optional)this.cache.get((Object)item);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isMeltable(@Nonnull ItemLike item, int level) {
        Optional recipe = null;
        try {
            recipe = (Optional)this.cache.get((Object)item);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return recipe.isPresent() && ((MeltingRecipe)((Object)recipe.get())).getCrucibleType().getLevel() <= level;
    }

    public void clearRecipes() {
        this.recipeList.clear();
        this.cache.invalidateAll();
    }
}

